/*
 * Decompiled with CFR 0.152.
 */
package com.jpan.tfc.diving.bell.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="tfcdivingbell")
public class BreathEvents {
    public static final TagKey<Item> breathingReedTag = ItemTags.create((ResourceLocation)new ResourceLocation("tfcdivingbell", "breathing_reeds"));
    public static final TagKey<Item> snorkelTag = ItemTags.create((ResourceLocation)new ResourceLocation("tfcdivingbell", "snorkels"));
    public static final TagKey<Item> divingBellTag = ItemTags.create((ResourceLocation)new ResourceLocation("tfcdivingbell", "diving_bells"));
    public static final TagKey<Item> airhoseTag = ItemTags.create((ResourceLocation)new ResourceLocation("tfcdivingbell", "air_hose"));
    public static final TagKey<Item> divingHelmetTag = ItemTags.create((ResourceLocation)new ResourceLocation("tfcdivingbell", "diving_helmets"));
    public static final TagKey<Item> oxygenTankTag = ItemTags.create((ResourceLocation)new ResourceLocation("tfcdivingbell", "oxygen_tanks"));

    @SubscribeEvent
    public static void onPlayerTick(LivingEvent.LivingTickEvent evt) {
        boolean snorkel = false;
        if (evt.getEntity().m_20069_()) {
            for (ItemStack itm : evt.getEntity().m_6168_()) {
                if (itm.m_204117_(snorkelTag)) {
                    snorkel = true;
                    if (BreathEvents.closestAirAbove(evt.getEntity(), 3, true)) {
                        evt.getEntity().m_20301_(Math.min(evt.getEntity().m_20146_() + 5, evt.getEntity().m_6062_()));
                    }
                }
                if (itm.m_204117_(divingBellTag) && evt.getEntity().m_21206_().m_204117_(airhoseTag) && BreathEvents.closestAirAbove(evt.getEntity(), evt.getEntity().m_21206_().m_41613_(), false)) {
                    evt.getEntity().m_20301_(Math.min(evt.getEntity().m_20146_() + 5, evt.getEntity().m_6062_()));
                }
                if (!itm.m_204117_(divingHelmetTag) || !evt.getEntity().m_21206_().m_204117_(oxygenTankTag)) continue;
                while (evt.getEntity().m_20146_() < 300 && evt.getEntity().m_21206_().m_41773_() < evt.getEntity().m_21206_().m_41776_() - 2) {
                    evt.getEntity().m_20301_(Math.min(evt.getEntity().m_20146_() + 5, evt.getEntity().m_6062_()));
                    evt.getEntity().m_21206_().m_41721_(evt.getEntity().m_21206_().m_41773_() + 1);
                }
            }
            if (evt.getEntity().m_21206_().m_204117_(breathingReedTag) && !snorkel && BreathEvents.closestAirAbove(evt.getEntity(), 2, false)) {
                evt.getEntity().m_20301_(Math.min(evt.getEntity().m_20146_() + 5, evt.getEntity().m_6062_()));
            }
        }
    }

    public static boolean closestAirAbove(LivingEntity ent, int maxHeightInBlocks, boolean direct) {
        int xOffset = 0;
        int zOffset = 0;
        int yOffset = 0;
        for (int i = 0; i < maxHeightInBlocks; ++i) {
            BlockPos up = new BlockPos(ent.m_146903_() + xOffset, (int)Math.round(ent.m_20188_() + (double)yOffset), ent.m_146907_() + zOffset);
            if (ent.m_9236_().m_8055_(up).m_60795_()) {
                return true;
            }
            if (ent.m_9236_().m_8055_(up).m_60838_((BlockGetter)ent.m_9236_(), up)) {
                if (direct) {
                    return false;
                }
                boolean foundPath = false;
                int td = 1;
                while (!foundPath && i + td < maxHeightInBlocks) {
                    for (int x = -td; x <= td; ++x) {
                        for (int y = -td; y <= td; ++y) {
                            BlockPos upXZ = new BlockPos(ent.m_146903_() + xOffset + x, (int)Math.round(ent.m_20188_() + (double)yOffset), ent.m_146907_() + zOffset + y);
                            if (ent.m_9236_().m_8055_(upXZ).m_60795_()) {
                                return true;
                            }
                            if (!ent.m_9236_().m_6425_(upXZ).m_205070_(FluidTags.f_13131_)) continue;
                            i += Math.abs(x) + Math.abs(y);
                            xOffset += x;
                            zOffset += y;
                            ++yOffset;
                            foundPath = true;
                        }
                    }
                    if (foundPath) continue;
                    ++td;
                }
                i += td;
                continue;
            }
            ++yOffset;
        }
        return false;
    }
}

