/*
 * Decompiled with CFR 0.152.
 */
package com.ljuangbminecraft.tfcchannelcasting.common.recipes.outputs;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.ljuangbminecraft.tfcchannelcasting.common.recipes.outputs.DateRangeModifyCondition;
import com.ljuangbminecraft.tfcchannelcasting.common.recipes.outputs.HasTraitModifyCondition;
import com.ljuangbminecraft.tfcchannelcasting.common.recipes.outputs.ModifyCondition;
import java.util.Objects;
import net.dries007.tfc.util.JsonHelpers;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;

public class ModifyConditions {
    private static final BiMap<ResourceLocation, ModifyCondition.Serializer<?>> REGISTRY = HashBiMap.create();

    public static void registerItemStackModifierTypes() {
        ModifyConditions.register("date_range", DateRangeModifyCondition.Serializer.INSTANCE);
        ModifyConditions.register("has_trait", HasTraitModifyCondition.Serializer.INSTANCE);
    }

    public static synchronized <V extends ModifyCondition, T extends ModifyCondition.Serializer<V>> T register(ResourceLocation key, T serializer) {
        if (REGISTRY.containsKey((Object)key)) {
            throw new IllegalArgumentException("Duplicate key: " + key);
        }
        REGISTRY.put((Object)key, serializer);
        return serializer;
    }

    public static ModifyCondition fromJson(JsonElement json) {
        JsonObject obj = JsonHelpers.m_13918_((JsonElement)json, (String)"condition");
        String type = JsonHelpers.m_13906_((JsonObject)obj, (String)"type");
        ModifyCondition.Serializer<?> serializer = ModifyConditions.getSerializer(type);
        return serializer.fromJson(obj);
    }

    public static ModifyCondition fromNetwork(FriendlyByteBuf buffer) {
        ResourceLocation id = buffer.m_130281_();
        ModifyCondition.Serializer<?> serializer = ModifyConditions.byId(id);
        return serializer.fromNetwork(buffer);
    }

    private static ModifyCondition.Serializer<?> getSerializer(String type) {
        ModifyCondition.Serializer serializer = (ModifyCondition.Serializer)REGISTRY.get((Object)new ResourceLocation(type));
        if (serializer != null) {
            return serializer;
        }
        throw new JsonParseException("Unknown item stack modifier condition type: " + type);
    }

    public static ModifyCondition.Serializer<?> byId(ResourceLocation id) {
        return Objects.requireNonNull((ModifyCondition.Serializer)REGISTRY.get((Object)id), () -> "No serializer by id: " + id);
    }

    public static ResourceLocation getId(ModifyCondition.Serializer<?> serializer) {
        return Objects.requireNonNull((ResourceLocation)REGISTRY.inverse().get(serializer), () -> "Unregistered serializer: " + serializer);
    }

    private static void register(String name, ModifyCondition.Serializer<?> serializer) {
        ModifyConditions.register(new ResourceLocation("tfcchannelcasting", name), serializer);
    }
}

