/*
 * Decompiled with CFR 0.152.
 */
package com.ljuangbminecraft.tfcchannelcasting.common.recipes.outputs;

import com.google.gson.JsonObject;
import com.ljuangbminecraft.tfcchannelcasting.common.recipes.outputs.ModifyCondition;
import net.dries007.tfc.util.JsonHelpers;
import net.dries007.tfc.util.calendar.Calendars;
import net.dries007.tfc.util.calendar.Month;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;

public record DateRangeModifyCondition(int minCalendarDayOfMonth, Month minCalendarMonthOfYear, int maxCalendarDayOfMonth, Month maxCalendarMonthOfYear) implements ModifyCondition
{
    @Override
    public boolean shouldApply(ItemStack stack, ItemStack input) {
        int currentDay;
        int TOTAL_DAYS_IN_YEAR = Calendars.SERVER.getCalendarDaysInMonth() * Month.values().length;
        int minDay = DateRangeModifyCondition.getDayInt(this.minCalendarDayOfMonth, this.minCalendarMonthOfYear);
        int maxDay = DateRangeModifyCondition.getDayInt(this.maxCalendarDayOfMonth, this.maxCalendarMonthOfYear);
        if (maxDay < minDay) {
            minDay += TOTAL_DAYS_IN_YEAR;
        }
        return minDay <= (currentDay = DateRangeModifyCondition.getDayInt(Calendars.SERVER.getCalendarDayOfMonth(), Calendars.SERVER.getCalendarMonthOfYear())) && currentDay <= maxDay || minDay <= currentDay + TOTAL_DAYS_IN_YEAR && currentDay + TOTAL_DAYS_IN_YEAR <= maxDay;
    }

    private static int getDayInt(int calendarDayOfMonth, Month calendarMonthOfYear) {
        return calendarDayOfMonth + (calendarMonthOfYear.ordinal() - 1) * Calendars.SERVER.getCalendarDaysInMonth();
    }

    public Serializer serializer() {
        return Serializer.INSTANCE;
    }

    public static final class Serializer
    extends Enum<Serializer>
    implements ModifyCondition.Serializer<DateRangeModifyCondition> {
        public static final /* enum */ Serializer INSTANCE = new Serializer();
        private static final /* synthetic */ Serializer[] $VALUES;

        public static Serializer[] values() {
            return (Serializer[])$VALUES.clone();
        }

        public static Serializer valueOf(String name) {
            return Enum.valueOf(Serializer.class, name);
        }

        @Override
        public DateRangeModifyCondition fromJson(JsonObject json) {
            int minDay = JsonHelpers.m_13927_((JsonObject)json, (String)"min_day");
            int minMonth = JsonHelpers.m_13927_((JsonObject)json, (String)"min_month");
            int maxDay = JsonHelpers.m_13927_((JsonObject)json, (String)"max_day");
            int maxMonth = JsonHelpers.m_13927_((JsonObject)json, (String)"max_month");
            assert (minDay >= 1);
            assert (maxDay >= 1);
            assert (minMonth >= 1 && minMonth <= 12);
            assert (maxMonth >= 1 && maxMonth <= 12);
            return new DateRangeModifyCondition(minDay, Month.valueOf((int)(minMonth - 1)), maxDay, Month.valueOf((int)(maxMonth - 1)));
        }

        @Override
        public DateRangeModifyCondition fromNetwork(FriendlyByteBuf buffer) {
            int minDay = buffer.readInt();
            int minMonth = buffer.readInt();
            int maxDay = buffer.readInt();
            int maxMonth = buffer.readInt();
            return new DateRangeModifyCondition(minDay, Month.valueOf((int)minMonth), maxDay, Month.valueOf((int)maxMonth));
        }

        @Override
        public void toNetwork(DateRangeModifyCondition modifier, FriendlyByteBuf buffer) {
            buffer.writeInt(modifier.minCalendarDayOfMonth);
            buffer.writeInt(modifier.minCalendarMonthOfYear.ordinal());
            buffer.writeInt(modifier.maxCalendarDayOfMonth);
            buffer.writeInt(modifier.maxCalendarMonthOfYear.ordinal());
        }

        private static /* synthetic */ Serializer[] $values() {
            return new Serializer[]{INSTANCE};
        }

        static {
            $VALUES = Serializer.$values();
        }
    }
}

