/*
 * Decompiled with CFR 0.152.
 */
package com.ljuangbminecraft.tfcchannelcasting.common.blocks;

import com.ljuangbminecraft.tfcchannelcasting.common.blockentities.MoldBlockEntity;
import com.ljuangbminecraft.tfcchannelcasting.common.blockentities.TFCCCBlockEntities;
import com.ljuangbminecraft.tfcchannelcasting.common.blocks.ChannelBlock;
import java.util.Map;
import java.util.Optional;
import net.dries007.tfc.common.blocks.DirectionPropertyBlock;
import net.dries007.tfc.common.blocks.EntityBlockExtension;
import net.dries007.tfc.common.blocks.ExtendedBlock;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.devices.IBellowsConsumer;
import net.dries007.tfc.common.capabilities.MoldLike;
import net.dries007.tfc.util.Helpers;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class MoldBlock
extends ExtendedBlock
implements EntityBlockExtension,
IBellowsConsumer {
    public static final Map<Direction, BooleanProperty> PROPERTY_BY_DIRECTION = (Map)PipeBlock.f_55154_.entrySet().stream().filter(facing -> ((Direction)facing.getKey()).m_122434_().m_122479_()).collect(Util.m_137448_());
    public static final BooleanProperty NORTH = PipeBlock.f_55148_;
    public static final BooleanProperty EAST = PipeBlock.f_55149_;
    public static final BooleanProperty SOUTH = PipeBlock.f_55150_;
    public static final BooleanProperty WEST = PipeBlock.f_55151_;
    static final VoxelShape SHAPE = MoldBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)5.0, (double)16.0);

    private static BlockState updateConnectedSides(LevelAccessor level, BlockPos pos, BlockState state) {
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            BlockPos adjacentPos = pos.m_121945_(direction);
            BlockState adjacentState = level.m_8055_(adjacentPos);
            boolean adjacentChannel = adjacentState.m_60734_() instanceof ChannelBlock;
            state = (BlockState)state.m_61124_((Property)DirectionPropertyBlock.getProperty((Direction)direction), (Comparable)Boolean.valueOf(adjacentChannel));
        }
        return state;
    }

    public MoldBlock(ExtendedProperties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)EAST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{EAST, SOUTH, WEST, NORTH});
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            Optional mold = level.m_141902_(pos, (BlockEntityType)TFCCCBlockEntities.MOLD_TABLE.get());
            if (mold.isPresent()) {
                return ((MoldBlockEntity)((Object)mold.get())).onRightClick((Player)serverPlayer);
            }
        }
        return InteractionResult.FAIL;
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState adjacentState, LevelAccessor level, BlockPos pos, BlockPos adjacentPos) {
        return MoldBlock.updateConnectedSides(level, pos, state);
    }

    public boolean onDestroyedByPlayer(BlockState state, Level level, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        if (!level.m_5776_()) {
            level.m_141902_(pos, (BlockEntityType)TFCCCBlockEntities.MOLD_TABLE.get()).ifPresent(channel -> channel.finishFlow());
        }
        return super.onDestroyedByPlayer(state, level, pos, player, willHarvest, fluid);
    }

    public void onBlockExploded(BlockState state, Level level, BlockPos pos, Explosion explosion) {
        if (!level.m_5776_()) {
            level.m_141902_(pos, (BlockEntityType)TFCCCBlockEntities.MOLD_TABLE.get()).ifPresent(channel -> channel.finishFlow());
        }
        super.onBlockExploded(state, level, pos, explosion);
    }

    public boolean m_7278_(BlockState pState) {
        return true;
    }

    public int m_6782_(BlockState state, Level level, BlockPos pos) {
        return level.m_141902_(pos, (BlockEntityType)TFCCCBlockEntities.MOLD_TABLE.get()).map(mold -> {
            if (!mold.getOutputStack().m_41619_()) {
                return 15;
            }
            ItemStack moldStack = mold.getMoldStack();
            MoldLike moldItem = MoldLike.get((ItemStack)moldStack);
            if (moldItem != null) {
                return 1 + 13 * moldItem.getFluidInTank(0).getAmount() / moldItem.getTankCapacity(0);
            }
            return 0;
        }).orElse(0);
    }

    public void intakeAir(Level level, BlockPos pos, BlockState state, int amount) {
        level.m_141902_(pos, (BlockEntityType)TFCCCBlockEntities.MOLD_TABLE.get()).ifPresent(mold -> mold.intakeAir(amount));
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (newState.m_60734_() != state.m_60734_()) {
            level.m_141902_(pos, (BlockEntityType)TFCCCBlockEntities.MOLD_TABLE.get()).ifPresent(mold -> {
                Helpers.spawnItem((Level)level, (BlockPos)pos, (ItemStack)mold.getInventory().getStackInSlot(0));
                Helpers.spawnItem((Level)level, (BlockPos)pos, (ItemStack)mold.getInventory().getStackInSlot(1));
            });
        }
        super.m_6810_(state, level, pos, newState, isMoving);
    }
}

