/*
 * Decompiled with CFR 0.152.
 */
package com.ljuangbminecraft.tfcchannelcasting.common.blockentities;

import com.ljuangbminecraft.tfcchannelcasting.common.TFCCCTags;
import com.ljuangbminecraft.tfcchannelcasting.common.blockentities.ChannelBlockEntity;
import com.ljuangbminecraft.tfcchannelcasting.common.blockentities.TFCCCBlockEntities;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.dries007.tfc.common.blockentities.CrucibleBlockEntity;
import net.dries007.tfc.common.blockentities.InventoryBlockEntity;
import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.blockentities.TickableInventoryBlockEntity;
import net.dries007.tfc.common.capabilities.Capabilities;
import net.dries007.tfc.common.capabilities.MoldLike;
import net.dries007.tfc.common.capabilities.PartialFluidHandler;
import net.dries007.tfc.common.capabilities.PartialItemHandler;
import net.dries007.tfc.common.capabilities.SidedHandler;
import net.dries007.tfc.common.capabilities.heat.HeatCapability;
import net.dries007.tfc.common.capabilities.heat.IHeat;
import net.dries007.tfc.common.capabilities.heat.IHeatBlock;
import net.dries007.tfc.common.recipes.CastingRecipe;
import net.dries007.tfc.common.recipes.TFCRecipeTypes;
import net.dries007.tfc.common.recipes.ingredients.FluidStackIngredient;
import net.dries007.tfc.common.recipes.ingredients.ItemStackIngredient;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.Metal;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.tuple.Pair;

public class MoldBlockEntity
extends TickableInventoryBlockEntity<MoldBlockInventory> {
    private Optional<BlockPos> sourcePosition = Optional.empty();
    private Optional<Pair<Direction, Byte>> flowSource = Optional.empty();
    private Optional<Fluid> fluid = Optional.empty();
    private final SidedHandler.Builder<IFluidHandler> sidedFluidInventory = new SidedHandler.Builder((Object)((IFluidHandler)this.inventory));
    private final SidedHandler.Builder<IHeatBlock> sidedHeatInventory = new SidedHandler.Builder((Object)((IHeatBlock)this.inventory));
    public static final int MOLD_SLOT = 0;
    public static final int OUTPUT_SLOT = 1;
    private static final Component NAME = Component.m_237113_((String)"Mold table");

    public static void serverTick(Level level, BlockPos pos, BlockState state, MoldBlockEntity mold) {
        CastingRecipe recipe;
        ItemStack drainStack;
        MoldLike moldItem;
        if (!mold.getOutputStack().m_41619_()) {
            if (mold.hasSource()) {
                mold.finishFlow();
            }
            return;
        }
        if (mold.hasSource() && level.m_46467_() % 2L == 0L) {
            level.m_141902_(mold.sourcePosition.get(), (BlockEntityType)TFCBlockEntities.CRUCIBLE.get()).ifPresent(crucible -> {
                Optional<IFluidHandler> fHandler = MoldBlockEntity.getFluidHandlerIfAppropriate(crucible, mold.fluid);
                if (fHandler.isEmpty() || mold.isLinkBroken()) {
                    mold.finishFlow();
                    return;
                }
                FluidStack outputDrop = fHandler.get().drain(1, IFluidHandler.FluidAction.SIMULATE);
                FluidStack outputRemainder = Helpers.mergeOutputFluidIntoSlot((IItemHandlerModifiable)mold.getInventory(), (FluidStack)outputDrop, (float)crucible.getTemperature(), (int)0);
                mold.getMoldStack().getCapability(HeatCapability.CAPABILITY).ifPresent(heatCap -> heatCap.setTemperature(crucible.getTemperature()));
                if (outputRemainder.isEmpty()) {
                    fHandler.get().drain(1, IFluidHandler.FluidAction.EXECUTE);
                    crucible.markForSync();
                    mold.markForBlockUpdate();
                } else {
                    mold.finishFlow();
                }
            });
        }
        if ((moldItem = MoldLike.get((ItemStack)(drainStack = ((MoldBlockInventory)mold.inventory).getStackInSlot(0)))) != null && !moldItem.isMolten() && (recipe = CastingRecipe.get((MoldLike)moldItem)) != null) {
            Optional.ofNullable(recipe.assemble(moldItem, level.m_9598_())).ifPresent(stack -> {
                ((MoldBlockInventory)mold.inventory).setStackInSlot(1, (ItemStack)stack);
                moldItem.drainIgnoringTemperature(Integer.MAX_VALUE, IFluidHandler.FluidAction.EXECUTE);
            });
        }
    }

    public static Optional<IFluidHandler> getFluidHandlerIfAppropriate(CrucibleBlockEntity crucible, Optional<Fluid> shouldBeFluid) {
        IFluidHandler crucibleFluidHandler = (IFluidHandler)crucible.getCapability(Capabilities.FLUID).resolve().get();
        IHeatBlock crucibleHeatHandler = (IHeatBlock)crucible.getCapability(HeatCapability.BLOCK_CAPABILITY).resolve().get();
        Metal metal = Metal.get((Fluid)crucibleFluidHandler.getFluidInTank(0).getFluid());
        if (metal == null || shouldBeFluid.isPresent() && ForgeRegistries.FLUIDS.getKey((Object)metal.getFluid()) != ForgeRegistries.FLUIDS.getKey((Object)shouldBeFluid.get()) || metal.getMeltTemperature() > crucibleHeatHandler.getTemperature()) {
            return Optional.empty();
        }
        return Optional.of(crucibleFluidHandler);
    }

    public MoldBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)TFCCCBlockEntities.MOLD_TABLE.get(), pos, state, MoldBlockInventory::new, NAME);
        this.sidedFluidInventory.on((Object)new PartialFluidHandler((IFluidHandler)this.inventory).insert(), new Direction[]{Direction.WEST, Direction.EAST, Direction.NORTH, Direction.SOUTH, Direction.UP});
        PartialItemHandler handler = new PartialItemHandler(this.inventory);
        this.sidedInventory.on((Object)handler.insert(new int[]{0}), new Direction[]{Direction.UP}).on((Object)handler.extract(new int[]{1}), new Direction[]{Direction.DOWN});
    }

    public boolean hasSource() {
        return this.sourcePosition.isPresent();
    }

    public void finishFlow() {
        this.flowSource.ifPresent(fSource -> {
            this.f_58857_.m_141902_(this.f_58858_.m_5484_((Direction)fSource.getLeft(), (int)((Byte)fSource.getRight()).byteValue()), (BlockEntityType)TFCCCBlockEntities.CHANNEL.get()).ifPresent(channel -> channel.notifyBrokenLink(1));
            this.markForBlockUpdate();
            this.sourcePosition = Optional.empty();
            this.fluid = Optional.empty();
            this.flowSource = Optional.empty();
        });
    }

    public void setSource(BlockPos sourcePos, Fluid fluid, Pair<Direction, Byte> flowSource) {
        this.sourcePosition = Optional.of(sourcePos);
        this.fluid = Optional.of(fluid);
        this.flowSource = Optional.of(flowSource);
    }

    public boolean isLinkBroken() {
        Optional bEntity = this.f_58857_.m_141902_(this.f_58858_.m_5484_((Direction)this.flowSource.get().getLeft(), (int)((Byte)this.flowSource.get().getRight()).byteValue()), (BlockEntityType)TFCCCBlockEntities.CHANNEL.get());
        if (bEntity.isEmpty()) {
            return true;
        }
        for (byte i = 1; i < (Byte)this.flowSource.get().getRight(); i = (byte)(i + 1)) {
            BlockPos rel = this.f_58858_.m_5484_((Direction)this.flowSource.get().getLeft(), (int)i);
            if (this.f_58857_.m_8055_(rel).m_60795_()) continue;
            return true;
        }
        return ((ChannelBlockEntity)((Object)bEntity.get())).isLinkBroken();
    }

    public Fluid getSourceFluid() {
        return this.fluid.get();
    }

    public Pair<Direction, Byte> getFlowSource() {
        return this.flowSource.get();
    }

    public ItemStackHandler getInventory() {
        return (ItemStackHandler)this.inventory;
    }

    public ItemStack getMoldStack() {
        return ((MoldBlockInventory)this.inventory).getStackInSlot(0);
    }

    public ItemStack getOutputStack() {
        return ((MoldBlockInventory)this.inventory).getStackInSlot(1);
    }

    public void setMoldStack(ItemStack stack) {
        ((MoldBlockInventory)this.inventory).setStackInSlot(0, stack);
    }

    public void setOutputStack(ItemStack stack) {
        ((MoldBlockInventory)this.inventory).setStackInSlot(1, stack);
    }

    public InteractionResult onRightClick(Player player) {
        boolean interactWithMoldSlot;
        boolean bl = interactWithMoldSlot = player.m_6144_() || ((MoldBlockInventory)this.inventory).getStackInSlot(0).m_41619_();
        if (interactWithMoldSlot) {
            boolean shouldInsert;
            ItemStack heldItem = player.m_21205_();
            boolean shouldExtract = !((MoldBlockInventory)this.inventory).getStackInSlot(0).m_41619_();
            boolean bl2 = shouldInsert = !heldItem.m_41619_() && this.isItemValid(0, heldItem);
            if (shouldExtract) {
                ItemStack extracted;
                if (shouldInsert) {
                    extracted = ((MoldBlockInventory)this.inventory).extractItem(0, 1, false);
                    ((MoldBlockInventory)this.inventory).insertItem(0, heldItem.m_41620_(1), false);
                    if (!this.f_58857_.f_46443_) {
                        ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)extracted, (int)player.m_150109_().f_35977_);
                    }
                } else if (!this.f_58857_.f_46443_) {
                    ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)((MoldBlockInventory)this.inventory).extractItem(0, 1, false), (int)player.m_150109_().f_35977_);
                }
                extracted = ((MoldBlockInventory)this.inventory).extractItem(1, 99, false);
                if (!this.f_58857_.f_46443_) {
                    ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)extracted, (int)player.m_150109_().f_35977_);
                }
                this.markForBlockUpdate();
                return InteractionResult.m_19078_((boolean)this.f_58857_.f_46443_);
            }
            if (shouldInsert) {
                ((MoldBlockInventory)this.inventory).insertItem(0, heldItem.m_41620_(1), false);
                this.markForBlockUpdate();
                return InteractionResult.m_19078_((boolean)this.f_58857_.f_46443_);
            }
        } else {
            boolean shouldExtract;
            boolean bl3 = shouldExtract = !((MoldBlockInventory)this.inventory).getStackInSlot(1).m_41619_();
            if (shouldExtract) {
                if (!this.f_58857_.f_46443_) {
                    ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)((MoldBlockInventory)this.inventory).extractItem(1, 1, false), (int)player.m_150109_().f_35977_);
                }
                this.markForBlockUpdate();
                return InteractionResult.m_19078_((boolean)this.f_58857_.f_46443_);
            }
        }
        return InteractionResult.PASS;
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        if (slot == 0) {
            return Helpers.isItem((ItemStack)stack, TFCCCTags.Items.ACCEPTED_IN_MOLD_TABLES);
        }
        return true;
    }

    public int getSlotStackLimit(int slot) {
        return 1;
    }

    public void loadAdditional(CompoundTag nbt) {
        if (nbt.m_128441_("sourcePosition")) {
            this.sourcePosition = Optional.of(BlockPos.m_122022_((long)nbt.m_128454_("sourcePosition")));
            this.flowSource = Optional.of(Pair.of((Object)Direction.values()[nbt.m_128445_("flowSource")], (Object)(nbt.m_128441_("flowSourceDistance") ? nbt.m_128445_("flowSourceDistance") : (byte)1)));
            this.fluid = Optional.of((Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation(nbt.m_128461_("fluid"))));
        } else {
            this.sourcePosition = Optional.empty();
            this.flowSource = Optional.empty();
            this.fluid = Optional.empty();
        }
        super.loadAdditional(nbt);
    }

    public void m_183515_(CompoundTag nbt) {
        if (this.hasSource()) {
            nbt.m_128356_("sourcePosition", this.sourcePosition.get().m_121878_());
            nbt.m_128344_("flowSource", (byte)((Direction)this.flowSource.get().getLeft()).ordinal());
            nbt.m_128344_("flowSourceDistance", ((Byte)this.flowSource.get().getRight()).byteValue());
            nbt.m_128359_("fluid", ForgeRegistries.FLUIDS.getKey((Object)this.fluid.get()).toString());
        }
        super.m_183515_(nbt);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        if (cap == Capabilities.FLUID) {
            return this.sidedFluidInventory.getSidedHandler(side).cast();
        }
        if (cap == HeatCapability.BLOCK_CAPABILITY) {
            return this.sidedHeatInventory.getSidedHandler(side).cast();
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCapabilities() {
        this.sidedInventory.invalidate();
        this.sidedFluidInventory.invalidate();
        this.sidedHeatInventory.invalidate();
    }

    public AABB getRenderBoundingBox() {
        if (this.flowSource.isPresent()) {
            if (this.flowSource.get().getLeft() == Direction.UP) {
                return new AABB(this.f_58858_.m_7918_(-1, 0, -1), this.f_58858_.m_7918_(2, 1 + (Byte)this.flowSource.get().getRight(), 2));
            }
            return new AABB(this.f_58858_.m_7918_(-1, 0, -1), this.f_58858_.m_7918_(2, 2, 2));
        }
        return super.getRenderBoundingBox();
    }

    public void intakeAir(int amount) {
        ItemStack drainStack = ((MoldBlockInventory)this.inventory).getStackInSlot(0);
        Optional.ofNullable(MoldLike.get((ItemStack)drainStack)).ifPresent(moldItem -> moldItem.setTemperature(Math.max(0.0f, moldItem.getTemperature() - (float)(amount / 4))));
    }

    static class MoldBlockInventory
    extends ItemStackHandler
    implements IFluidHandler,
    IHeatBlock {
        private final MoldBlockEntity moldTable;

        MoldBlockInventory(InventoryBlockEntity<?> entity) {
            super(2);
            this.moldTable = (MoldBlockEntity)entity;
        }

        protected void onContentsChanged(int slot) {
            this.moldTable.markForBlockUpdate();
        }

        private Optional<IFluidHandler> getMoldFluidHandler() {
            return this.moldTable.getMoldStack().getCapability(Capabilities.FLUID).map(t -> t);
        }

        private Optional<IHeat> getMoldHeatHandler() {
            return this.moldTable.getMoldStack().getCapability(HeatCapability.CAPABILITY).map(t -> t);
        }

        public float getTemperature() {
            return this.getMoldHeatHandler().map(h -> Float.valueOf(h.getTemperature())).orElse(Float.valueOf(0.0f)).floatValue();
        }

        public void setTemperature(float temp) {
            this.getMoldHeatHandler().ifPresent(h -> h.setTemperature(temp));
        }

        public int getTanks() {
            return this.getMoldFluidHandler().map(h -> h.getTanks()).orElse(0);
        }

        @Nonnull
        public FluidStack getFluidInTank(int tank) {
            return this.getMoldFluidHandler().map(h -> h.getFluidInTank(tank)).orElse(FluidStack.EMPTY.copy());
        }

        public int getTankCapacity(int tank) {
            return this.getMoldFluidHandler().map(h -> h.getTankCapacity(tank)).orElse(0);
        }

        public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
            return this.getMoldFluidHandler().map(h -> h.isFluidValid(tank, stack)).orElse(false);
        }

        public int fill(FluidStack fluid, IFluidHandler.FluidAction action) {
            RecipeManager recipeManager;
            Optional<Pair> recipeResult;
            boolean usedMoldStack;
            ItemStack stack;
            if (!this.moldTable.getOutputStack().m_41619_()) {
                stack = this.moldTable.getOutputStack();
                usedMoldStack = false;
            } else {
                stack = this.moldTable.getMoldStack();
                usedMoldStack = true;
            }
            Level level = this.moldTable.m_58904_();
            if (!stack.m_41619_() && level != null && (recipeResult = (recipeManager = level.m_7465_()).m_44013_((RecipeType)TFCRecipeTypes.BARREL_INSTANT.get()).stream().filter(recipe -> recipe.getInputItem().test(stack) && recipe.getInputFluid().test(fluid)).findFirst().map(recipe -> {
                ItemStackIngredient inputItem = recipe.getInputItem();
                FluidStackIngredient inputFluid = recipe.getInputFluid();
                int multiplier = inputItem.count() == 0 ? fluid.getAmount() / inputFluid.amount() : (inputFluid.amount() == 0 ? stack.m_41613_() / inputItem.count() : Math.min(fluid.getAmount() / inputFluid.amount(), stack.m_41613_() / inputItem.count()));
                ItemStack outputItem = recipe.getOutputItem().getSingleStack(stack);
                if (!outputItem.m_41619_()) {
                    outputItem.m_41764_(Math.min(outputItem.m_41741_(), multiplier * outputItem.m_41613_()));
                }
                return Pair.of((Object)outputItem, (Object)(multiplier * inputFluid.amount()));
            })).isPresent()) {
                if (action == IFluidHandler.FluidAction.EXECUTE) {
                    if (usedMoldStack) {
                        this.moldTable.setMoldStack((ItemStack)recipeResult.get().getLeft());
                    } else {
                        this.moldTable.setOutputStack((ItemStack)recipeResult.get().getLeft());
                    }
                }
                return (Integer)recipeResult.get().getRight();
            }
            return this.getMoldFluidHandler().map(h -> h.fill(fluid, action)).orElse(0);
        }

        @Nonnull
        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            return this.getMoldFluidHandler().map(h -> h.drain(resource, action)).orElse(FluidStack.EMPTY.copy());
        }

        @Nonnull
        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            return this.getMoldFluidHandler().map(h -> h.drain(maxDrain, action)).orElse(FluidStack.EMPTY.copy());
        }
    }
}

