/*
 * Decompiled with CFR 0.152.
 */
package com.ljuangbminecraft.tfcchannelcasting.common.blockentities;

import com.ljuangbminecraft.tfcchannelcasting.common.blockentities.TFCCCBlockEntities;
import com.ljuangbminecraft.tfcchannelcasting.common.blocks.ChannelBlock;
import java.util.Optional;
import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.blockentities.TFCBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import org.apache.commons.lang3.tuple.Pair;

public class ChannelBlockEntity
extends TFCBlockEntity {
    private Optional<Pair<Direction, Byte>> flowSource = Optional.empty();
    private boolean isConnectedToAnotherChannel = false;
    private int nFlows = 0;
    private ResourceLocation fluid = new ResourceLocation("");
    private static final byte NO_FLOW_BYTE = 99;

    protected ChannelBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)TFCCCBlockEntities.CHANNEL.get(), pos, state);
    }

    public boolean shouldRender() {
        return this.flowSource.isPresent();
    }

    public ResourceLocation getFluid() {
        return this.fluid;
    }

    public Pair<Direction, Byte> getFlowSource() {
        return this.flowSource.get();
    }

    public boolean isConnectedToAnotherChannel() {
        return this.isConnectedToAnotherChannel;
    }

    public int getNumberOfFlows() {
        return this.nFlows;
    }

    public void setLinkProperties(Pair<Direction, Byte> flowSource, boolean isConnectedToAnotherChannel, int nFlows, ResourceLocation fluid) {
        this.flowSource = Optional.of(flowSource);
        this.isConnectedToAnotherChannel = isConnectedToAnotherChannel;
        this.nFlows = nFlows;
        this.fluid = fluid;
        this.f_58857_.m_7731_(this.f_58858_, (BlockState)this.m_58900_().m_61124_((Property)ChannelBlock.WITH_METAL, (Comparable)Boolean.valueOf(this.flowSource.isPresent())), 3);
        this.markForSync();
    }

    public void notifyBrokenLink(int linksBroken) {
        this.nFlows -= linksBroken;
        if (this.f_58857_ != null) {
            this.flowSource.ifPresent(fs -> this.f_58857_.m_141902_(this.f_58858_.m_5484_((Direction)fs.getLeft(), (int)((Byte)fs.getRight()).byteValue()), (BlockEntityType)TFCCCBlockEntities.CHANNEL.get()).ifPresent(channel -> channel.notifyBrokenLink(linksBroken)));
        }
        if (this.nFlows <= 0) {
            this.flowSource = Optional.empty();
            this.fluid = new ResourceLocation("");
            this.f_58857_.m_7731_(this.f_58858_, (BlockState)this.m_58900_().m_61124_((Property)ChannelBlock.WITH_METAL, (Comparable)Boolean.valueOf(false)), 3);
            this.markForSync();
        }
    }

    public boolean isLinkBroken() {
        if (this.flowSource.isEmpty()) {
            return true;
        }
        assert (this.f_58857_ != null);
        if (this.isConnectedToAnotherChannel) {
            Optional bEntity = this.f_58857_.m_141902_(this.f_58858_.m_5484_((Direction)this.flowSource.get().getLeft(), (int)((Byte)this.flowSource.get().getRight()).byteValue()), (BlockEntityType)TFCCCBlockEntities.CHANNEL.get());
            if (bEntity.isEmpty()) {
                return true;
            }
            for (byte i = 1; i < (Byte)this.flowSource.get().getRight(); i = (byte)(i + 1)) {
                BlockPos rel = this.f_58858_.m_5484_((Direction)this.flowSource.get().getLeft(), (int)i);
                if (this.f_58857_.m_8055_(rel).m_60795_()) continue;
                return true;
            }
            return ((ChannelBlockEntity)((Object)bEntity.get())).isLinkBroken();
        }
        Optional bEntity = this.f_58857_.m_141902_(this.f_58858_.m_5484_((Direction)this.flowSource.get().getLeft(), (int)((Byte)this.flowSource.get().getRight()).byteValue()), (BlockEntityType)TFCBlockEntities.CRUCIBLE.get());
        return bEntity.isEmpty();
    }

    public void loadAdditional(CompoundTag nbt) {
        this.nFlows = nbt.m_128445_("nFlowsOut");
        this.isConnectedToAnotherChannel = nbt.m_128471_("useLongRenderBox");
        byte flowSourceByte = nbt.m_128445_("flowSource");
        byte flowSourceDistance = nbt.m_128441_("flowSourceDistance") ? nbt.m_128445_("flowSourceDistance") : (byte)1;
        this.flowSource = flowSourceByte != 99 ? Optional.of(Pair.of((Object)Direction.values()[flowSourceByte], (Object)flowSourceDistance)) : Optional.empty();
        this.fluid = new ResourceLocation(nbt.m_128461_("texture"));
    }

    public void m_183515_(CompoundTag nbt) {
        nbt.m_128344_("nFlowsOut", (byte)this.nFlows);
        nbt.m_128379_("useLongRenderBox", this.isConnectedToAnotherChannel);
        nbt.m_128344_("flowSource", this.flowSource.isPresent() ? (byte)((Direction)this.flowSource.get().getLeft()).ordinal() : (byte)99);
        nbt.m_128344_("flowSourceDistance", this.flowSource.isPresent() ? (Byte)this.flowSource.get().getRight() : (byte)1);
        nbt.m_128359_("texture", this.fluid.toString());
    }

    public AABB getRenderBoundingBox() {
        if (this.flowSource.isPresent()) {
            if (this.flowSource.get().getLeft() == Direction.UP) {
                return new AABB(this.f_58858_.m_7918_(-1, 0, -1), this.f_58858_.m_7918_(2, 1 + (Byte)this.flowSource.get().getRight(), 2));
            }
            return new AABB(this.f_58858_.m_7918_(-1, 0, -1), this.f_58858_.m_7918_(2, 2, 2));
        }
        return super.getRenderBoundingBox();
    }
}

