/*
 * Decompiled with CFR 0.152.
 */
package com.ljuangbminecraft.tfcchannelcasting.client;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.dries007.tfc.util.Helpers;
import net.minecraft.client.renderer.block.model.BlockElement;
import net.minecraft.client.renderer.block.model.BlockElementFace;
import net.minecraft.client.renderer.block.model.BlockFaceUV;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.client.model.ElementsModel;
import net.minecraftforge.client.model.ForgeFaceData;
import net.minecraftforge.client.model.geometry.IGeometryLoader;
import org.joml.Vector3f;

public class MoldsModelLoader
implements IGeometryLoader<ElementsModel> {
    public static final ResourceLocation MOLD_LOADER = new ResourceLocation("tfcchannelcasting", "mold");

    public static void register(ModelEvent.RegisterGeometryLoaders event) {
        event.register(MOLD_LOADER.m_135815_(), (IGeometryLoader)new MoldsModelLoader());
    }

    public ElementsModel read(JsonObject json, JsonDeserializationContext deserializationContext) throws JsonParseException {
        JsonArray pattern = json.getAsJsonArray("pattern");
        int height = pattern.size();
        if (height != 14) {
            throw new JsonSyntaxException("Invalid pattern: must 14 rows (has " + height + ")");
        }
        boolean[][] full = new boolean[14][14];
        for (int r = 0; r < 14; ++r) {
            String row = GsonHelper.m_13805_((JsonElement)pattern.get(r), (String)("pattern[" + r + "]"));
            int width = row.length();
            if (width != 14) {
                throw new JsonSyntaxException("Invalid pattern: must 14 columns (has " + width + " in row " + r + ")");
            }
            for (int c = 0; c < 14; ++c) {
                full[r][c] = row.charAt(c) != ' ';
            }
        }
        return new ElementsModel(MoldsModelLoader.generateBlockElementsFromPattern(full));
    }

    @Nonnull
    public static List<BlockElement> generateBlockElementsFromPattern(boolean[][] pattern) {
        ArrayList<BlockElement> elements = new ArrayList<BlockElement>();
        boolean from_y = true;
        int to_y = 2;
        for (int r = 0; r < 14; ++r) {
            int from_x = r + 1;
            int to_x = r + 2;
            for (int c = 0; c < 14; ++c) {
                if (!pattern[r][c]) continue;
                int from_z = c + 1;
                int to_z = c + 2;
                Vector3f from = new Vector3f((float)from_x, (float)from_y, (float)from_z);
                Vector3f to = new Vector3f((float)to_x, (float)to_y, (float)to_z);
                elements.add(new BlockElement(from, to, (Map)Helpers.mapOfKeys(Direction.class, direction -> new BlockElementFace(null, -1, "#0", new BlockFaceUV(MoldsModelLoader.autoRelativeUV(direction, from, to), 0))), null, true, ForgeFaceData.DEFAULT));
            }
        }
        return elements;
    }

    private static float[] autoRelativeUV(Direction direction, Vector3f from, Vector3f to) {
        switch (direction) {
            case NORTH: {
                return new float[]{16.0f - to.x, 16.0f - to.y, 16.0f - from.x, 16.0f - from.y};
            }
            case SOUTH: {
                return new float[]{from.x, 16.0f - to.y, to.x, 16.0f - from.y};
            }
            case WEST: {
                return new float[]{from.z, 16.0f - to.y, to.z, 16.0f - from.y};
            }
            case EAST: {
                return new float[]{16.0f - to.z, 16.0f - to.y, 16.0f - from.z, 16.0f - from.y};
            }
            case UP: {
                return new float[]{from.x, from.z, to.x, to.z};
            }
            case DOWN: {
                return new float[]{from.x, 16.0f - to.z, to.x, 16.0f - from.z};
            }
        }
        return new float[0];
    }
}

