/*
 * Decompiled with CFR 0.152.
 */
package com.ljuangbminecraft.tfcchannelcasting.client;

import com.ljuangbminecraft.tfcchannelcasting.client.ChannelBlockEntityRenderer;
import com.ljuangbminecraft.tfcchannelcasting.client.MoldBlockEntityRenderer;
import com.ljuangbminecraft.tfcchannelcasting.client.MoldsModelLoader;
import com.ljuangbminecraft.tfcchannelcasting.common.blockentities.TFCCCBlockEntities;
import com.ljuangbminecraft.tfcchannelcasting.common.blocks.TFCCCBlocks;
import com.ljuangbminecraft.tfcchannelcasting.common.items.ChocolateSweetItem;
import com.ljuangbminecraft.tfcchannelcasting.common.items.TFCCCItems;
import java.util.Map;
import net.dries007.tfc.common.TFCCreativeTabs;
import net.dries007.tfc.common.capabilities.food.FoodCapability;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

public final class ClientEventHandler {
    public static void init() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        bus.addListener(ClientEventHandler::registerEntityRenderers);
        bus.addListener(ClientEventHandler::addItemsToCreativeTab);
        bus.addListener(ClientEventHandler::modelInit);
        bus.addListener(ClientEventHandler::registerModels);
    }

    public static void registerEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerBlockEntityRenderer((BlockEntityType)TFCCCBlockEntities.CHANNEL.get(), ctx -> new ChannelBlockEntityRenderer());
        event.registerBlockEntityRenderer((BlockEntityType)TFCCCBlockEntities.MOLD_TABLE.get(), ctx -> new MoldBlockEntityRenderer());
    }

    public static void addItemsToCreativeTab(BuildCreativeModeTabContentsEvent event) {
        if (event.getTab() == TFCCreativeTabs.FOOD.tab().get()) {
            event.m_246601_(TFCCCItems.CHOCOLATE_SWEET.values().stream().flatMap(map -> map.values().stream().map(reg -> FoodCapability.setStackNonDecaying((ItemStack)((ChocolateSweetItem)((Object)((Object)((Object)reg.get())))).m_7968_()))).toList());
        }
        if (event.getTab() == TFCCreativeTabs.MISC.tab().get()) {
            event.accept(TFCCCItems.UNFIRED_CHANNEL);
            event.accept(TFCCCItems.UNFIRED_MOLD_TABLE);
            event.accept(TFCCCItems.UNFIRED_HEART_MOLD);
            event.accept(TFCCCItems.HEART_MOLD);
            event.accept(TFCCCBlocks.CHANNEL);
            event.accept(TFCCCBlocks.MOLD_TABLE);
        }
    }

    public static void modelInit(ModelEvent.RegisterGeometryLoaders event) {
        MoldsModelLoader.register(event);
    }

    public static void registerModels(ModelEvent.RegisterAdditional event) {
        ResourceManager rm = Minecraft.m_91087_().m_91098_();
        Map resources = rm.m_214159_("models/mold", r -> r.m_135815_().endsWith(".json"));
        for (ResourceLocation model : resources.keySet()) {
            String path = model.m_135815_();
            path = path.substring("models/".length(), path.length() - ".json".length());
            event.register(new ResourceLocation("tfcchannelcasting", path));
        }
    }
}

