/*
 * Decompiled with CFR 0.152.
 */
package com.ljuangbminecraft.tfcchannelcasting;

import com.ljuangbminecraft.tfcchannelcasting.client.ClientEventHandler;
import com.ljuangbminecraft.tfcchannelcasting.common.TFCCCTags;
import com.ljuangbminecraft.tfcchannelcasting.common.blockentities.TFCCCBlockEntities;
import com.ljuangbminecraft.tfcchannelcasting.common.blocks.ChannelBlock;
import com.ljuangbminecraft.tfcchannelcasting.common.blocks.MoldBlock;
import com.ljuangbminecraft.tfcchannelcasting.common.blocks.TFCCCBlocks;
import com.ljuangbminecraft.tfcchannelcasting.common.blocks.TFCCCFluids;
import com.ljuangbminecraft.tfcchannelcasting.common.items.ChocolateSweetItem;
import com.ljuangbminecraft.tfcchannelcasting.common.items.TFCCCFoodTraits;
import com.ljuangbminecraft.tfcchannelcasting.common.items.TFCCCItems;
import com.ljuangbminecraft.tfcchannelcasting.common.recipes.outputs.ModifyConditions;
import com.ljuangbminecraft.tfcchannelcasting.common.recipes.outputs.TFCCCItemStackModifiers;
import com.ljuangbminecraft.tfcchannelcasting.config.TFCCCConfig;
import com.mojang.logging.LogUtils;
import java.util.Map;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.common.blocks.rock.Rock;
import net.dries007.tfc.util.InteractionManager;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.registries.RegistryObject;
import org.slf4j.Logger;
import vazkii.patchouli.api.IMultiblock;
import vazkii.patchouli.api.PatchouliAPI;

@Mod(value="tfcchannelcasting")
public class TFCChannelCasting {
    public static final String MOD_ID = "tfcchannelcasting";
    public static final Logger LOGGER = LogUtils.getLogger();

    public TFCChannelCasting() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        TFCCCBlocks.BLOCKS.register(bus);
        TFCCCBlockEntities.BLOCK_ENTITIES.register(bus);
        TFCCCItems.ITEMS.register(bus);
        TFCCCFluids.FLUIDS.register(bus);
        TFCCCConfig.init();
        bus.addListener(this::setup);
        if (FMLEnvironment.dist == Dist.CLIENT) {
            ClientEventHandler.init();
        }
    }

    public void setup(FMLCommonSetupEvent event) {
        TFCCCItemStackModifiers.registerItemStackModifierTypes();
        ModifyConditions.registerItemStackModifierTypes();
        event.enqueueWork(() -> {
            TFCChannelCasting.registerInteractions();
            TFCCCFoodTraits.init();
            ChocolateSweetItem.registerTraitEffects();
        });
        this.registerPatchouliMultiBlock();
    }

    public static void registerInteractions() {
        InteractionManager.register((Ingredient)Ingredient.m_204132_(TFCCCTags.Items.ACCEPTED_IN_MOLD_TABLES), (boolean)false, (stack, context) -> {
            Player player = context.m_43723_();
            if (player != null) {
                Level level = context.m_43725_();
                BlockPos posClicked = context.m_8083_();
                level.m_141902_(posClicked, (BlockEntityType)TFCCCBlockEntities.MOLD_TABLE.get()).ifPresent(mold -> mold.onRightClick(player));
            }
            return InteractionResult.SUCCESS;
        });
    }

    public void registerPatchouliMultiBlock() {
        PatchouliAPI.IPatchouliAPI api = PatchouliAPI.get();
        IMultiblock multiblock = api.makeMultiblock((String[][])new String[][]{{"     ", "   R ", "   | ", " S-+c", "     "}, {"  XXX", "  XFX", "  0XX", "CNXXX", "  XXX"}, {"     ", "     ", "XXX  ", "XXX  ", "XXX  "}}, new Object[]{Character.valueOf('R'), api.stateMatcher((BlockState)((Block)TFCBlocks.CRUCIBLE.get()).m_49966_().m_61124_((Property)PipeBlock.f_55149_, (Comparable)Boolean.valueOf(true))), Character.valueOf('F'), api.looseBlockMatcher((Block)TFCBlocks.CHARCOAL_FORGE.get()), Character.valueOf(' '), api.airMatcher(), Character.valueOf('X'), api.looseBlockMatcher((Block)((RegistryObject)((Map)TFCBlocks.ROCK_BLOCKS.get(Rock.GRANITE)).get(Rock.BlockType.BRICKS)).get()), Character.valueOf('0'), api.looseBlockMatcher((Block)((RegistryObject)((Map)TFCBlocks.ROCK_BLOCKS.get(Rock.GRANITE)).get(Rock.BlockType.BRICKS)).get()), Character.valueOf('|'), api.stateMatcher((BlockState)((BlockState)((Block)TFCCCBlocks.CHANNEL.get()).m_49966_().m_61124_((Property)ChannelBlock.WEST, (Comparable)Boolean.valueOf(true))).m_61124_((Property)ChannelBlock.EAST, (Comparable)Boolean.valueOf(true))), Character.valueOf('-'), api.stateMatcher((BlockState)((BlockState)((Block)TFCCCBlocks.CHANNEL.get()).m_49966_().m_61124_((Property)ChannelBlock.SOUTH, (Comparable)Boolean.valueOf(true))).m_61124_((Property)ChannelBlock.NORTH, (Comparable)Boolean.valueOf(true))), Character.valueOf('+'), api.stateMatcher((BlockState)((BlockState)((BlockState)((Block)TFCCCBlocks.CHANNEL.get()).m_49966_().m_61124_((Property)ChannelBlock.SOUTH, (Comparable)Boolean.valueOf(true))).m_61124_((Property)ChannelBlock.NORTH, (Comparable)Boolean.valueOf(true))).m_61124_((Property)ChannelBlock.WEST, (Comparable)Boolean.valueOf(true))), Character.valueOf('S'), api.stateMatcher((BlockState)((Block)TFCCCBlocks.CHANNEL.get()).m_49966_().m_61124_((Property)ChannelBlock.SOUTH, (Comparable)Boolean.valueOf(true))), Character.valueOf('N'), api.stateMatcher((BlockState)((Block)TFCCCBlocks.CHANNEL.get()).m_49966_().m_61124_((Property)ChannelBlock.NORTH, (Comparable)Boolean.valueOf(true))), Character.valueOf('C'), api.stateMatcher((BlockState)((Block)TFCCCBlocks.MOLD_TABLE.get()).m_49966_().m_61124_((Property)MoldBlock.SOUTH, (Comparable)Boolean.valueOf(true))), Character.valueOf('c'), api.stateMatcher((BlockState)((Block)TFCCCBlocks.MOLD_TABLE.get()).m_49966_().m_61124_((Property)MoldBlock.NORTH, (Comparable)Boolean.valueOf(true)))});
        api.registerMultiblock(new ResourceLocation(MOD_ID, "example"), multiblock);
    }
}

