/*
 * Decompiled with CFR 0.152.
 */
package com.kaber.tfcbarrels.entities;

import com.kaber.tfcbarrels.blocks.wood.TFCBarrelBlock;
import com.kaber.tfcbarrels.register.ModBlockEntities;
import net.dries007.tfc.common.capabilities.size.ItemSizeManager;
import net.dries007.tfc.common.capabilities.size.Size;
import net.dries007.tfc.common.container.PestContainer;
import net.dries007.tfc.common.container.RestrictedChestContainer;
import net.dries007.tfc.common.container.TFCContainerTypes;
import net.dries007.tfc.config.TFCConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ContainerOpenersCounter;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class TFCBarrelBlockEntity
extends RandomizableContainerBlockEntity
implements PestContainer {
    private NonNullList<ItemStack> items = NonNullList.m_122780_((int)18, (Object)ItemStack.f_41583_);
    private ContainerOpenersCounter openersCounter = new ContainerOpenersCounter(){

        protected void m_142292_(Level pLevel, BlockPos pPos, BlockState pState) {
            TFCBarrelBlockEntity.this.playSound(pState, SoundEvents.f_11725_);
            TFCBarrelBlockEntity.this.updateBlockState(pState, true);
        }

        protected void m_142289_(Level pLevel, BlockPos pPos, BlockState pState) {
            TFCBarrelBlockEntity.this.playSound(pState, SoundEvents.f_11724_);
            TFCBarrelBlockEntity.this.updateBlockState(pState, false);
        }

        protected void m_142148_(Level pLevel, BlockPos pPos, BlockState pState, int pCount, int pOpenCount) {
        }

        protected boolean m_142718_(Player p_155451_) {
            if (p_155451_.f_36096_ instanceof RestrictedChestContainer) {
                Container container = ((RestrictedChestContainer)p_155451_.f_36096_).m_39261_();
                return container == TFCBarrelBlockEntity.this;
            }
            return false;
        }
    };

    public static boolean isValid(ItemStack stack) {
        return ItemSizeManager.get((ItemStack)stack).getSize(stack).isEqualOrSmallerThan((Size)TFCConfig.SERVER.chestMaximumItemSize.get());
    }

    public TFCBarrelBlockEntity(BlockPos pPos, BlockState pState) {
        super((BlockEntityType)ModBlockEntities.BARREL.get(), pPos, pState);
    }

    protected void m_183515_(CompoundTag pTag) {
        super.m_183515_(pTag);
        if (!this.m_59634_(pTag)) {
            ContainerHelper.m_18973_((CompoundTag)pTag, this.items);
        }
    }

    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        this.items = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        if (!this.m_59631_(pTag)) {
            ContainerHelper.m_18980_((CompoundTag)pTag, this.items);
        }
    }

    protected NonNullList<ItemStack> m_7086_() {
        return this.items;
    }

    protected void m_6520_(NonNullList<ItemStack> pItemStacks) {
        this.items = pItemStacks;
    }

    protected Component m_6820_() {
        return Component.m_237115_((String)"container.barrel");
    }

    protected AbstractContainerMenu m_6555_(int pContainerId, Inventory pInventory) {
        return new RestrictedChestContainer((MenuType)TFCContainerTypes.CHEST_9x2.get(), pContainerId, pInventory, (Container)this, 2);
    }

    public int m_6643_() {
        return 18;
    }

    public boolean m_7013_(int slot, ItemStack stack) {
        return TFCBarrelBlockEntity.isValid(stack);
    }

    public void m_155250_(BlockState state) {
        super.m_155250_(state);
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        return TFCBarrelBlockEntity.isValid(stack);
    }

    public void m_5856_(Player pPlayer) {
        if (!this.f_58859_ && !pPlayer.m_5833_()) {
            this.openersCounter.m_155452_(pPlayer, this.m_58904_(), this.m_58899_(), this.m_58900_());
        }
    }

    public void m_5785_(Player pPlayer) {
        if (!this.f_58859_ && !pPlayer.m_5833_()) {
            this.openersCounter.m_155468_(pPlayer, this.m_58904_(), this.m_58899_(), this.m_58900_());
        }
    }

    public void recheckOpen() {
        if (!this.f_58859_) {
            this.openersCounter.m_155476_(this.m_58904_(), this.m_58899_(), this.m_58900_());
        }
    }

    void updateBlockState(BlockState pState, boolean pOpen) {
        this.f_58857_.m_7731_(this.m_58899_(), (BlockState)pState.m_61124_((Property)TFCBarrelBlock.OPEN, (Comparable)Boolean.valueOf(pOpen)), 3);
    }

    void playSound(BlockState pState, SoundEvent pSound) {
        Vec3i vec3i = ((Direction)pState.m_61143_((Property)TFCBarrelBlock.FACING)).m_122436_();
        double d0 = (double)this.f_58858_.m_123341_() + 0.5 + (double)vec3i.m_123341_() / 2.0;
        double d1 = (double)this.f_58858_.m_123342_() + 0.5 + (double)vec3i.m_123342_() / 2.0;
        double d2 = (double)this.f_58858_.m_123343_() + 0.5 + (double)vec3i.m_123343_() / 2.0;
        this.f_58857_.m_6263_((Player)null, d0, d1, d2, pSound, SoundSource.BLOCKS, 0.5f, this.f_58857_.f_46441_.m_188501_() * 0.1f + 0.9f);
    }
}

