/*
 * Decompiled with CFR 0.152.
 */
package com.koenigstag.tfc_weight_bar;

import com.koenigstag.tfc_weight_bar.Config;
import com.koenigstag.tfc_weight_bar.Constants;
import com.koenigstag.tfc_weight_bar.Tags;
import net.dries007.tfc.common.TFCEffects;
import net.dries007.tfc.common.capabilities.VesselLike;
import net.dries007.tfc.common.capabilities.size.IItemSize;
import net.dries007.tfc.common.capabilities.size.ItemSizeManager;
import net.dries007.tfc.common.capabilities.size.Size;
import net.dries007.tfc.common.capabilities.size.Weight;
import net.dries007.tfc.common.items.VesselItem;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.world.Container;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;

public class WeightBarHelpers {
    public static int getMaxInventoryWeight(Player player) {
        Inventory container = player.m_150109_();
        if (container == null) {
            return 0;
        }
        double effectiveHealthPercentage = WeightBarHelpers.getEffectiveHealthPercentage(player);
        int adjustedMaxWeight = (int)Math.round((double)Config.maxInvWeight * effectiveHealthPercentage);
        return adjustedMaxWeight;
    }

    public static double getBarPercentage(int playerInvWeight, Player player) {
        return (double)playerInvWeight / (double)WeightBarHelpers.getMaxInventoryWeight(player);
    }

    public static int getItemStackWeightInt(ItemStack itemStack) {
        if (!itemStack.m_41619_()) {
            int weightInt = WeightBarHelpers.getWeightInt(itemStack);
            int itemCount = itemStack.m_41613_();
            int itemStackWeight = Math.round(weightInt * itemCount);
            int itemHolderWeight = 0;
            LazyOptional itemHandlerCapability = itemStack.getCapability(ForgeCapabilities.ITEM_HANDLER);
            if (itemHandlerCapability.isPresent()) {
                IItemHandler itemHandler = (IItemHandler)itemHandlerCapability.resolve().get();
                itemHolderWeight += WeightBarHelpers.calculateItemHandlerWeight(itemHandler);
            } else if (itemStack.m_41720_() instanceof VesselItem) {
                VesselLike vessel = VesselItem.getInventoryVessel((ItemStack)itemStack);
                itemHolderWeight += WeightBarHelpers.calculateItemHandlerWeight((IItemHandler)vessel);
            } else {
                itemHolderWeight += WeightBarHelpers.getBlockEntityInventoryWeight(itemStack);
            }
            return itemStackWeight + itemHolderWeight;
        }
        return 0;
    }

    public static int getItemOverweightInt(ItemStack itemStack) {
        IItemSize size;
        if (!itemStack.m_41619_() && (size = ItemSizeManager.get((ItemStack)itemStack)).getWeight(itemStack) == Weight.VERY_HEAVY && size.getSize(itemStack) == Size.HUGE) {
            return 1;
        }
        return 0;
    }

    public static int calculateCuriosSlotsWeight(Player livingEntity) {
        LazyOptional lazyCuriosInventory;
        int curiosWeightInt = 0;
        if (ModList.get().isLoaded("curios") && (lazyCuriosInventory = CuriosApi.getCuriosInventory((LivingEntity)livingEntity)).isPresent()) {
            ICuriosItemHandler curiosInventory = (ICuriosItemHandler)lazyCuriosInventory.resolve().get();
            IItemHandlerModifiable curiosContainer = curiosInventory.getEquippedCurios();
            for (int i = 0; i < curiosContainer.getSlots(); ++i) {
                ItemStack stack = curiosContainer.getStackInSlot(i);
                curiosWeightInt += WeightBarHelpers.getItemStackWeightInt(stack);
            }
        }
        return curiosWeightInt;
    }

    public static int calculatePlayerFullWeight(Player livingEntity) {
        int totalWeight = 0;
        totalWeight += WeightBarHelpers.calculateContainerWeight((Container)livingEntity.m_150109_());
        return totalWeight += WeightBarHelpers.calculateCuriosSlotsWeight(livingEntity);
    }

    public static boolean isPlayerExhausted(int playerInvWeight, int maxInvWeight) {
        return (double)playerInvWeight >= (double)maxInvWeight * Config.getExhaustedWeightCoefficient();
    }

    public static boolean isPlayerOverburdened(int playerInvWeight, int maxInvWeight) {
        return playerInvWeight > maxInvWeight;
    }

    public static String getBarColor(int playerInvWeight, int maxInvWeight, int hugeHeavyCount) {
        boolean isOverburdened = WeightBarHelpers.getIsOverburdened(playerInvWeight, maxInvWeight, hugeHeavyCount);
        boolean isExhausted = WeightBarHelpers.getIsExhausted(playerInvWeight, maxInvWeight, hugeHeavyCount);
        if (isOverburdened) {
            return Config.getOverburdenedBarColor();
        }
        if (isExhausted) {
            return Config.getExhaustedBarColor();
        }
        return Config.getNormalBarColor();
    }

    public static MobEffectInstance getOverburdened(boolean visible) {
        return new MobEffectInstance((MobEffect)TFCEffects.OVERBURDENED.get(), Config.calculateWeightEachNTicks + 5, 0, false, visible);
    }

    public static MobEffectInstance getExhausted(boolean visible) {
        return new MobEffectInstance((MobEffect)TFCEffects.EXHAUSTED.get(), Config.calculateWeightEachNTicks + 5, 0, false, visible);
    }

    public static boolean getIsExhausted(int playerInvWeight, int maxInvWeight, int hugeHeavyCount) {
        return WeightBarHelpers.isPlayerExhausted(playerInvWeight, maxInvWeight) || hugeHeavyCount >= 1;
    }

    public static boolean getIsOverburdened(int playerInvWeight, int maxInvWeight, int hugeHeavyCount) {
        return WeightBarHelpers.isPlayerOverburdened(playerInvWeight, maxInvWeight) || hugeHeavyCount >= 2;
    }

    public static double getHealthPercentage(Player player) {
        float currentHealth = player.m_21223_();
        float maxHealth = player.m_21233_();
        return (double)currentHealth / (double)maxHealth;
    }

    public static double getEffectiveHealthPercentage(Player player) {
        if (!Config.healthAffectsWeightCapacity) {
            return 1.0;
        }
        double healthPercentage = WeightBarHelpers.getHealthPercentage(player);
        return Math.max(Config.minHealthWeightPercentage, Math.min(1.0, healthPercentage));
    }

    public static String getPlayerWeightStatus(Player player) {
        int currentWeight = WeightBarHelpers.calculatePlayerFullWeight(player);
        int maxWeight = WeightBarHelpers.getMaxInventoryWeight(player);
        double effectiveHealthPercentage = WeightBarHelpers.getEffectiveHealthPercentage(player);
        if (effectiveHealthPercentage < 1.0) {
            return String.format("Weight: %d/%d (Health: %.0f%%)", currentWeight, maxWeight, effectiveHealthPercentage * 100.0);
        }
        return String.format("Weight: %d/%d", currentWeight, maxWeight);
    }

    public static void debugHealthPercentage(Player player) {
        double healthPercentage = WeightBarHelpers.getHealthPercentage(player);
        double effectiveHealthPercentage = WeightBarHelpers.getEffectiveHealthPercentage(player);
        int maxWeight = WeightBarHelpers.getMaxInventoryWeight(player);
        Constants.debug(String.format("Player Health: %.1f/%.1f (%.1f%%)", Float.valueOf(player.m_21223_()), Float.valueOf(player.m_21233_()), healthPercentage * 100.0));
        Constants.debug(String.format("Effective Health Percentage: %.1f%%", effectiveHealthPercentage * 100.0));
        Constants.debug(String.format("Max Weight: %d (Config: %d)", maxWeight, Config.maxInvWeight));
        Constants.debug(String.format("Health Affects Weight: %s", Config.healthAffectsWeightCapacity ? "YES" : "NO"));
    }

    public static int getWeightInt(ItemStack itemStack) {
        int tagWeightInt = WeightBarHelpers.getWeightIntFromTag(itemStack);
        if (tagWeightInt > 0) {
            return tagWeightInt;
        }
        IItemSize size = ItemSizeManager.get((ItemStack)itemStack);
        Weight weight = size.getWeight(itemStack);
        switch (weight) {
            case VERY_LIGHT: {
                return Config.veryLightWeightInt;
            }
            case LIGHT: {
                return Config.lightWeightInt;
            }
            case MEDIUM: {
                return Config.mediumWeightInt;
            }
            case HEAVY: {
                return Config.heavyWeightInt;
            }
            case VERY_HEAVY: {
                return Config.veryHeavyWeightInt;
            }
        }
        return Config.veryLightWeightInt;
    }

    public static int getWeightIntFromTag(ItemStack itemStack) {
        if (itemStack.m_204117_(Tags.Items.VERY_LIGHT)) {
            return Config.veryLightWeightInt;
        }
        if (itemStack.m_204117_(Tags.Items.LIGHT)) {
            return Config.lightWeightInt;
        }
        if (itemStack.m_204117_(Tags.Items.MEDIUM)) {
            return Config.mediumWeightInt;
        }
        if (itemStack.m_204117_(Tags.Items.HEAVY)) {
            return Config.heavyWeightInt;
        }
        if (itemStack.m_204117_(Tags.Items.VERY_HEAVY)) {
            return Config.veryHeavyWeightInt;
        }
        return 0;
    }

    public static int calculateContainerWeight(Container container) {
        if (container == null) {
            return 0;
        }
        int totalWeight = 0;
        for (int i = 0; i < container.m_6643_(); ++i) {
            ItemStack itemStack = container.m_8020_(i);
            totalWeight += WeightBarHelpers.getItemStackWeightInt(itemStack);
        }
        return totalWeight;
    }

    public static int calculateItemHandlerWeight(IItemHandler itemHandler) {
        if (itemHandler == null) {
            return 0;
        }
        int totalWeight = 0;
        for (int i = 0; i < itemHandler.getSlots(); ++i) {
            ItemStack itemStack = itemHandler.getStackInSlot(i);
            totalWeight += WeightBarHelpers.getItemStackWeightInt(itemStack);
        }
        return totalWeight;
    }

    public static int getBlockEntityInventoryWeight(ItemStack itemStack) {
        if (itemStack.m_41619_()) {
            return 0;
        }
        CompoundTag nbt = itemStack.m_41783_();
        if (nbt != null) {
            if (nbt.m_128425_("inventory", 10)) {
                CompoundTag inventoryTag = nbt.m_128469_("inventory");
                return WeightBarHelpers.calculateNBTInventoryFromCompound(inventoryTag);
            }
            if (nbt.m_128425_("Items", 9)) {
                ListTag itemsList = nbt.m_128437_("Items", 10);
                return WeightBarHelpers.calculateNBTInventoryWeight(itemsList);
            }
            if (nbt.m_128425_("Inventory", 9)) {
                ListTag inventoryList = nbt.m_128437_("Inventory", 10);
                return WeightBarHelpers.calculateNBTInventoryWeight(inventoryList);
            }
            if (nbt.m_128425_("BlockEntityTag", 10)) {
                CompoundTag blockEntityTag = nbt.m_128469_("BlockEntityTag");
                if (blockEntityTag.m_128425_("inventory", 10)) {
                    CompoundTag inventoryTag = blockEntityTag.m_128469_("inventory");
                    return WeightBarHelpers.calculateNBTInventoryFromCompound(inventoryTag);
                }
                if (blockEntityTag.m_128425_("Items", 9)) {
                    ListTag itemsList = blockEntityTag.m_128437_("Items", 10);
                    return WeightBarHelpers.calculateNBTInventoryWeight(itemsList);
                }
            }
        }
        return 0;
    }

    private static int calculateNBTInventoryWeight(ListTag itemsList) {
        int totalWeight = 0;
        for (int i = 0; i < itemsList.size(); ++i) {
            CompoundTag itemTag = itemsList.m_128728_(i);
            ItemStack stack = ItemStack.m_41712_((CompoundTag)itemTag);
            if (stack.m_41619_()) continue;
            totalWeight += WeightBarHelpers.getItemStackWeightInt(stack);
        }
        return totalWeight;
    }

    private static int calculateNBTInventoryFromCompound(CompoundTag inventoryTag) {
        ItemStackHandler tempHandler = new ItemStackHandler();
        tempHandler.deserializeNBT(inventoryTag);
        int totalWeight = 0;
        for (int i = 0; i < tempHandler.getSlots(); ++i) {
            ItemStack stack = tempHandler.getStackInSlot(i);
            if (stack.m_41619_()) continue;
            totalWeight += WeightBarHelpers.getItemStackWeightInt(stack);
        }
        return totalWeight;
    }
}

