/*
 * Decompiled with CFR 0.152.
 */
package com.koenigstag.tfc_weight_bar;

import com.koenigstag.tfc_curios_weight.CuriosHelpers;
import com.koenigstag.tfc_weight_bar.Config;
import com.koenigstag.tfc_weight_bar.Constants;
import com.koenigstag.tfc_weight_bar.WeightBarHelpers;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;

public class WeightBarData {
    public static Map<String, Integer> playerWeights = new HashMap<String, Integer>();

    public static int serverGetCurrentWeight(Player player) {
        if (playerWeights.containsKey(player.m_20148_().toString())) {
            return playerWeights.get(player.m_20148_().toString());
        }
        return 0;
    }

    public static void serverChangeCurrentWeight(Player player, int newWeight) {
        playerWeights.put(player.m_20148_().toString(), newWeight);
        WeightBarData.triggerServerSideEffects(player, newWeight, WeightBarHelpers.getMaxInventoryWeight(player));
    }

    public static void triggerServerSideEffects(Player player, int playerInvWeight, int maxInvWeight) {
        Constants.debug("TriggerServerSideEffects");
        int hugeHeavyCount = CuriosHelpers.countOverburdened((Player)player);
        boolean isOverburdened = WeightBarHelpers.getIsOverburdened(playerInvWeight, maxInvWeight, hugeHeavyCount);
        if (isOverburdened) {
            Constants.debug("overburdened effects");
            if (Config.enableWeightDebuffs) {
                player.m_7292_(WeightBarHelpers.getOverburdened(false));
            }
        }
        boolean isExhausted = WeightBarHelpers.getIsExhausted(playerInvWeight, maxInvWeight, hugeHeavyCount);
        if (!isOverburdened && isExhausted) {
            Constants.debug("exhausted effects");
            if (Config.enableFoodExhaustion) {
                WeightBarData.serverAddPlayerFoodExhaustion(player, playerInvWeight, maxInvWeight);
            }
            if (Config.enableWeightDebuffs) {
                player.m_7292_(WeightBarHelpers.getExhausted(false));
            }
        }
        Constants.debug("Nickname: " + player.m_7755_() + "; Current Weight: " + playerInvWeight + "; Max Weight: " + maxInvWeight + "; Is Exhausted: " + isExhausted + "; Is Overburdened: " + isOverburdened + "; Bar color: " + WeightBarHelpers.getBarColor(playerInvWeight, maxInvWeight, hugeHeavyCount) + "; Bar percentage: " + WeightBarHelpers.getBarPercentage(playerInvWeight, player));
    }

    private static void serverAddPlayerFoodExhaustion(Player player, int playerInvWeight, int maxInvWeight) {
        int overburdened = playerInvWeight - maxInvWeight;
        int overburdenedPercent = (int)Mth.m_14036_((float)((float)overburdened / (float)maxInvWeight * 100.0f), (float)0.0f, (float)100.0f);
        if (overburdenedPercent > 0) {
            player.m_36324_().m_38703_((float)overburdenedPercent * 0.01f);
        } else {
            player.m_36324_().m_150378_(0.01f);
        }
    }
}

