/*
 * Decompiled with CFR 0.152.
 */
package com.koenigstag.tfc_weight_bar;

import com.koenigstag.tfc_curios_weight.CuriosHelpers;
import com.koenigstag.tfc_weight_bar.Config;
import com.koenigstag.tfc_weight_bar.Constants;
import com.koenigstag.tfc_weight_bar.WeightBarHelpers;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="tfc_weight_bar", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class ForgeClientEventHandler {
    private static int showMessageEachTicks = 200;

    public static void init() {
        IEventBus bus = MinecraftForge.EVENT_BUS;
        bus.register(ForgeClientEventHandler.class);
        Constants.LOGGER.info("Setup client event handler complete");
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (!Config.enableWeightCalculations) {
            return;
        }
        Player player = event.player;
        Level level = player.m_9236_();
        if (level.m_46467_() % (long)Config.calculateWeightEachNTicks == 0L) {
            int playerInvWeight = WeightBarHelpers.calculatePlayerFullWeight(player);
            int maxInvWeight = WeightBarHelpers.getMaxInventoryWeight(player);
            int hugeHeavyCount = CuriosHelpers.countOverburdened((Player)player);
            double barPercentage = WeightBarHelpers.getBarPercentage(playerInvWeight, player);
            String barColor = WeightBarHelpers.getBarColor(playerInvWeight, maxInvWeight, hugeHeavyCount);
            ForgeClientEventHandler.displayCurrentWeightClientMessage(player, level, playerInvWeight, maxInvWeight, hugeHeavyCount, barPercentage, barColor);
        }
    }

    @SubscribeEvent
    public static void itemToolTip(ItemTooltipEvent event) {
        ItemStack stack = event.getItemStack();
        int weight = WeightBarHelpers.getItemStackWeightInt(stack);
        int countOverweight = WeightBarHelpers.getItemOverweightInt(stack);
        MutableComponent tooHeavyText = countOverweight >= 1 ? ForgeClientEventHandler.translateComponent("tfc_weight_bar.tooltip.too_heavy_to_carry") : Component.m_237119_();
        Component tooltipComponent = ForgeClientEventHandler.formatComponent("tfc_weight_bar.tooltip.weight_format", weight, tooHeavyText);
        event.getToolTip().add(tooltipComponent);
    }

    private static void displayCurrentWeightClientMessage(Player player, Level level, int playerInvWeight, int maxInvWeight, int hugeHeavyCount, double barPercentage, String barColor) {
        if (!Config.enableUIBar && level.m_46467_() % (long)showMessageEachTicks == 0L) {
            Component message = ForgeClientEventHandler.createWeightMessage(playerInvWeight, maxInvWeight, barPercentage, hugeHeavyCount);
            MutableComponent msgComponent = message.m_6881_();
            msgComponent.m_130948_(ForgeClientEventHandler.getTextStyle(barColor));
            player.m_5661_((Component)msgComponent, true);
            Constants.debug(message.getString());
        }
    }

    private static Component createWeightMessage(int playerInvWeight, int maxInvWeight, double barPercentage, int hugeHeavyCount) {
        boolean isOverburdened = WeightBarHelpers.getIsOverburdened(playerInvWeight, maxInvWeight, hugeHeavyCount);
        if (isOverburdened) {
            return ForgeClientEventHandler.translateComponent("tfc_weight_bar.status.overburden");
        }
        return ForgeClientEventHandler.formatComponent("tfc_weight_bar.message.weight_format", playerInvWeight, maxInvWeight, Math.round(barPercentage * 100.0));
    }

    private static Style getTextStyle(String barColor) {
        Style style = Style.f_131099_;
        if (barColor.equals("red")) {
            style.m_131148_(TextColor.m_131268_((String)"RED"));
        } else if (barColor.equals("pink")) {
            style.m_131148_(TextColor.m_131268_((String)"LIGHT_PURPLE"));
        } else if (barColor.equals("gray")) {
            style.m_131148_(TextColor.m_131268_((String)"GRAY"));
        } else {
            style.m_131148_(TextColor.m_131268_((String)"RESET"));
        }
        return style;
    }

    private static Component translateComponent(String key) {
        return Component.m_237115_((String)key);
    }

    private static Component formatComponent(String key, Object ... args) {
        return Component.m_237110_((String)key, (Object[])args);
    }
}

