/*
 * Decompiled with CFR 0.152.
 */
package com.koenigstag.tfc_curios_weight;

import com.koenigstag.tfc_curios_weight.Config;
import net.dries007.tfc.common.TFCEffects;
import net.dries007.tfc.common.capabilities.size.IItemSize;
import net.dries007.tfc.common.capabilities.size.ItemSizeManager;
import net.dries007.tfc.common.capabilities.size.Size;
import net.dries007.tfc.common.capabilities.size.Weight;
import net.minecraft.world.Container;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShieldItem;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.items.IItemHandlerModifiable;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;

public class CuriosHelpers {
    public static int countOverburdened(Player livingEntity) {
        ItemStack offHandItemStack;
        int offHandWeight;
        LazyOptional lazyCuriosInventory;
        int overweightCount = 0;
        Inventory container = livingEntity.m_150109_();
        if ((overweightCount += CuriosHelpers.countOverburdened((Container)container)) == 1) {
            return 2;
        }
        if (!Config.enableCuriosWeightCalculations) {
            return overweightCount;
        }
        int curiosWeightCount = 0;
        if (ModList.get().isLoaded("curios") && (lazyCuriosInventory = CuriosApi.getCuriosInventory((LivingEntity)livingEntity)).isPresent()) {
            ICuriosItemHandler curiosInventory = (ICuriosItemHandler)lazyCuriosInventory.resolve().get();
            IItemHandlerModifiable curiosContainer = curiosInventory.getEquippedCurios();
            for (int i = 0; i < curiosContainer.getSlots(); ++i) {
                ItemStack stack = curiosContainer.getStackInSlot(i);
                if ((curiosWeightCount += CuriosHelpers.getItemStackWeightInt(stack)) < 2) continue;
                return curiosWeightCount;
            }
        }
        if ((offHandWeight = CuriosHelpers.getItemStackWeightInt(offHandItemStack = container.m_8020_(CuriosHelpers.getSlotIndex(EquipmentSlot.OFFHAND)))) == 1 && curiosWeightCount >= 1 || curiosWeightCount >= 2) {
            return 1;
        }
        return overweightCount;
    }

    public static int countOverburdened(Container container) {
        int count = 0;
        for (int i = 0; i < container.m_6643_(); ++i) {
            ItemStack stack = container.m_8020_(i);
            boolean canOverweight = CuriosHelpers.canItemOverweight(i, stack);
            if (!canOverweight) continue;
            count += CuriosHelpers.getItemStackWeightInt(stack);
        }
        return count;
    }

    public static int getItemStackWeightInt(ItemStack itemStack) {
        IItemSize size;
        if (!itemStack.m_41619_() && (size = ItemSizeManager.get((ItemStack)itemStack)).getWeight(itemStack) == Weight.VERY_HEAVY && size.getSize(itemStack) == Size.HUGE) {
            return 1;
        }
        return 0;
    }

    public static boolean canItemOverweight(int slotIndex, ItemStack itemStack) {
        if (!itemStack.m_41619_()) {
            Item item = itemStack.m_41720_();
            if (item instanceof ShieldItem && slotIndex == CuriosHelpers.getSlotIndex(EquipmentSlot.OFFHAND)) {
                return false;
            }
            if (CuriosHelpers.getIsArmorType(item, ArmorItem.Type.CHESTPLATE) && slotIndex == CuriosHelpers.getSlotIndex(EquipmentSlot.CHEST)) {
                return false;
            }
            if (CuriosHelpers.getIsArmorType(item, ArmorItem.Type.BOOTS) && slotIndex == CuriosHelpers.getSlotIndex(EquipmentSlot.FEET)) {
                return false;
            }
            if (CuriosHelpers.getIsArmorType(item, ArmorItem.Type.LEGGINGS) && slotIndex == CuriosHelpers.getSlotIndex(EquipmentSlot.LEGS)) {
                return false;
            }
            if (CuriosHelpers.getIsArmorType(item, ArmorItem.Type.HELMET) && slotIndex == CuriosHelpers.getSlotIndex(EquipmentSlot.HEAD)) {
                return false;
            }
        }
        return true;
    }

    public static int getSlotIndex(EquipmentSlot slot) {
        switch (slot) {
            case OFFHAND: {
                return 40;
            }
            case HEAD: {
                return 39;
            }
            case CHEST: {
                return 38;
            }
            case LEGS: {
                return 37;
            }
            case FEET: {
                return 36;
            }
        }
        return -1;
    }

    public static boolean getIsArmorType(Item item, ArmorItem.Type type) {
        return item instanceof ArmorItem && ((ArmorItem)item).m_266204_() == type;
    }

    public static MobEffectInstance getOverburdened(boolean visible) {
        return new MobEffectInstance((MobEffect)TFCEffects.OVERBURDENED.get(), Config.calculateWeightEachNTicks + 5, 0, false, visible);
    }

    public static MobEffectInstance getExhausted(boolean visible) {
        return new MobEffectInstance((MobEffect)TFCEffects.EXHAUSTED.get(), Config.calculateWeightEachNTicks + 5, 0, false, visible);
    }
}

