/*
 * Decompiled with CFR 0.152.
 */
package com.therighthon.rnr.common.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Either;
import com.therighthon.rnr.common.RNRTags;
import com.therighthon.rnr.common.recipe.RNRRecipeSerializers;
import com.therighthon.rnr.common.recipe.RNRRecipeTypes;
import net.dries007.tfc.common.capabilities.player.PlayerDataCapability;
import net.dries007.tfc.common.fluids.FluidHelpers;
import net.dries007.tfc.common.recipes.ChiselRecipe;
import net.dries007.tfc.common.recipes.RecipeSerializerImpl;
import net.dries007.tfc.common.recipes.SimpleBlockRecipe;
import net.dries007.tfc.common.recipes.ingredients.BlockIngredient;
import net.dries007.tfc.common.recipes.outputs.ItemStackProvider;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.JsonHelpers;
import net.dries007.tfc.util.collections.IndirectHashCollection;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class MattockRecipe
extends SimpleBlockRecipe {
    public static final IndirectHashCollection<Block, MattockRecipe> CACHE = IndirectHashCollection.createForRecipe(recipe -> recipe.getBlockIngredient().blocks(), RNRRecipeTypes.MATTOCK_RECIPE);
    private final ChiselRecipe.Mode mode;
    @Nullable
    private final Ingredient itemIngredient;
    private final ItemStackProvider extraDrop;

    public static Either<BlockState, InteractionResult> computeResult(Player player, BlockState state, BlockHitResult hit, boolean informWhy) {
        ItemStack held = player.m_21205_();
        if (Helpers.isItem((ItemStack)held, RNRTags.Items.MATTOCKS)) {
            BlockPos pos = hit.m_82425_();
            return player.getCapability(PlayerDataCapability.CAPABILITY).map(cap -> {
                ChiselRecipe.Mode mode = cap.getChiselMode();
                MattockRecipe recipe = MattockRecipe.getRecipe(state, held, mode);
                if (recipe == null) {
                    if (informWhy) {
                        MattockRecipe.complain(player, "no_recipe");
                    }
                    return Either.right((Object)InteractionResult.PASS);
                }
                BlockState chiseled = recipe.getBlockCraftingResult(state);
                if ((chiseled = chiseled.m_60734_().m_5573_(new BlockPlaceContext(player, InteractionHand.MAIN_HAND, new ItemStack((ItemLike)chiseled.m_60734_()), hit))) == null) {
                    if (informWhy) {
                        MattockRecipe.complain(player, "cannot_place");
                    }
                    return Either.right((Object)InteractionResult.FAIL);
                }
                if ((chiseled = FluidHelpers.fillWithFluid((BlockState)chiseled, (Fluid)player.m_9236_().m_6425_(pos).m_76152_())) == null) {
                    if (informWhy) {
                        MattockRecipe.complain(player, "bad_fluid");
                    }
                    return Either.right((Object)InteractionResult.FAIL);
                }
                return Either.left((Object)chiseled);
            }).orElse(Either.right((Object)InteractionResult.PASS));
        }
        return Either.right((Object)InteractionResult.PASS);
    }

    private static void complain(Player player, String message) {
        player.m_5661_((Component)Component.m_237115_((String)("rnr.mattock." + message)), true);
    }

    @Nullable
    public static MattockRecipe getRecipe(BlockState state, ItemStack held, ChiselRecipe.Mode mode) {
        for (MattockRecipe recipe : CACHE.getAll((Object)state.m_60734_())) {
            if (!recipe.matches(state, held, mode)) continue;
            return recipe;
        }
        return null;
    }

    public MattockRecipe(ResourceLocation id, BlockIngredient ingredient, BlockState outputState, ChiselRecipe.Mode mode, @Nullable Ingredient itemIngredient, ItemStackProvider extraDrop) {
        super(id, ingredient, outputState, false);
        this.mode = mode;
        this.itemIngredient = itemIngredient;
        this.extraDrop = extraDrop;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)RNRRecipeSerializers.MATTOCK_RECIPE.get();
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)RNRRecipeTypes.MATTOCK_RECIPE.get();
    }

    public boolean matches(BlockState state, ItemStack stack, ChiselRecipe.Mode mode) {
        if (this.itemIngredient != null && !this.itemIngredient.test(stack)) {
            return false;
        }
        return mode == this.mode && this.matches(state);
    }

    public ChiselRecipe.Mode getMode() {
        return this.mode;
    }

    @Nullable
    public Ingredient getItemIngredient() {
        return this.itemIngredient;
    }

    public ItemStack getExtraDrop(ItemStack mattock) {
        return this.extraDrop.getSingleStack(mattock);
    }

    public static class Serializer
    extends RecipeSerializerImpl<MattockRecipe> {
        public MattockRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            BlockIngredient ingredient = BlockIngredient.fromJson((JsonElement)JsonHelpers.get((JsonObject)json, (String)"ingredient"));
            BlockState state = JsonHelpers.getBlockState((String)GsonHelper.m_13906_((JsonObject)json, (String)"result"));
            ChiselRecipe.Mode mode = (ChiselRecipe.Mode)JsonHelpers.getEnum((JsonObject)json, (String)"mode", ChiselRecipe.Mode.class, (Enum)ChiselRecipe.Mode.SMOOTH);
            Ingredient itemIngredient = json.has("item_ingredient") ? Ingredient.m_43917_((JsonElement)json.get("item_ingredient")) : null;
            ItemStackProvider drop = json.has("extra_drop") ? ItemStackProvider.fromJson((JsonObject)JsonHelpers.m_13930_((JsonObject)json, (String)"extra_drop")) : ItemStackProvider.empty();
            return new MattockRecipe(recipeId, ingredient, state, mode, itemIngredient, drop);
        }

        @Nullable
        public MattockRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            BlockIngredient ingredient = BlockIngredient.fromNetwork((FriendlyByteBuf)buffer);
            BlockState state = ((Block)buffer.readRegistryIdUnsafe(ForgeRegistries.BLOCKS)).m_49966_();
            ChiselRecipe.Mode mode = (ChiselRecipe.Mode)buffer.m_130066_(ChiselRecipe.Mode.class);
            Ingredient itemIngredient = (Ingredient)Helpers.decodeNullable((FriendlyByteBuf)buffer, Ingredient::m_43940_);
            ItemStackProvider drop = ItemStackProvider.fromNetwork((FriendlyByteBuf)buffer);
            return new MattockRecipe(recipeId, ingredient, state, mode, itemIngredient, drop);
        }

        public void toNetwork(FriendlyByteBuf buffer, MattockRecipe recipe) {
            recipe.ingredient.toNetwork(buffer);
            buffer.writeRegistryIdUnsafe(ForgeRegistries.BLOCKS, (Object)recipe.outputState.m_60734_());
            buffer.m_130068_((Enum)recipe.getMode());
            Helpers.encodeNullable((Object)recipe.itemIngredient, (FriendlyByteBuf)buffer, Ingredient::m_43923_);
            recipe.extraDrop.toNetwork(buffer);
        }
    }
}

