/*
 * Decompiled with CFR 0.152.
 */
package com.therighthon.rnr.common.item;

import com.therighthon.rnr.common.fluid.RNRFluids;
import com.therighthon.rnr.common.fluid.SimpleRNRFluid;
import com.therighthon.rnr.common.item.MattockItem;
import java.util.Locale;
import java.util.Map;
import java.util.function.Supplier;
import net.dries007.tfc.common.blocks.rock.Rock;
import net.dries007.tfc.common.blocks.soil.SandBlockType;
import net.dries007.tfc.common.blocks.wood.Wood;
import net.dries007.tfc.common.items.ToolItem;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.Metal;
import net.dries007.tfc.util.registry.RegistryMetal;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Tier;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class RNRItems {
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"rnr");
    public static final Map<Metal.Default, RegistryObject<Item>> MATTOCK_HEADS = Helpers.mapOfKeys(Metal.Default.class, Metal.Default::hasUtilities, metal -> RNRItems.register("metal/mattock_head/" + metal.name()));
    public static final Map<Metal.Default, RegistryObject<Item>> MATTOCKS = Helpers.mapOfKeys(Metal.Default.class, Metal.Default::hasUtilities, metal -> RNRItems.register("metal/mattock/" + metal.name(), () -> new MattockItem(metal.toolTier(), ToolItem.calculateVanillaAttackDamage((float)0.27f, (Tier)metal.toolTier()), -1.5f, Metal.ItemType.properties((RegistryMetal)metal))));
    public static final Map<Rock, RegistryObject<Item>> FLAGSTONE = Helpers.mapOfKeys(Rock.class, type -> RNRItems.register("flagstone/" + type.name()));
    public static final Map<Rock, RegistryObject<Item>> GRAVEL_FILL = Helpers.mapOfKeys(Rock.class, type -> RNRItems.register("gravel_fill/" + type.name()));
    public static final Map<SandBlockType, RegistryObject<Item>> SANDSTONE_FLAGSTONE = Helpers.mapOfKeys(SandBlockType.class, type -> RNRItems.register("flagstone/" + type.name() + "_sandstone"));
    public static final RegistryObject<Item> UNFIRED_ROOF_TILE = RNRItems.register("unfired_roof_tile");
    public static final RegistryObject<Item> UNFIRED_TERRACOTTA_ROOF_TILE = RNRItems.register("unfired_terracotta_roof_tile");
    public static final RegistryObject<Item> CERAMIC_ROOF_TILE = RNRItems.register("ceramic_roof_tile");
    public static final RegistryObject<Item> TERRACOTTA_ROOF_TILE = RNRItems.register("terracotta_roof_tile");
    public static final RegistryObject<Item> CONCRETE_POWDER = RNRItems.register("concrete_powder");
    public static final Map<Wood, RegistryObject<Item>> WOOD_SHINGLE = Helpers.mapOfKeys(Wood.class, wood -> RNRItems.register("wood/shingle/" + wood.m_7912_()));
    public static final RegistryObject<Item> CRUSHED_BASE_COURSE = RNRItems.register("crushed_base_course");
    public static final RegistryObject<Item> HOGGIN_MIX = RNRItems.register("hoggin_mix");
    public static final Map<SimpleRNRFluid, RegistryObject<BucketItem>> SIMPLE_RNR_FLUID_BUCKETS = Helpers.mapOfKeys(SimpleRNRFluid.class, fluid -> RNRItems.register("bucket/" + fluid.m_7912_(), () -> new BucketItem((Supplier)RNRFluids.SIMPLE_RNR_FLUIDS.get(fluid).source(), new Item.Properties())));

    private static RegistryObject<Item> register(String name) {
        return RNRItems.register(name, () -> new Item(new Item.Properties()));
    }

    private static <T extends Item> RegistryObject<T> register(String name, Supplier<T> item) {
        return ITEMS.register(name.toLowerCase(Locale.ROOT), item);
    }
}

