/*
 * Decompiled with CFR 0.152.
 */
package com.therighthon.rnr.common.block;

import com.therighthon.rnr.common.block.GravelPathBlock;
import com.therighthon.rnr.common.block.GravelPathSlabBlock;
import com.therighthon.rnr.common.block.MacadamPathBlock;
import com.therighthon.rnr.common.block.MacadamPathSlabBlock;
import com.therighthon.rnr.common.block.OverHeightBlock;
import com.therighthon.rnr.common.block.PathStairBlock;
import com.therighthon.rnr.common.block.StonePathBlock;
import com.therighthon.rnr.common.block.StonePathSlabBlock;
import java.util.Locale;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import net.dries007.tfc.common.blocks.rock.Rock;
import net.dries007.tfc.util.registry.RegistryRock;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.material.MapColor;

public enum StoneBlockType implements StringRepresentable
{
    GRAVEL_ROAD((rock, self) -> new GravelPathBlock(StoneBlockType.properties(rock).m_60918_(SoundType.f_56739_).m_60913_(rock.category().hardness(3.5f), 4.0f)), true),
    OVER_HEIGHT_GRAVEL((rock, self) -> new OverHeightBlock(StoneBlockType.properties(rock).m_60918_(SoundType.f_56739_).m_60913_(rock.category().hardness(3.5f), 4.0f)), false),
    MACADAM_ROAD((rock, self) -> new MacadamPathBlock(StoneBlockType.properties(rock).m_60918_(SoundType.f_56739_).m_60913_(rock.category().hardness(4.0f), 5.0f)), true),
    FLAGSTONES((rock, self) -> new StonePathBlock(StoneBlockType.properties(rock).m_60913_(rock.category().hardness(5.0f), 8.0f)), true),
    SETT_ROAD((rock, self) -> new StonePathBlock(StoneBlockType.properties(rock).m_60913_(rock.category().hardness(5.0f), 8.0f)), true),
    COBBLED_ROAD((rock, self) -> new StonePathBlock(StoneBlockType.properties(rock).m_60913_(rock.category().hardness(5.0f), 8.0f)), true);

    public static final StoneBlockType[] VALUES;
    private final boolean variants;
    private final BiFunction<RegistryRock, StoneBlockType, Block> blockFactory;
    private final String serializedName;

    public static StoneBlockType valueOf(int i) {
        return i >= 0 && i < VALUES.length ? VALUES[i] : GRAVEL_ROAD;
    }

    private static BlockBehaviour.Properties properties(RegistryRock rock) {
        return BlockBehaviour.Properties.m_284310_().m_284180_(rock.color()).m_60918_(SoundType.f_56742_).m_280658_(NoteBlockInstrument.BASEDRUM);
    }

    private StoneBlockType(BiFunction<RegistryRock, StoneBlockType, Block> blockFactory, boolean variants) {
        this.blockFactory = blockFactory;
        this.variants = variants;
        this.serializedName = this.name().toLowerCase(Locale.ROOT);
    }

    public boolean hasVariants() {
        return this.variants;
    }

    public Block create(RegistryRock rock) {
        return this.blockFactory.apply(rock, this);
    }

    public Block createRockSlab(RegistryRock rock, StoneBlockType type) {
        BlockBehaviour.Properties properties = BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283947_).m_60918_(SoundType.f_56742_).m_60913_(1.5f, 10.0f).m_60999_();
        if (type == GRAVEL_ROAD) {
            return new GravelPathSlabBlock(properties);
        }
        if (type == MACADAM_ROAD) {
            return new MacadamPathSlabBlock(properties);
        }
        return new StonePathSlabBlock(properties);
    }

    public PathStairBlock createPathStairs(RegistryRock rock, StoneBlockType type) {
        Supplier<BlockState> state = () -> ((Block)rock.getBlock(Rock.BlockType.RAW).get()).m_49966_();
        BlockBehaviour.Properties properties = BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283947_).m_60918_(SoundType.f_56742_).m_60913_(1.5f, 10.0f).m_60999_();
        if (type == MACADAM_ROAD) {
            return new PathStairBlock(state, properties, MacadamPathBlock.getDefaultSpeedFactor());
        }
        if (type == GRAVEL_ROAD) {
            return new PathStairBlock(state, properties, GravelPathBlock.getDefaultSpeedFactor());
        }
        return new PathStairBlock(state, properties, StonePathBlock.getDefaultSpeedFactor());
    }

    public String m_7912_() {
        return this.serializedName;
    }

    static {
        VALUES = StoneBlockType.values();
    }
}

