/*
 * Decompiled with CFR 0.152.
 */
package com.talons.utils.client;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.vertex.PoseStack;
import com.talons.utils.client.CustomVertexConsumer;
import com.talons.utils.stacks.UtilItemStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionf;

public class UtilRenderItem {
    public static Minecraft MC = Minecraft.m_91087_();
    public static ItemRenderer renderItem = MC.m_91291_();
    public static LocalPlayer player = Minecraft.m_91087_().f_91074_;
    private final ItemStack stack;
    private PoseStack poseStack;
    private Vec3 position = null;
    private CustomVertexConsumer.ColorAction colorAction = null;
    private MultiBufferSource buffer = null;
    private Integer combinedLight = null;
    private Integer combinedOverlay = null;
    private boolean rotate = false;
    private static final Vec3 DEFAULT_POSITION = new Vec3(0.0, 0.0, 0.0);
    private static final int DEFAULT_COMBINED_LIGHT = 0xF000F0;
    private static final int DEFAULT_COMBINED_OVERLAY = OverlayTexture.f_118083_;

    private static MultiBufferSource DEFAULT_BUFFER() {
        return MC.m_91269_().m_110104_();
    }

    public static UtilRenderItem init(ItemStack stack) {
        return new UtilRenderItem(stack);
    }

    private UtilRenderItem(ItemStack stack) {
        this.stack = stack;
    }

    public UtilRenderItem pose(PoseStack poseStack) {
        this.poseStack = poseStack;
        return this;
    }

    public UtilRenderItem pos(double x, double y, double z) {
        this.position = new Vec3(x, y, z);
        return this;
    }

    public UtilRenderItem rotate() {
        this.rotate = true;
        return this;
    }

    public UtilRenderItem buffer(MultiBufferSource buffer) {
        this.buffer = buffer;
        return this;
    }

    public UtilRenderItem combined(int combinedLight, int combinedOverlay) {
        this.combinedLight = combinedLight;
        this.combinedOverlay = combinedOverlay;
        return this;
    }

    public void render() {
        if (!UtilItemStack.isValid(this.stack)) {
            return;
        }
        MultiBufferSource buffer = this.buffer != null ? this.buffer : UtilRenderItem.DEFAULT_BUFFER();
        Vec3 position = this.position != null ? this.position : DEFAULT_POSITION;
        int combinedLight = this.combinedLight != null ? this.combinedLight : 0xF000F0;
        int combinedOverlay = this.combinedOverlay != null ? this.combinedOverlay : DEFAULT_COMBINED_OVERLAY;
        BakedModel model = renderItem.m_174264_(this.stack, null, (LivingEntity)player, 0);
        this.poseStack.m_85836_();
        boolean render3D = model.m_7539_();
        if (render3D) {
            Lighting.m_84931_();
        } else {
            Lighting.m_84930_();
        }
        if (position != null) {
            this.poseStack.m_85837_(position.f_82479_, position.f_82480_, position.f_82481_);
        }
        if (this.rotate) {
            long time = System.currentTimeMillis() / -40L % 360L;
            this.poseStack.m_252781_(new Quaternionf().fromAxisAngleDeg(0.0f, 1.0f, 0.0f, (float)time));
        }
        if (!render3D) {
            this.poseStack.m_85841_(0.8f, 0.8f, 0.8f);
            this.poseStack.m_85837_(0.0, 0.1, 0.0);
        }
        if (this.colorAction != null) {
            System.out.println("ERROR: COLOR ACTION SHOULD BE NULL");
        } else {
            renderItem.m_115143_(this.stack, ItemDisplayContext.GROUND, false, this.poseStack, buffer, combinedLight, combinedOverlay, model);
        }
        this.poseStack.m_85849_();
    }
}

