/*
 * Decompiled with CFR 0.152.
 */
package com.koenigstag.item_color_name;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.WrittenBookItem;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class AnvilColorHandler {
    private static final Map<TagKey<Item>, ChatFormatting> COLOR_TAGS = new HashMap<TagKey<Item>, ChatFormatting>();

    private static void addForgeDyeTags(String dyeColor, ChatFormatting formatting) {
        TagKey tag = ItemTags.create((ResourceLocation)new ResourceLocation("forge", "dyes/" + dyeColor));
        COLOR_TAGS.put((TagKey<Item>)tag, formatting);
    }

    private static void addCustomDyeTags(String dyeColor, ChatFormatting formatting) {
        TagKey tag = ItemTags.create((ResourceLocation)new ResourceLocation("item_color_name", "dyes/" + dyeColor));
        COLOR_TAGS.put((TagKey<Item>)tag, formatting);
    }

    public static void register() {
        MinecraftForge.EVENT_BUS.register((Object)new AnvilColorHandler());
    }

    @SubscribeEvent
    public void onAnvilUpdate(AnvilUpdateEvent event) {
        ItemStack left = event.getLeft();
        ItemStack right = event.getRight();
        String name = event.getName();
        if (left.m_41619_() || right.m_41619_()) {
            return;
        }
        int required = left.m_41613_();
        if (right.m_41613_() < required) {
            return;
        }
        ItemStack output = left.m_41777_();
        if (output != null) {
            output = this.setItemNameColored(left, name, right);
        }
        if (right.m_41720_() instanceof WrittenBookItem) {
            output = this.setItemLoreFromBook(left, right);
        }
        if (output == null) {
            return;
        }
        event.setCost(5);
        event.setMaterialCost(required);
        event.setOutput(output);
    }

    private ItemStack setItemNameColored(ItemStack input, String name, ItemStack reagent) {
        ChatFormatting color = this.getColorFromReagent(reagent);
        if (color == null || input == null) {
            return null;
        }
        ItemStack output = input.m_41777_();
        if (name == null || name.isBlank()) {
            name = output.m_41788_() ? output.m_41786_().getString() : output.m_41611_().getString();
        }
        String cleanedName = this.cleanItemName(name);
        MutableComponent coloredName = Component.m_237113_((String)cleanedName).m_130948_(Style.f_131099_.m_131140_(color));
        CompoundTag display = output.m_41698_("display");
        display.m_128359_("Name", Component.Serializer.m_130703_((Component)coloredName));
        return output;
    }

    private ChatFormatting getColorFromReagent(ItemStack reagent) {
        if (reagent == null) {
            return null;
        }
        for (Map.Entry<TagKey<Item>, ChatFormatting> entry : COLOR_TAGS.entrySet()) {
            if (!reagent.m_204117_(entry.getKey())) continue;
            return entry.getValue();
        }
        return null;
    }

    private ItemStack setItemLoreFromBook(ItemStack input, ItemStack book) {
        Component firstPageText = this.getFirstPageText(book);
        if (firstPageText == null || input == null) {
            return null;
        }
        ItemStack output = input.m_41777_();
        CompoundTag displayTag = output.m_41698_("display");
        ListTag loreList = new ListTag();
        loreList.add((Object)StringTag.m_129297_((String)Component.Serializer.m_130703_((Component)firstPageText)));
        displayTag.m_128365_("Lore", (Tag)loreList);
        return output;
    }

    private Component getFirstPageText(ItemStack input) {
        if (input == null || !(input.m_41720_() instanceof WrittenBookItem)) {
            return null;
        }
        CompoundTag tag = input.m_41783_();
        if (tag == null || !tag.m_128425_("pages", 9)) {
            return null;
        }
        ListTag pages = tag.m_128437_("pages", 8);
        if (pages.isEmpty()) {
            return null;
        }
        String json = pages.m_128778_(0);
        if (json == null || json.isEmpty()) {
            return null;
        }
        MutableComponent pageText = Component.Serializer.m_130701_((String)json);
        if (pageText == null) {
            return null;
        }
        return pageText;
    }

    private String cleanItemName(String name) {
        if (name == null || name.isEmpty()) {
            return null;
        }
        String cleanedName = name.replaceAll("[\\[\\]]", "");
        return cleanedName;
    }

    static {
        AnvilColorHandler.addForgeDyeTags("black", ChatFormatting.BLACK);
        AnvilColorHandler.addCustomDyeTags("black", ChatFormatting.BLACK);
        AnvilColorHandler.addCustomDyeTags("dark_blue", ChatFormatting.DARK_BLUE);
        AnvilColorHandler.addForgeDyeTags("green", ChatFormatting.DARK_GREEN);
        AnvilColorHandler.addCustomDyeTags("dark_green", ChatFormatting.DARK_GREEN);
        AnvilColorHandler.addCustomDyeTags("dark_aqua", ChatFormatting.DARK_AQUA);
        AnvilColorHandler.addCustomDyeTags("dark_red", ChatFormatting.DARK_RED);
        AnvilColorHandler.addForgeDyeTags("brown", ChatFormatting.DARK_RED);
        AnvilColorHandler.addForgeDyeTags("purple", ChatFormatting.DARK_PURPLE);
        AnvilColorHandler.addCustomDyeTags("dark_purple", ChatFormatting.DARK_PURPLE);
        AnvilColorHandler.addForgeDyeTags("orange", ChatFormatting.GOLD);
        AnvilColorHandler.addCustomDyeTags("gold", ChatFormatting.GOLD);
        AnvilColorHandler.addForgeDyeTags("light_gray", ChatFormatting.GRAY);
        AnvilColorHandler.addCustomDyeTags("gray", ChatFormatting.GRAY);
        AnvilColorHandler.addForgeDyeTags("gray", ChatFormatting.DARK_GRAY);
        AnvilColorHandler.addCustomDyeTags("dark_gray", ChatFormatting.DARK_GRAY);
        AnvilColorHandler.addForgeDyeTags("blue", ChatFormatting.BLUE);
        AnvilColorHandler.addCustomDyeTags("blue", ChatFormatting.BLUE);
        AnvilColorHandler.addForgeDyeTags("lime", ChatFormatting.GREEN);
        AnvilColorHandler.addCustomDyeTags("green", ChatFormatting.GREEN);
        AnvilColorHandler.addForgeDyeTags("cyan", ChatFormatting.AQUA);
        AnvilColorHandler.addCustomDyeTags("aqua", ChatFormatting.AQUA);
        AnvilColorHandler.addForgeDyeTags("light_blue", ChatFormatting.AQUA);
        AnvilColorHandler.addCustomDyeTags("light_blue", ChatFormatting.AQUA);
        AnvilColorHandler.addForgeDyeTags("red", ChatFormatting.RED);
        AnvilColorHandler.addCustomDyeTags("red", ChatFormatting.RED);
        AnvilColorHandler.addForgeDyeTags("pink", ChatFormatting.LIGHT_PURPLE);
        AnvilColorHandler.addForgeDyeTags("magenta", ChatFormatting.LIGHT_PURPLE);
        AnvilColorHandler.addCustomDyeTags("light_purple", ChatFormatting.LIGHT_PURPLE);
        AnvilColorHandler.addForgeDyeTags("yellow", ChatFormatting.YELLOW);
        AnvilColorHandler.addCustomDyeTags("yellow", ChatFormatting.YELLOW);
        AnvilColorHandler.addForgeDyeTags("white", ChatFormatting.WHITE);
        AnvilColorHandler.addCustomDyeTags("white", ChatFormatting.WHITE);
    }
}

