/*
 * Decompiled with CFR 0.152.
 */
package com.nebby1999.firmacivplus.datagen.recipe_builders;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.dries007.tfc.common.recipes.TFCRecipeSerializers;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.RequirementsStrategy;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public abstract class CraftingRecipeBuilder<B extends CraftingRecipeBuilder<B>>
extends net.minecraft.data.recipes.CraftingRecipeBuilder
implements RecipeBuilder {
    protected final String folderName;
    protected final CraftingBookCategory craftingBookCategory;
    protected final Item result;
    protected final int count;
    protected final Advancement.Builder advancement = Advancement.Builder.m_285878_();
    @Nullable
    protected String group;
    protected boolean damageInputs;

    protected CraftingRecipeBuilder(CraftingBookCategory craftingBookCategory, String folderName, ItemLike result, int count) {
        this.craftingBookCategory = craftingBookCategory;
        this.folderName = folderName;
        this.result = result.m_5456_();
        this.count = count;
    }

    public static ShapelessCraftingRecipeBuilder shapeless(ItemLike result) {
        return CraftingRecipeBuilder.shapeless("crafting", result);
    }

    public static ShapelessCraftingRecipeBuilder shapeless(ItemLike result, int count) {
        return CraftingRecipeBuilder.shapeless("crafting", result, count);
    }

    public static ShapelessCraftingRecipeBuilder shapeless(String folderName, ItemLike result) {
        return CraftingRecipeBuilder.shapeless(folderName, result, 1);
    }

    public static ShapelessCraftingRecipeBuilder shapeless(String folderName, ItemLike result, int count) {
        return new ShapelessCraftingRecipeBuilder(CraftingBookCategory.MISC, folderName, result, count);
    }

    public static ShapedCraftingRecipeBuilder shaped(ItemLike result) {
        return CraftingRecipeBuilder.shaped("crafting", result);
    }

    public static ShapedCraftingRecipeBuilder shaped(ItemLike result, int count) {
        return CraftingRecipeBuilder.shaped("crafting", result, count);
    }

    public static ShapedCraftingRecipeBuilder shaped(String folderName, ItemLike result) {
        return CraftingRecipeBuilder.shaped(folderName, result, 1);
    }

    public static ShapedCraftingRecipeBuilder shaped(String folderName, ItemLike result, int count) {
        return new ShapedCraftingRecipeBuilder(CraftingBookCategory.MISC, folderName, result, count);
    }

    public B unlockedBy(String criterionName, CriterionTriggerInstance criterionTrigger) {
        this.advancement.m_138386_(criterionName, criterionTrigger);
        return this.self();
    }

    public B group(@Nullable String groupName) {
        this.group = groupName;
        return this.self();
    }

    public Item m_142372_() {
        return this.result;
    }

    public void m_126140_(Consumer<FinishedRecipe> finishedRecipeConsumer, ResourceLocation recipeId) {
        this.ensureValid(recipeId);
        this.advancement.m_138396_(f_236353_).m_138386_("has_the_recipe", (CriterionTriggerInstance)RecipeUnlockedTrigger.m_63728_((ResourceLocation)recipeId)).m_138354_(AdvancementRewards.Builder.m_10009_((ResourceLocation)recipeId)).m_138360_(RequirementsStrategy.f_15979_);
        finishedRecipeConsumer.accept(this.createRecipe(recipeId));
    }

    public void m_176498_(Consumer<FinishedRecipe> finishedRecipeConsumer) {
        this.m_126140_(finishedRecipeConsumer, RecipeBuilder.m_176493_((ItemLike)this.m_142372_()).m_246208_(this.folderName + "/"));
    }

    public B damageInputs() {
        this.damageInputs = true;
        return this.self();
    }

    protected void ensureValid(ResourceLocation recipeId) {
        if (this.advancement.m_138405_().isEmpty()) {
            throw new IllegalStateException("No way of obtaining recipe " + String.valueOf(recipeId));
        }
    }

    protected abstract B self();

    protected abstract FinishedRecipe createRecipe(ResourceLocation var1);

    public static final class ShapelessCraftingRecipeBuilder
    extends CraftingRecipeBuilder<ShapelessCraftingRecipeBuilder> {
        private final List<Ingredient> ingredients = Lists.newArrayList();

        private ShapelessCraftingRecipeBuilder(CraftingBookCategory craftingBookCategory, String folderName, ItemLike result, int count) {
            super(craftingBookCategory, folderName, result, count);
        }

        public ShapelessCraftingRecipeBuilder requires(TagKey<Item> tag) {
            return this.requires(Ingredient.m_204132_(tag));
        }

        public ShapelessCraftingRecipeBuilder requires(ItemLike item) {
            return this.requires(Ingredient.m_43929_((ItemLike[])new ItemLike[]{item}));
        }

        public ShapelessCraftingRecipeBuilder requires(ItemLike item, int quantity) {
            for (int i = 0; i < quantity; ++i) {
                this.requires(item);
            }
            return this;
        }

        public ShapelessCraftingRecipeBuilder requires(Ingredient ingredient) {
            this.ingredients.add(ingredient);
            return this;
        }

        public ShapelessCraftingRecipeBuilder requires(Ingredient ingredient, int quantity) {
            for (int i = 0; i < quantity; ++i) {
                this.requires(ingredient);
            }
            return this;
        }

        @Override
        protected void ensureValid(ResourceLocation recipeId) {
            super.ensureValid(recipeId);
            if (this.ingredients.isEmpty()) {
                throw new IllegalStateException("Recipe must have at least 1 ingredient");
            }
        }

        @Override
        protected ShapelessCraftingRecipeBuilder self() {
            return this;
        }

        @Override
        protected FinishedRecipe createRecipe(ResourceLocation recipeId) {
            ShapelessRecipeBuilder.Result recipe = new ShapelessRecipeBuilder.Result(recipeId, this.result, this.count, this.group == null ? "" : this.group, this.craftingBookCategory, this.ingredients, this.advancement, recipeId.m_246208_("recipes/" + this.folderName + "/"));
            return this.damageInputs ? new DamageInputShapeless((FinishedRecipe)recipe) : recipe;
        }

        public static final class DamageInputShapeless
        implements FinishedRecipe {
            private final FinishedRecipe finishedRecipe;

            public DamageInputShapeless(FinishedRecipe finishedRecipe) {
                this.finishedRecipe = finishedRecipe;
            }

            public void m_7917_(JsonObject jsonObject) {
                JsonObject recipe = new JsonObject();
                recipe.addProperty("type", ForgeRegistries.RECIPE_SERIALIZERS.getKey((Object)this.finishedRecipe.m_6637_()).toString());
                this.finishedRecipe.m_7917_(recipe);
                jsonObject.add("recipe", (JsonElement)recipe);
            }

            public ResourceLocation m_6445_() {
                return this.finishedRecipe.m_6445_();
            }

            public RecipeSerializer<?> m_6637_() {
                return (RecipeSerializer)TFCRecipeSerializers.DAMAGE_INPUTS_SHAPELESS_CRAFTING.get();
            }

            @Nullable
            public JsonObject m_5860_() {
                return this.finishedRecipe.m_5860_();
            }

            @Nullable
            public ResourceLocation m_6448_() {
                return this.finishedRecipe.m_6448_();
            }
        }
    }

    public static final class ShapedCraftingRecipeBuilder
    extends CraftingRecipeBuilder<ShapedCraftingRecipeBuilder> {
        private final List<String> rows = Lists.newArrayList();
        private final Map<Character, Ingredient> key = Maps.newLinkedHashMap();
        private boolean showNotification = true;

        private ShapedCraftingRecipeBuilder(CraftingBookCategory craftingBookCategory, String folderName, ItemLike result, int count) {
            super(craftingBookCategory, folderName, result, count);
        }

        public ShapedCraftingRecipeBuilder define(Character symbol, TagKey<Item> tag) {
            return this.define(symbol, Ingredient.m_204132_(tag));
        }

        public ShapedCraftingRecipeBuilder define(Character symbol, ItemLike item) {
            return this.define(symbol, Ingredient.m_43929_((ItemLike[])new ItemLike[]{item}));
        }

        public ShapedCraftingRecipeBuilder define(Character symbol, Ingredient ingredient) {
            if (this.key.containsKey(symbol)) {
                throw new IllegalArgumentException("Symbol '" + symbol + "' is already defined!");
            }
            if (symbol.charValue() == ' ') {
                throw new IllegalArgumentException("Symbol ' ' (whitespace) is reserved and cannot be defined");
            }
            this.key.put(symbol, ingredient);
            return this.self();
        }

        public ShapedCraftingRecipeBuilder pattern(String pattern) {
            if (!this.rows.isEmpty() && pattern.length() != this.rows.get(0).length()) {
                throw new IllegalArgumentException("Pattern must be the same width on every line!");
            }
            this.rows.add(pattern);
            return this.self();
        }

        public ShapedCraftingRecipeBuilder pattern(String ... pattern) {
            Arrays.stream(pattern).forEach(this::pattern);
            return this.self();
        }

        public ShapedCraftingRecipeBuilder showNotification(boolean showNotification) {
            this.showNotification = showNotification;
            return this.self();
        }

        @Override
        protected void ensureValid(ResourceLocation recipeId) {
            super.ensureValid(recipeId);
            if (this.rows.isEmpty()) {
                throw new IllegalStateException("No pattern is defined for shaped recipe " + String.valueOf(recipeId) + "!");
            }
            HashSet set = Sets.newHashSet(this.key.keySet());
            set.remove(Character.valueOf(' '));
            for (String pattern : this.rows) {
                for (int i = 0; i < pattern.length(); ++i) {
                    char symbol = pattern.charAt(i);
                    if (!this.key.containsKey(Character.valueOf(symbol)) && symbol != ' ') {
                        throw new IllegalStateException("Pattern in recipe " + String.valueOf(recipeId) + " uses undefined symbol '" + symbol + "'");
                    }
                    set.remove(Character.valueOf(symbol));
                }
            }
            if (!set.isEmpty()) {
                throw new IllegalStateException("Ingredients are defined but not used in pattern for recipe " + String.valueOf(recipeId));
            }
            if (this.rows.size() == 1 && this.rows.get(0).length() == 1) {
                throw new IllegalStateException("Shaped recipe " + String.valueOf(recipeId) + " only takes in a single item - should it be a shapeless recipe instead?");
            }
        }

        @Override
        protected ShapedCraftingRecipeBuilder self() {
            return this;
        }

        @Override
        protected FinishedRecipe createRecipe(ResourceLocation recipeId) {
            ShapedRecipeBuilder.Result recipe = new ShapedRecipeBuilder.Result(recipeId, this.result, this.count, this.group == null ? "" : this.group, this.craftingBookCategory, this.rows, this.key, this.advancement, recipeId.m_246208_("recipes/" + this.folderName + "/"), this.showNotification);
            return this.damageInputs ? new DamageInputShaped((FinishedRecipe)recipe) : recipe;
        }

        public static final class DamageInputShaped
        implements FinishedRecipe {
            private final FinishedRecipe finishedRecipe;

            public DamageInputShaped(FinishedRecipe finishedRecipe) {
                this.finishedRecipe = finishedRecipe;
            }

            public void m_7917_(JsonObject jsonObject) {
                JsonObject recipe = new JsonObject();
                recipe.addProperty("type", ForgeRegistries.RECIPE_SERIALIZERS.getKey((Object)this.finishedRecipe.m_6637_()).toString());
                this.finishedRecipe.m_7917_(recipe);
                jsonObject.add("recipe", (JsonElement)recipe);
            }

            public ResourceLocation m_6445_() {
                return this.finishedRecipe.m_6445_();
            }

            public RecipeSerializer<?> m_6637_() {
                return (RecipeSerializer)TFCRecipeSerializers.DAMAGE_INPUT_SHAPED_CRAFTING.get();
            }

            @Nullable
            public JsonObject m_5860_() {
                return this.finishedRecipe.m_5860_();
            }

            @Nullable
            public ResourceLocation m_6448_() {
                return this.finishedRecipe.m_6448_();
            }
        }
    }
}

