/*
 * Decompiled with CFR 0.152.
 */
package com.nebby1999.firmacivplus;

import com.alekiponi.alekiships.common.entity.vehicle.AbstractVehicle;
import com.alekiponi.alekiships.util.BoatMaterial;
import com.alekiponi.firmaciv.common.entity.vehicle.CanoeEntity;
import com.nebby1999.firmacivplus.FirmaCivPlusEntities;
import com.nebby1999.firmacivplus.WatercraftMaterial;
import com.therighthon.afc.common.blocks.AFCWood;
import com.therighthon.afc.common.items.AFCItems;
import java.util.Optional;
import net.dries007.tfc.common.blocks.wood.Wood;
import net.dries007.tfc.util.registry.RegistryWood;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.RegistryObject;

public enum AFCWatercraftMaterial implements WatercraftMaterial
{
    TUALANG(AFCWood.TUALANG, true),
    CYPRESS(AFCWood.CYPRESS, true),
    FIG(AFCWood.FIG, true),
    BAOBAB(AFCWood.BAOBAB, false),
    EUCALYPTUS(AFCWood.EUCALYPTUS, false),
    MAHOGANY(AFCWood.MAHOGANY, false),
    HEVEA(AFCWood.HEVEA, false),
    TEAK(AFCWood.TEAK, false),
    IRONWOOD(AFCWood.IRONWOOD, false),
    IPE(AFCWood.IPE, false);

    public final boolean isSoftwood;
    public final AFCWood wood;

    private AFCWatercraftMaterial(AFCWood wood, boolean isSoftwood) {
        this.wood = wood;
        this.isSoftwood = isSoftwood;
    }

    public Item getRailing() {
        return (Item)((RegistryObject)AFCItems.LUMBER.get(this.wood)).get();
    }

    public Item getStrippedLog() {
        return ((Block)this.wood.getBlock(Wood.BlockType.STRIPPED_LOG).get()).m_5456_();
    }

    public boolean withstandsLava() {
        return false;
    }

    public BlockState getDeckBlock() {
        return ((Block)this.wood.getBlock(Wood.BlockType.PLANKS).get()).m_49966_();
    }

    public Optional<EntityType<? extends AbstractVehicle>> getEntityType(BoatMaterial.BoatType boatType) {
        return switch (boatType) {
            default -> throw new IncompatibleClassChangeError();
            case BoatMaterial.BoatType.ROWBOAT -> Optional.of((EntityType)FirmaCivPlusEntities.getRowboats().get(this).get());
            case BoatMaterial.BoatType.SLOOP -> Optional.of((EntityType)FirmaCivPlusEntities.getSloops().get(this).get());
            case BoatMaterial.BoatType.CONSTRUCTION_SLOOP -> Optional.of((EntityType)FirmaCivPlusEntities.getSloopsUnderConstruction().get(this).get());
        };
    }

    public Optional<EntityType<? extends CanoeEntity>> getCanoeType() {
        return Optional.of((EntityType)FirmaCivPlusEntities.getCanoes().get(this).get());
    }

    public String m_7912_() {
        return this.wood.m_7912_();
    }

    @Override
    public RegistryWood getWood() {
        return this.wood;
    }

    @Override
    public boolean isSoftwood() {
        return this.isSoftwood;
    }
}

