/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.util.rendering.ui.widget;

import com.mojang.realmsclient.gui.screens.RealmsNotificationsScreen;
import de.keksuccino.fancymenu.customization.layout.editor.LayoutEditorScreen;
import de.keksuccino.fancymenu.mixin.mixins.common.client.IMixinRealmsNotificationsScreen;
import de.keksuccino.fancymenu.util.rendering.RenderingUtils;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class RealmsNotificationRenderer {
    private static final ResourceLocation UNSEEN_NOTIFICATION_ICON_LOCATION = new ResourceLocation("minecraft", "textures/gui/unseen_notification.png");
    private static final ResourceLocation NEWS_ICON_LOCATION = new ResourceLocation("realms", "textures/gui/realms/news_notification_mainscreen.png");
    private static final ResourceLocation INVITE_ICON_LOCATION = new ResourceLocation("realms", "textures/gui/realms/invite_icon.png");
    private static final ResourceLocation TRIAL_ICON_LOCATION = new ResourceLocation("realms", "textures/gui/realms/trial_icon.png");
    private final IMixinRealmsNotificationsScreen screenAccess;
    private final Minecraft minecraft;
    private final int screenWidth;
    private final int screenHeight;

    public RealmsNotificationRenderer(@NotNull RealmsNotificationsScreen screen, int screenWidth, int screenHeight) {
        this.screenAccess = (IMixinRealmsNotificationsScreen)screen;
        this.minecraft = Minecraft.m_91087_();
        this.screenWidth = screenWidth;
        this.screenHeight = screenHeight;
    }

    public int getDefaultPositionX() {
        int originalRightPosition = this.screenWidth / 2 + 80;
        return originalRightPosition - this.getTotalWidth();
    }

    public int getDefaultPositionY() {
        int k = this.screenHeight / 4 + 48;
        return k + 48 + 2;
    }

    public int getTotalWidth() {
        int iconCount = 0;
        boolean hasUnseenNotifications = this.hasUnseenNotifications();
        boolean showOldNotifications = this.shouldShowOldNotifications();
        boolean hasUnreadNews = this.hasUnreadNews();
        int pendingInvites = this.getNumberOfPendingInvites();
        boolean trialAvailable = this.isTrialAvailable();
        if (hasUnseenNotifications) {
            ++iconCount;
        }
        if (showOldNotifications) {
            if (hasUnreadNews) {
                ++iconCount;
            }
            if (pendingInvites > 0) {
                ++iconCount;
            }
            if (trialAvailable) {
                ++iconCount;
            }
        }
        return iconCount > 0 ? (iconCount - 1) * 16 + 14 : 0;
    }

    public int getTotalHeight() {
        return 18;
    }

    public void renderIcons(GuiGraphics guiGraphics, int x, int y, int color) {
        boolean hasUnseenNotifications = this.hasUnseenNotifications();
        boolean showOldNotifications = this.shouldShowOldNotifications();
        boolean hasUnreadNews = this.hasUnreadNews();
        int pendingInvites = this.getNumberOfPendingInvites();
        boolean trialAvailable = this.isTrialAvailable();
        int currentX = x;
        RenderingUtils.setShaderColor(guiGraphics, color);
        if (trialAvailable && showOldNotifications) {
            int trialOffset = 0;
            if ((Util.m_137550_() / 800L & 1L) == 1L) {
                trialOffset = 8;
            }
            guiGraphics.m_280163_(TRIAL_ICON_LOCATION, currentX, y + 4, 0.0f, (float)trialOffset, 8, 8, 8, 16);
            currentX += 16;
        }
        if (pendingInvites > 0 && showOldNotifications) {
            guiGraphics.m_280163_(INVITE_ICON_LOCATION, currentX, y + 1, 0.0f, 0.0f, 18, 15, 18, 30);
            currentX += 16;
        }
        if (hasUnreadNews && showOldNotifications) {
            guiGraphics.m_280168_().m_85836_();
            guiGraphics.m_280168_().m_85841_(0.4f, 0.4f, 0.4f);
            guiGraphics.m_280163_(NEWS_ICON_LOCATION, (int)((double)currentX * 2.5), (int)((double)y * 2.5), 0.0f, 0.0f, 40, 40, 40, 40);
            guiGraphics.m_280168_().m_85849_();
            currentX += 16;
        }
        if (hasUnseenNotifications) {
            guiGraphics.m_280163_(UNSEEN_NOTIFICATION_ICON_LOCATION, currentX, y + 3, 0.0f, 0.0f, 10, 10, 10, 10);
        }
        RenderingUtils.resetShaderColor(guiGraphics);
    }

    public void renderIcons(GuiGraphics guiGraphics, int color) {
        boolean isValidClient = this.screenAccess.get_validClient_FancyMenu();
        if (isValidClient) {
            this.renderIcons(guiGraphics, this.getDefaultPositionX(), this.getDefaultPositionY(), color);
        }
    }

    public boolean shouldShowOldNotifications() {
        if (RealmsNotificationRenderer.isEditor()) {
            return true;
        }
        boolean isValidClient = this.screenAccess.get_validClient_FancyMenu();
        boolean inTitleScreen = this.minecraft.f_91080_ instanceof TitleScreen;
        if (!isValidClient || !inTitleScreen) {
            return false;
        }
        return (Boolean)this.minecraft.f_91066_.m_231822_().m_231551_();
    }

    public int getNumberOfPendingInvites() {
        if (RealmsNotificationRenderer.isEditor()) {
            return 1;
        }
        return this.screenAccess.get_numberOfPendingInvites_FancyMenu();
    }

    public boolean hasUnseenNotifications() {
        if (RealmsNotificationRenderer.isEditor()) {
            return true;
        }
        return this.screenAccess.get_hasUnseenNotifications();
    }

    public boolean hasUnreadNews() {
        if (RealmsNotificationRenderer.isEditor()) {
            return true;
        }
        return this.screenAccess.get_hasUnreadNews_FancyMenu();
    }

    public boolean isTrialAvailable() {
        if (RealmsNotificationRenderer.isEditor()) {
            return true;
        }
        return this.screenAccess.get_trialAvailable_FancyMenu();
    }

    protected static boolean isEditor() {
        return Minecraft.m_91087_().f_91080_ instanceof LayoutEditorScreen;
    }
}

