/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.action.actions.audio;

import de.keksuccino.fancymenu.customization.action.Action;
import de.keksuccino.fancymenu.customization.element.elements.audio.AudioElementController;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import de.keksuccino.konkrete.math.MathUtils;
import net.minecraft.network.chat.Component;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SetAudioElementVolumeAction
extends Action {
    private static final Logger LOGGER = LogManager.getLogger();

    public SetAudioElementVolumeAction() {
        super("set_audio_element_volume");
    }

    @Override
    public boolean hasValue() {
        return true;
    }

    @Override
    public void execute(@Nullable String value) {
        try {
            if (value != null && value.contains(":")) {
                String id = value.split(":", 2)[0];
                String volString = value.split(":", 2)[1];
                if (MathUtils.isFloat((String)volString)) {
                    float volume = Math.min(1.0f, Math.max(0.0f, Float.parseFloat(volString)));
                    AudioElementController.AudioElementMeta meta = AudioElementController.getMeta(id);
                    if (meta == null) {
                        meta = new AudioElementController.AudioElementMeta(id, 1.0f);
                        AudioElementController.putMeta(id, meta);
                    }
                    if (meta.volume != volume) {
                        meta.volume = volume;
                        AudioElementController.putMeta(id, meta);
                    }
                }
            }
        }
        catch (Exception ex) {
            LOGGER.error("[FANCYMENU] Failed to execute SetAudioElementVolumeAction!", (Throwable)ex);
        }
    }

    @Override
    @NotNull
    public Component getActionDisplayName() {
        return Component.m_237115_((String)"fancymenu.actions.audio.set_audio_element_volume");
    }

    @Override
    @NotNull
    public Component[] getActionDescription() {
        return LocalizationUtils.splitLocalizedLines("fancymenu.actions.audio.set_audio_element_volume.desc", new String[0]);
    }

    @Override
    public Component getValueDisplayName() {
        return Component.m_237115_((String)"fancymenu.actions.audio.set_audio_element_volume.value.desc");
    }

    @Override
    public String getValueExample() {
        return "element_identifier:1.0";
    }
}

