/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.embeddium.gui;

import com.google.common.collect.Multimap;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.IOException;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import java.util.stream.Stream;
import me.jellysquid.mods.sodium.client.SodiumClientMod;
import me.jellysquid.mods.sodium.client.data.fingerprint.HashedFingerprint;
import me.jellysquid.mods.sodium.client.gui.SodiumGameOptions;
import me.jellysquid.mods.sodium.client.gui.SodiumOptionsGUI;
import me.jellysquid.mods.sodium.client.gui.console.Console;
import me.jellysquid.mods.sodium.client.gui.console.message.MessageLevel;
import me.jellysquid.mods.sodium.client.gui.options.Option;
import me.jellysquid.mods.sodium.client.gui.options.OptionFlag;
import me.jellysquid.mods.sodium.client.gui.options.OptionGroup;
import me.jellysquid.mods.sodium.client.gui.options.OptionPage;
import me.jellysquid.mods.sodium.client.gui.options.storage.OptionStorage;
import me.jellysquid.mods.sodium.client.gui.widgets.FlatButtonWidget;
import me.jellysquid.mods.sodium.client.util.Dim2i;
import net.caffeinemc.mods.sodium.api.util.ColorARGB;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.VideoSettingsScreen;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.SimpleTexture;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import org.embeddedt.embeddium.client.gui.options.OptionIdentifier;
import org.embeddedt.embeddium.gui.frame.AbstractFrame;
import org.embeddedt.embeddium.gui.frame.BasicFrame;
import org.embeddedt.embeddium.gui.frame.components.SearchTextFieldComponent;
import org.embeddedt.embeddium.gui.frame.components.SearchTextFieldModel;
import org.embeddedt.embeddium.gui.frame.tab.Tab;
import org.embeddedt.embeddium.gui.frame.tab.TabFrame;
import org.embeddedt.embeddium.gui.screen.PromptScreen;
import org.embeddedt.embeddium.render.ShaderModBridge;
import org.embeddedt.embeddium.util.PlatformUtil;

public class EmbeddiumVideoOptionsScreen
extends Screen {
    private static final ResourceLocation LOGO_LOCATION = new ResourceLocation("embeddium", "textures/embeddium/gui/logo_transparent.png");
    private static final int LOGO_SIZE = 256;
    private static final AtomicReference<Component> tabFrameSelectedTab = new AtomicReference<Object>(null);
    private final AtomicReference<Integer> tabFrameScrollBarOffset = new AtomicReference<Integer>(0);
    private final AtomicReference<Integer> optionPageScrollBarOffset = new AtomicReference<Integer>(0);
    private final Screen prevScreen;
    private final List<OptionPage> pages = new ArrayList<OptionPage>();
    private AbstractFrame frame;
    private FlatButtonWidget applyButton;
    private FlatButtonWidget closeButton;
    private FlatButtonWidget undoButton;
    private FlatButtonWidget donateButton;
    private FlatButtonWidget hideDonateButton;
    private Dim2i logoDim;
    private boolean hasPendingChanges;
    private SearchTextFieldComponent searchTextField;
    private final SearchTextFieldModel searchTextModel;
    private boolean firstInit = true;
    private static final float ASPECT_RATIO = 1.25f;
    private static final int MINIMUM_WIDTH = 550;

    public EmbeddiumVideoOptionsScreen(Screen prev, List<OptionPage> pages) {
        super((Component)Component.m_237113_((String)"Embeddium Options"));
        this.prevScreen = prev;
        this.pages.addAll(pages);
        this.searchTextModel = new SearchTextFieldModel(this.pages, this);
        this.registerTextures();
    }

    private void checkPromptTimers() {
        Instant threshold;
        if (PlatformUtil.isDevelopmentEnvironment()) {
            return;
        }
        SodiumGameOptions options = SodiumClientMod.options();
        if (options.notifications.forceDisableDonationPrompts || options.notifications.hasSeenDonationPrompt) {
            return;
        }
        HashedFingerprint fingerprint = null;
        try {
            fingerprint = HashedFingerprint.loadFromDisk();
        }
        catch (Throwable t) {
            SodiumClientMod.logger().error("Failed to read the fingerprint from disk", t);
        }
        if (fingerprint == null) {
            return;
        }
        Instant now = Instant.now();
        if (now.isAfter(threshold = Instant.ofEpochSecond(fingerprint.timestamp()).plus(3L, ChronoUnit.DAYS))) {
            this.openDonationPrompt();
            options.notifications.hasSeenDonationPrompt = true;
            try {
                SodiumGameOptions.writeToDisk(options);
            }
            catch (IOException e) {
                SodiumClientMod.logger().error("Failed to update config file", (Throwable)e);
            }
        }
    }

    private void openDonationPrompt() {
        PromptScreen prompt = new PromptScreen(this, SodiumOptionsGUI.DONATION_PROMPT_MESSAGE, 320, 190, new PromptScreen.Action((Component)Component.m_237113_((String)"Support Sodium"), this::openDonationPage));
        this.f_96541_.m_91152_((Screen)prompt);
    }

    private void registerTextures() {
        Minecraft.m_91087_().f_90987_.m_118495_(LOGO_LOCATION, (AbstractTexture)new SimpleTexture(LOGO_LOCATION));
    }

    public void rebuildUI() {
        boolean wasSearchFocused = this.searchTextField.m_93696_();
        this.m_232761_();
        if (wasSearchFocused) {
            this.m_7522_(this.searchTextField);
        }
    }

    protected void m_7856_() {
        this.frame = this.parentFrameBuilder().build();
        this.m_142416_(this.frame);
        this.m_7522_(this.frame);
        if (this.firstInit) {
            this.m_7522_(this.searchTextField);
            this.firstInit = false;
            this.checkPromptTimers();
        }
    }

    protected BasicFrame.Builder parentFrameBuilder() {
        int newWidth = this.f_96543_;
        if (newWidth > 550 && (float)this.f_96543_ / (float)this.f_96544_ > 1.25f) {
            newWidth = Math.max(550, (int)((float)this.f_96544_ * 1.25f));
        }
        Dim2i basicFrameDim = new Dim2i((this.f_96543_ - newWidth) / 2, 0, newWidth, this.f_96544_);
        Dim2i tabFrameDim = new Dim2i(basicFrameDim.x() + basicFrameDim.width() / 20 / 2, basicFrameDim.y() + basicFrameDim.height() / 4 / 2, basicFrameDim.width() - basicFrameDim.width() / 20, basicFrameDim.height() / 4 * 3);
        Dim2i undoButtonDim = new Dim2i(tabFrameDim.getLimitX() - 203, tabFrameDim.getLimitY() + 5, 65, 20);
        Dim2i applyButtonDim = new Dim2i(tabFrameDim.getLimitX() - 134, tabFrameDim.getLimitY() + 5, 65, 20);
        Dim2i closeButtonDim = new Dim2i(tabFrameDim.getLimitX() - 65, tabFrameDim.getLimitY() + 5, 65, 20);
        MutableComponent donationText = Component.m_237115_((String)"sodium.options.buttons.donate");
        int donationTextWidth = this.f_96541_.f_91062_.m_92852_((FormattedText)donationText);
        Dim2i donateButtonDim = new Dim2i(tabFrameDim.getLimitX() - 32 - donationTextWidth, tabFrameDim.y() - 26, 10 + donationTextWidth, 20);
        Dim2i hideDonateButtonDim = new Dim2i(tabFrameDim.getLimitX() - 20, tabFrameDim.y() - 26, 20, 20);
        int logoSizeOnScreen = 20;
        this.logoDim = new Dim2i(tabFrameDim.x(), tabFrameDim.getLimitY() + 25 - logoSizeOnScreen, logoSizeOnScreen, logoSizeOnScreen);
        this.undoButton = new FlatButtonWidget(undoButtonDim, (Component)Component.m_237115_((String)"sodium.options.buttons.undo"), this::undoChanges);
        this.applyButton = new FlatButtonWidget(applyButtonDim, (Component)Component.m_237115_((String)"sodium.options.buttons.apply"), this::applyChanges);
        this.closeButton = new FlatButtonWidget(closeButtonDim, (Component)Component.m_237115_((String)"gui.done"), this::m_7379_);
        this.donateButton = new FlatButtonWidget(donateButtonDim, (Component)donationText, this::openDonationPage);
        this.hideDonateButton = new FlatButtonWidget(hideDonateButtonDim, (Component)Component.m_237113_((String)"x"), this::hideDonationButton);
        if (SodiumClientMod.options().notifications.hasClearedDonationButton) {
            this.setDonationButtonVisibility(false);
        }
        Dim2i searchTextFieldDim = SodiumClientMod.options().notifications.hasClearedDonationButton ? new Dim2i(tabFrameDim.x(), tabFrameDim.y() - 26, tabFrameDim.width(), 20) : new Dim2i(tabFrameDim.x(), tabFrameDim.y() - 26, tabFrameDim.width() - (tabFrameDim.getLimitX() - donateButtonDim.x()) - 2, 20);
        BasicFrame.Builder basicFrameBuilder = this.parentBasicFrameBuilder(basicFrameDim, tabFrameDim);
        this.searchTextField = new SearchTextFieldComponent(searchTextFieldDim, this.pages, this.searchTextModel);
        basicFrameBuilder.addChild(dim -> this.searchTextField);
        return basicFrameBuilder;
    }

    private boolean canShowPage(OptionPage page) {
        if (page.getGroups().isEmpty()) {
            return false;
        }
        Predicate<Option<?>> predicate = this.searchTextModel.getOptionPredicate();
        for (OptionGroup group : page.getGroups()) {
            for (Option option : group.getOptions()) {
                if (!predicate.test(option)) continue;
                return true;
            }
        }
        return false;
    }

    private void createShaderPackButton(Multimap<String, Tab<?>> tabs) {
        if (this.searchTextModel.getOptionPredicate().test(null) && ShaderModBridge.isShaderModPresent()) {
            String shaderModId = Stream.of("oculus", "iris").filter(PlatformUtil::modPresent).findFirst().orElse("iris");
            tabs.put((Object)shaderModId, Tab.createBuilder().setTitle((Component)Component.m_237115_((String)"options.iris.shaderPackSelection")).setId(OptionIdentifier.create("iris", "shader_packs")).setOnSelectFunction(() -> {
                Object patt0$temp = ShaderModBridge.openShaderScreen(this);
                if (patt0$temp instanceof Screen) {
                    Screen screen = (Screen)patt0$temp;
                    this.f_96541_.m_91152_(screen);
                }
                return false;
            }).build());
        }
    }

    private AbstractFrame createTabFrame(Dim2i tabFrameDim) {
        return TabFrame.createBuilder().setDimension(tabFrameDim).shouldRenderOutline(false).setTabSectionScrollBarOffset(this.tabFrameScrollBarOffset).setTabSectionSelectedTab(tabFrameSelectedTab).addTabs(tabs -> this.pages.stream().filter(this::canShowPage).forEach(page -> tabs.put((Object)page.getId().getModId(), Tab.createBuilder().from((OptionPage)page, this.searchTextModel.getOptionPredicate(), this.optionPageScrollBarOffset)))).addTabs(this::createShaderPackButton).onSetTab(() -> this.optionPageScrollBarOffset.set(0)).build();
    }

    public BasicFrame.Builder parentBasicFrameBuilder(Dim2i parentBasicFrameDim, Dim2i tabFrameDim) {
        return BasicFrame.createBuilder().setDimension(parentBasicFrameDim).shouldRenderOutline(false).addChild(dim -> this.donateButton).addChild(dim -> this.hideDonateButton).addChild(parentDim -> this.createTabFrame(tabFrameDim)).addChild(dim -> this.undoButton).addChild(dim -> this.applyButton).addChild(dim -> this.closeButton);
    }

    public void m_280273_(GuiGraphics gfx) {
        super.m_280273_(gfx);
        gfx.m_280246_((float)ColorARGB.unpackRed(-3179338) / 255.0f, (float)ColorARGB.unpackGreen(-3179338) / 255.0f, (float)ColorARGB.unpackBlue(-3179338) / 255.0f, 0.8f);
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((int)770, (int)1);
        gfx.m_280411_(LOGO_LOCATION, this.logoDim.x(), this.logoDim.y(), this.logoDim.width(), this.logoDim.height(), 0.0f, 0.0f, 256, 256, 256, 256);
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableBlend();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableDepthTest();
        gfx.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
    }

    public void m_88315_(GuiGraphics drawContext, int mouseX, int mouseY, float delta) {
        this.m_280273_(drawContext);
        this.updateControls();
        this.frame.m_88315_(drawContext, mouseX, mouseY, delta);
    }

    private void updateControls() {
        boolean hasChanges = this.getAllOptions().anyMatch(Option::hasChanged);
        for (OptionPage page : this.pages) {
            for (Option option : page.getOptions()) {
                if (!option.hasChanged()) continue;
                hasChanges = true;
            }
        }
        this.applyButton.setEnabled(hasChanges);
        this.undoButton.setVisible(hasChanges);
        this.closeButton.setEnabled(!hasChanges);
        this.hasPendingChanges = hasChanges;
    }

    private void setDonationButtonVisibility(boolean value) {
        this.donateButton.setVisible(value);
        this.hideDonateButton.setVisible(value);
    }

    private void hideDonationButton() {
        SodiumGameOptions options = SodiumClientMod.options();
        options.notifications.hasClearedDonationButton = true;
        try {
            SodiumGameOptions.writeToDisk(options);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to save configuration", e);
        }
        this.setDonationButtonVisibility(false);
        this.rebuildUI();
    }

    private void openDonationPage() {
        Util.m_137581_().m_137646_("https://caffeinemc.net/donate");
    }

    private Stream<Option<?>> getAllOptions() {
        return this.pages.stream().flatMap(s -> s.getOptions().stream());
    }

    private void applyChanges() {
        HashSet dirtyStorages = new HashSet();
        EnumSet<OptionFlag> flags = EnumSet.noneOf(OptionFlag.class);
        this.getAllOptions().forEach(option -> {
            if (!option.hasChanged()) {
                return;
            }
            option.applyChanges();
            flags.addAll(option.getFlags());
            dirtyStorages.add(option.getStorage());
        });
        Minecraft client = Minecraft.m_91087_();
        if (client.f_91073_ != null) {
            if (flags.contains((Object)OptionFlag.REQUIRES_RENDERER_RELOAD)) {
                client.f_91060_.m_109818_();
            } else if (flags.contains((Object)OptionFlag.REQUIRES_RENDERER_UPDATE)) {
                client.f_91060_.m_109826_();
            }
        }
        if (flags.contains((Object)OptionFlag.REQUIRES_ASSET_RELOAD)) {
            client.m_91312_(((Integer)client.f_91066_.m_232119_().m_231551_()).intValue());
            client.m_91088_();
        }
        if (flags.contains((Object)OptionFlag.REQUIRES_GAME_RESTART)) {
            Console.instance().logMessage(MessageLevel.WARN, (Component)Component.m_237115_((String)"sodium.console.game_restart"), 10.0);
        }
        for (OptionStorage storage : dirtyStorages) {
            storage.save();
        }
    }

    private void undoChanges() {
        this.getAllOptions().forEach(Option::reset);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (!(keyCode != 80 || (modifiers & 1) == 0 || this.searchTextField != null && this.searchTextField.m_93696_())) {
            Minecraft.m_91087_().m_91152_((Screen)new VideoSettingsScreen(this.prevScreen, Minecraft.m_91087_().f_91066_));
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_6913_() {
        return !this.hasPendingChanges;
    }

    public void m_7379_() {
        this.f_96541_.m_91152_(this.prevScreen);
    }
}

