/*
 * Decompiled with CFR 0.152.
 */
package net.bojarsky.ecb;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.bojarsky.ecb.Ecb;
import net.dries007.tfc.common.capabilities.food.TFCFoodData;
import net.dries007.tfc.common.capabilities.player.PlayerDataCapability;
import net.dries007.tfc.network.PacketHandler;
import net.dries007.tfc.network.UpdateClimateModelPacket;
import net.dries007.tfc.util.climate.Climate;
import net.dries007.tfc.util.climate.ClimateModel;
import net.dries007.tfc.util.tracker.WorldTracker;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber(modid="ecb", bus=Mod.EventBusSubscriber.Bus.FORGE)
public final class ForgeEventHandler {
    public static Map<String, CompoundTag> racionmap = new HashMap<String, CompoundTag>();
    private static final ConcurrentHashMap<UUID, Long> PENDING_HUD_FIX_PLAYERS = new ConcurrentHashMap();
    private static final long HUD_FIX_DELAY_TICKS = 40L;

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onLivingDeath(LivingDeathEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            String playerName = player.m_7755_().getString();
            TFCFoodData foodData = (TFCFoodData)player.m_36324_();
            CompoundTag nutritionData = new CompoundTag();
            nutritionData.m_128365_("nutrients", (Tag)foodData.getNutrition().writeToNbt());
            racionmap.put(playerName, nutritionData);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        Player player = event.getEntity();
        String playerName = player.m_7755_().getString();
        if (racionmap.containsKey(playerName)) {
            CompoundTag savedNutritionData = racionmap.get(playerName);
            TFCFoodData currentFoodData = (TFCFoodData)player.m_36324_();
            currentFoodData.getNutrition().readFromNbt(savedNutritionData.m_128469_("nutrients"));
            racionmap.remove(playerName);
        }
    }

    @SubscribeEvent
    public static void onWorldLoad(LevelEvent.Load event) {
        LevelAccessor var2 = event.getLevel();
        if (var2 instanceof ServerLevel) {
            ServerLevel level = (ServerLevel)var2;
            Runnable t = () -> {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException var3) {
                    var3.printStackTrace();
                }
                ((GameRules.BooleanValue)level.m_46469_().m_46170_(GameRules.f_46145_)).m_46246_(false, level.m_7654_());
                Ecb.LOGGER.info("!!! COORDS ARE RETURNED !!!");
            };
            Thread var3 = new Thread(t);
            var3.start();
        }
    }

    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            PENDING_HUD_FIX_PLAYERS.put(player2.m_20148_(), Long.valueOf(player2.f_8924_.m_129921_()));
        }
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            if (PENDING_HUD_FIX_PLAYERS.isEmpty()) {
                return;
            }
            long currentTick = event.getServer().m_129921_();
            PENDING_HUD_FIX_PLAYERS.entrySet().removeIf(entry -> {
                UUID playerUUID = (UUID)entry.getKey();
                long loginTick = (Long)entry.getValue();
                if (currentTick >= loginTick + 40L) {
                    ServerPlayer player = event.getServer().m_6846_().m_11259_(playerUUID);
                    if (player != null) {
                        player.getCapability(PlayerDataCapability.CAPABILITY).ifPresent(playerData -> {
                            TFCFoodData.replaceFoodStats((Player)player);
                            WorldTracker.get((Level)player.m_284548_()).syncTo(player);
                            playerData.sync();
                            ClimateModel model = Climate.model((Level)player.m_9236_());
                            PacketHandler.send((PacketDistributor.PacketTarget)PacketDistributor.PLAYER.with(() -> player), (Object)new UpdateClimateModelPacket(model));
                        });
                    }
                    return true;
                }
                return false;
            });
        }
    }
}

