/*
 * Decompiled with CFR 0.152.
 */
package net.bojarsky.ecb;

import com.mojang.logging.LogUtils;
import net.bojarsky.bojarskyauthclient.client.BojarskyAuthClientApi;
import net.minecraft.client.Minecraft;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.slf4j.Logger;

@Mod(value="ecb")
public class Ecb {
    public static final String MOD_ID = "ecb";
    public static final Logger LOGGER = LogUtils.getLogger();

    public Ecb() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(this::addCreative);
        MinecraftForge.EVENT_BUS.register((Object)this);
        LOGGER.info("ECB Mod Initializing...");
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        LOGGER.info("ECB: Common Setup");
    }

    private void addCreative(BuildCreativeModeTabContentsEvent event) {
    }

    @Mod.EventBusSubscriber(modid="ecb", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            LOGGER.info("ECB: Client Setup Starting... Performing presence check for bojarskyauthclient.");
            event.enqueueWork(() -> {
                try {
                    BojarskyAuthClientApi.ensurePresence();
                    LOGGER.info("ECB: BojarskyAuthClient presence confirmed. Proceeding with client setup.");
                    try {
                        LOGGER.info("MINECRAFT NAME (ECB Client Setup) >> {}", (Object)Minecraft.m_91087_().m_91094_().m_92546_());
                    }
                    catch (Exception e) {
                        LOGGER.warn("Could not get Minecraft user name during ECB client setup", (Throwable)e);
                    }
                    LOGGER.info("ECB: Client-specific logic executed successfully.");
                }
                catch (NoClassDefFoundError | NoSuchMethodError e) {
                    LOGGER.error("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
                    LOGGER.error("!!! CRITICAL ECB ERROR: Required companion mod 'bojarskyauthclient' is MISSING or incompatible! ");
                    LOGGER.error("!!! Mod '{}' cannot function without it. Please install the correct version.    !!!", (Object)Ecb.MOD_ID);
                    LOGGER.error("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!", (Throwable)e);
                    throw new RuntimeException("ECB failed to initialize: Missing or incompatible 'bojarskyauthclient'.", e);
                }
                catch (Throwable t) {
                    LOGGER.error("!!! CRITICAL ECB ERROR: Unexpected error during client setup while checking for bojarskyauthclient. !!!", t);
                    throw new RuntimeException("ECB failed to initialize due to an unexpected error during client setup.", t);
                }
            });
            LOGGER.info("ECB: Client Setup task enqueued.");
        }
    }
}

