/*
 * Decompiled with CFR 0.152.
 */
package com.ankmaniac.decofirmacraft.common.recipes;

import com.ankmaniac.decofirmacraft.common.items.DFCItems;
import com.ankmaniac.decofirmacraft.common.recipes.DFCRecipeSerializers;
import com.ankmaniac.decofirmacraft.common.recipes.DFCRecipeTypes;
import com.ankmaniac.decofirmacraft.util.DFCHelpers;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.mojang.datafixers.util.Either;
import net.dries007.tfc.common.recipes.RecipeSerializerImpl;
import net.dries007.tfc.common.recipes.SimpleBlockRecipe;
import net.dries007.tfc.common.recipes.ingredients.BlockIngredient;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.JsonHelpers;
import net.dries007.tfc.util.collections.IndirectHashCollection;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import org.jetbrains.annotations.Nullable;

public class PaintingRecipe
extends SimpleBlockRecipe {
    public static final IndirectHashCollection<Block, PaintingRecipe> CACHE = IndirectHashCollection.createForRecipe(recipe -> recipe.getBlockIngredient().blocks(), DFCRecipeTypes.PAINTING);
    @Nullable
    private final Ingredient itemIngredient;
    @Nullable
    private final FluidStack fluidIngredient;
    private final int fluidAmount;
    private final boolean copyInputState;

    public static Either<BlockState, InteractionResult> computeResult(Player player, BlockState state, BlockHitResult hit, boolean informWhy) {
        ItemStack held = player.m_21205_();
        if (Helpers.isItem((ItemStack)held, (Item)((Item)DFCItems.PAINTBRUSH.get())) && DFCHelpers.isHoldingFluidContainerInOffhand(player)) {
            BlockPos pos = hit.m_82425_();
            FluidStack fluidInHand = DFCHelpers.getFluidFromItem(player.m_21206_());
            PaintingRecipe recipe = PaintingRecipe.getRecipe(state, held, fluidInHand);
            if (recipe == null) {
                if (informWhy) {
                    PaintingRecipe.complain(player, "no_recipe");
                }
                return Either.right((Object)InteractionResult.PASS);
            }
            @Nullable BlockState painted = recipe.copyInputState ? recipe.copyBlockState(state) : recipe.getBlockCraftingResult(state);
            if (painted == null) {
                if (informWhy) {
                    PaintingRecipe.complain(player, "cannot_place");
                }
                return Either.right((Object)InteractionResult.FAIL);
            }
            if (PaintingRecipe.consumeFluidIfPresent(player, recipe.getFluidAmount(), recipe.getFluidIngredient())) {
                return Either.left((Object)painted);
            }
            if (informWhy) {
                PaintingRecipe.complain(player, "not_enough_fluid");
            }
            return Either.right((Object)InteractionResult.FAIL);
        }
        return Either.right((Object)InteractionResult.PASS);
    }

    @Nullable
    public BlockState copyBlockState(BlockState inputState) {
        BlockState newState = this.outputState;
        for (Property property : inputState.m_61147_()) {
            newState = this.copyProperty(inputState, newState, property);
        }
        return newState;
    }

    private <T extends Comparable<T>> BlockState copyProperty(BlockState inputState, BlockState newState, Property<T> property) {
        Comparable value = inputState.m_61143_(property);
        return (BlockState)newState.m_61124_(property, value);
    }

    private static void complain(Player player, String message) {
        player.m_5661_((Component)Component.m_237115_((String)("dfc.painting." + message)), true);
    }

    public static boolean consumeFluidIfPresent(Player player, int amount, @Nullable FluidStack fluidIngredient) {
        ItemStack offHandStack = player.m_21206_();
        LazyOptional fluidHandlerCap = offHandStack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM);
        if (fluidHandlerCap.isPresent()) {
            IFluidHandlerItem fluidHandler = (IFluidHandlerItem)fluidHandlerCap.orElseThrow(IllegalStateException::new);
            FluidStack fluidInItem = fluidHandler.getFluidInTank(0);
            if (fluidIngredient != null && !fluidIngredient.isEmpty() && fluidInItem.getFluid() == fluidIngredient.getFluid() && fluidInItem.getAmount() >= amount) {
                fluidHandler.drain(amount, IFluidHandler.FluidAction.EXECUTE);
                return true;
            }
        }
        return false;
    }

    @Nullable
    public static PaintingRecipe getRecipe(BlockState state, ItemStack held, @Nullable FluidStack fluidInHand) {
        PaintingRecipe bestMatch = null;
        for (PaintingRecipe recipe : CACHE.getAll((Object)state.m_60734_())) {
            if (!recipe.matches(state, held, fluidInHand) || bestMatch != null && !PaintingRecipe.isMoreSpecificMatch(recipe, bestMatch)) continue;
            bestMatch = recipe;
        }
        return bestMatch;
    }

    public PaintingRecipe(ResourceLocation id, BlockIngredient ingredient, BlockState outputState, boolean copyInputState, @Nullable Ingredient itemIngredient, @Nullable FluidStack fluidIngredient, int fluidAmount) {
        super(id, ingredient, outputState, false);
        this.itemIngredient = itemIngredient;
        this.fluidIngredient = fluidIngredient;
        this.fluidAmount = fluidAmount;
        this.copyInputState = copyInputState;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)DFCRecipeSerializers.PAINTING.get();
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)DFCRecipeTypes.PAINTING.get();
    }

    public boolean matches(BlockState state, ItemStack stack, @Nullable FluidStack fluidInHand) {
        if (!this.matches(state)) {
            return false;
        }
        if (this.itemIngredient != null && !this.itemIngredient.test(stack)) {
            return false;
        }
        if (this.fluidIngredient != null && !this.fluidIngredient.isEmpty()) {
            if (fluidInHand == null || fluidInHand.isEmpty()) {
                return false;
            }
            if (!fluidInHand.isFluidEqual(this.fluidIngredient) || fluidInHand.getAmount() < this.fluidAmount) {
                return false;
            }
        }
        return true;
    }

    private static boolean isMoreSpecificMatch(PaintingRecipe candidate, PaintingRecipe currentBest) {
        int candidateSpecificity = 0;
        int currentSpecificity = 0;
        if (candidate.getItemIngredient() != null) {
            ++candidateSpecificity;
        }
        if (candidate.getFluidIngredient() != null && !candidate.getFluidIngredient().isEmpty()) {
            ++candidateSpecificity;
        }
        if (currentBest.getItemIngredient() != null) {
            ++currentSpecificity;
        }
        if (currentBest.getFluidIngredient() != null && !currentBest.getFluidIngredient().isEmpty()) {
            ++currentSpecificity;
        }
        return candidateSpecificity > currentSpecificity;
    }

    @Nullable
    public Ingredient getItemIngredient() {
        return this.itemIngredient;
    }

    @Nullable
    public FluidStack getFluidIngredient() {
        return this.fluidIngredient;
    }

    public int getFluidAmount() {
        return this.fluidAmount;
    }

    public static class Serializer
    extends RecipeSerializerImpl<PaintingRecipe> {
        public PaintingRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            if (!json.has("ingredient")) {
                throw new JsonSyntaxException("Missing 'ingredient' key in JSON");
            }
            BlockIngredient ingredient = BlockIngredient.fromJson((JsonElement)JsonHelpers.get((JsonObject)json, (String)"ingredient"));
            boolean copyInputState = GsonHelper.m_13855_((JsonObject)json, (String)"copy_input", (boolean)false);
            if (!json.has("result")) {
                throw new JsonSyntaxException("Missing 'result' key in JSON");
            }
            BlockState state = JsonHelpers.getBlockState((String)GsonHelper.m_13906_((JsonObject)json, (String)"result"));
            Ingredient itemIngredient = null;
            if (json.has("item_ingredient")) {
                try {
                    itemIngredient = Ingredient.m_43917_((JsonElement)json.get("item_ingredient"));
                }
                catch (JsonSyntaxException e) {
                    throw new JsonSyntaxException("Invalid 'item_ingredient' in JSON", (Throwable)e);
                }
            }
            FluidStack fluidIngredient = FluidStack.EMPTY;
            if (json.has("fluid_ingredient")) {
                try {
                    fluidIngredient = DFCHelpers.getFluidStack(json.getAsJsonObject("fluid_ingredient"));
                }
                catch (JsonSyntaxException e) {
                    throw new JsonSyntaxException("Invalid 'fluid_ingredient' in JSON", (Throwable)e);
                }
            }
            int fluidAmount = 0;
            if (json.has("fluid_amount") && (fluidAmount = GsonHelper.m_13927_((JsonObject)json, (String)"fluid_amount")) < 0) {
                throw new JsonSyntaxException("'fluid_amount' cannot be negative");
            }
            return new PaintingRecipe(recipeId, ingredient, state, copyInputState, itemIngredient, fluidIngredient, fluidAmount);
        }

        @Nullable
        public PaintingRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            BlockIngredient ingredient = BlockIngredient.fromNetwork((FriendlyByteBuf)buffer);
            boolean copyInputState = buffer.readBoolean();
            BlockState state = ((Block)BuiltInRegistries.f_256975_.m_7942_(buffer.m_130242_())).m_49966_();
            Ingredient itemIngredient = (Ingredient)Helpers.decodeNullable((FriendlyByteBuf)buffer, Ingredient::m_43940_);
            FluidStack fluidIngredient = FluidStack.readFromPacket((FriendlyByteBuf)buffer);
            int fluidAmount = buffer.readInt();
            return new PaintingRecipe(recipeId, ingredient, state, copyInputState, itemIngredient, fluidIngredient, fluidAmount);
        }

        public void toNetwork(FriendlyByteBuf buffer, PaintingRecipe recipe) {
            recipe.ingredient.toNetwork(buffer);
            buffer.writeBoolean(recipe.copyInputState);
            buffer.m_130130_(BuiltInRegistries.f_256975_.m_7447_((Object)recipe.outputState.m_60734_()));
            Helpers.encodeNullable((Object)recipe.itemIngredient, (FriendlyByteBuf)buffer, Ingredient::m_43923_);
            recipe.fluidIngredient.writeToPacket(buffer);
            buffer.writeInt(recipe.fluidAmount);
        }
    }
}

