/*
 * Decompiled with CFR 0.152.
 */
package com.ankmaniac.decofirmacraft.common.items;

import com.ankmaniac.decofirmacraft.common.blocks.DFCFluids;
import com.ankmaniac.decofirmacraft.common.blocks.metal.DFCMetal;
import com.ankmaniac.decofirmacraft.common.blocks.rock.DFCOre;
import com.ankmaniac.decofirmacraft.common.blocks.rock.DFCRock;
import com.ankmaniac.decofirmacraft.common.items.PaintbrushItem;
import java.util.Locale;
import java.util.Map;
import java.util.function.Supplier;
import net.dries007.tfc.common.TFCTiers;
import net.dries007.tfc.common.blocks.rock.Ore;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.Metal;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;

public class DFCItems {
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((ResourceKey)Registries.f_256913_, (String)"dfc");
    public static final Map<DFCRock, RegistryObject<Item>> DFC_BRICKS = Helpers.mapOfKeys(DFCRock.class, type -> DFCItems.register("brick/" + type.name()));
    public static final Map<DFCMetal.DFCDefault, Map<DFCMetal.DFCDefault.DFCItemType, RegistryObject<Item>>> METAL_ITEMS = Helpers.mapOfKeys(DFCMetal.DFCDefault.class, metal -> Helpers.mapOfKeys(DFCMetal.DFCDefault.DFCItemType.class, type -> DFCItems.register("metal/" + type.name() + "/" + metal.name(), () -> type.create((DFCMetal.DFCDefault)((Object)metal)))));
    public static final Map<DFCOre, Map<Ore.Grade, RegistryObject<Item>>> GRADED_ORES = Helpers.mapOfKeys(DFCOre.class, DFCOre::isGraded, ore -> Helpers.mapOfKeys(Ore.Grade.class, grade -> DFCItems.register("ore/" + grade.name() + "_" + ore.name())));
    public static final Map<DFCOre, RegistryObject<Item>> ORES = Helpers.mapOfKeys(DFCOre.class, ore -> !ore.isGraded(), ore -> DFCItems.register("ore/" + ore.name()));
    public static final RegistryObject<Item> UNFIRED_TILE = DFCItems.register("ceramic/unfired_tile");
    public static final RegistryObject<Item> TILE = DFCItems.register("ceramic/tile");
    public static final RegistryObject<Item> UNFIRED_SHINGLE = DFCItems.register("ceramic/unfired_shingle");
    public static final RegistryObject<Item> SHINGLE = DFCItems.register("ceramic/shingle");
    public static final RegistryObject<Item> PAINTBRUSH = DFCItems.register("paintbrush", () -> new PaintbrushItem(TFCTiers.BRONZE, new Item.Properties()));
    public static final RegistryObject<Item> GYPSUM_POWDER = DFCItems.register("powder/gypsum");
    public static final Map<DFCMetal.DFCDefault, RegistryObject<BucketItem>> DFC_METAL_FLUID_BUCKETS = Helpers.mapOfKeys(DFCMetal.DFCDefault.class, metal -> DFCItems.register("bucket/metal/" + metal.name(), () -> new BucketItem((Supplier)DFCFluids.METALS.get(metal).source(), new Item.Properties().m_41495_(Items.f_42446_).m_41487_(1))));
    public static final RegistryObject<Item> LEADED_HEMATITIC_GLASS_BATCH = DFCItems.register("leaded_hematitic_glass_batch");
    public static final RegistryObject<Item> LEADED_OLIVINE_GLASS_BATCH = DFCItems.register("leaded_olivine_glass_batch");
    public static final RegistryObject<Item> LEADED_SILICA_GLASS_BATCH = DFCItems.register("leaded_silica_glass_batch");
    public static final RegistryObject<Item> LEADED_VOLCANIC_GLASS_BATCH = DFCItems.register("leaded_volcanic_glass_batch");
    public static final RegistryObject<Item> GLASS_BRICK = DFCItems.register("glass/brick/plain");
    public static final RegistryObject<Item> FOGGY_BRICK = DFCItems.register("glass/brick/foggy");
    public static final Map<DyeColor, RegistryObject<Item>> STAINED_GLASS_BRICK = Helpers.mapOfKeys(DyeColor.class, color -> DFCItems.register("glass/brick/" + color.m_41065_()));
    public static final Map<Metal.Default, RegistryObject<Item>> METAL_POWDERS = Helpers.mapOfKeys(Metal.Default.class, Metal.Default::hasParts, metal -> DFCItems.register("metal/powder/" + metal.name()));
    public static final Map<DFCMetal.DFCDefault, RegistryObject<Item>> DFC_METAL_POWDERS = Helpers.mapOfKeys(DFCMetal.DFCDefault.class, metal -> DFCItems.register("metal/powder/" + metal.name()));
    public static final RegistryObject<Item> CINDER_BLOCK_MOLD = DFCItems.register("wood/mold/brick");
    public static final RegistryObject<Item> SLAB_MOLD = DFCItems.register("wood/mold/slab");
    public static final RegistryObject<Item> FILLED_CINDER_BLOCK_MOLD = DFCItems.register("wood/mold/brick_filled");
    public static final RegistryObject<Item> FILLED_SLAB_MOLD = DFCItems.register("wood/mold/slab_filled");
    public static final RegistryObject<Item> CINDER_BLOCK = DFCItems.register("concrete/brick");
    public static final RegistryObject<Item> CONCRETE_SLAB = DFCItems.register("concrete/slab");
    public static final RegistryObject<BucketItem> PLASTER_FLUID_BUCKET = DFCItems.register("bucket/plaster", () -> new BucketItem((Supplier)DFCFluids.PLASTER.source(), new Item.Properties().m_41495_(Items.f_42446_).m_41487_(1)));
    public static final RegistryObject<BucketItem> CONCRETE_FLUID_BUCKET = DFCItems.register("bucket/concrete", () -> new BucketItem((Supplier)DFCFluids.CONCRETE.source(), new Item.Properties().m_41495_(Items.f_42446_).m_41487_(1)));

    private static RegistryObject<Item> register(String name) {
        return DFCItems.register(name, () -> new Item(new Item.Properties()));
    }

    private static <T extends Item> RegistryObject<T> register(String name, Supplier<T> item) {
        return ITEMS.register(name.toLowerCase(Locale.ROOT), item);
    }
}

