/*
 * Decompiled with CFR 0.152.
 */
package com.ankmaniac.decofirmacraft.common.blocks.rock;

import com.ankmaniac.decofirmacraft.common.blocks.DFCBlocks;
import java.util.Locale;
import java.util.function.Supplier;
import net.dries007.tfc.common.blocks.rock.Rock;
import net.dries007.tfc.common.blocks.rock.RockDisplayCategory;
import net.dries007.tfc.common.blocks.soil.SandBlockType;
import net.dries007.tfc.util.registry.RegistryRock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.material.MapColor;

public enum DFCRock implements RegistryRock
{
    TRAVERTINE(RockDisplayCategory.SEDIMENTARY, MapColor.f_283947_, SandBlockType.WHITE),
    SERPENTINE(RockDisplayCategory.METAMORPHIC, MapColor.f_283784_, SandBlockType.GREEN),
    ARKOSE(RockDisplayCategory.SEDIMENTARY, MapColor.f_283895_, SandBlockType.RED),
    BLUESCHIST(RockDisplayCategory.METAMORPHIC, MapColor.f_283743_, SandBlockType.GREEN),
    TUFF(RockDisplayCategory.INTERMEDIATE_IGNEOUS_EXTRUSIVE, MapColor.f_283919_, SandBlockType.BROWN);

    public static final DFCRock[] VALUES;
    private final String serializedName = this.name().toLowerCase(Locale.ROOT);
    private final RockDisplayCategory category;
    private final MapColor color;
    private final SandBlockType sandType;

    private DFCRock(RockDisplayCategory category, MapColor color, SandBlockType sandType) {
        this.category = category;
        this.color = color;
        this.sandType = sandType;
    }

    public SandBlockType getSandType() {
        return this.sandType;
    }

    public RockDisplayCategory displayCategory() {
        return this.category;
    }

    public MapColor color() {
        return this.color;
    }

    public Supplier<? extends Block> getBlock(Rock.BlockType type) {
        return (Supplier)DFCBlocks.CUSTOM_ROCK_TYPES.get((Object)this).get(type);
    }

    public Supplier<? extends Block> getAnvil() {
        return (Supplier)DFCBlocks.DFC_ROCK_ANVILS.get((Object)this);
    }

    public Supplier<? extends SlabBlock> getSlab(Rock.BlockType type) {
        return DFCBlocks.CUSTOM_DFC_ROCK_DECORATIONS.get((Object)this).get(type).slab();
    }

    public Supplier<? extends StairBlock> getStair(Rock.BlockType type) {
        return DFCBlocks.CUSTOM_DFC_ROCK_DECORATIONS.get((Object)this).get(type).stair();
    }

    public Supplier<? extends WallBlock> getWall(Rock.BlockType type) {
        return DFCBlocks.CUSTOM_DFC_ROCK_DECORATIONS.get((Object)this).get(type).wall();
    }

    public String m_7912_() {
        return this.serializedName;
    }

    static {
        VALUES = DFCRock.values();
    }
}

