/*
 * Decompiled with CFR 0.152.
 */
package com.ankmaniac.decofirmacraft.common.blocks.metal;

import com.ankmaniac.decofirmacraft.common.blocks.DFCBlocks;
import com.ankmaniac.decofirmacraft.util.DFCHelpers;
import java.util.Locale;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import net.dries007.tfc.common.TFCArmorMaterials;
import net.dries007.tfc.common.TFCTiers;
import net.dries007.tfc.util.Metal;
import net.dries007.tfc.util.registry.RegistryMetal;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.Tier;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.material.MapColor;
import net.minecraftforge.common.util.NonNullFunction;

public final class DFCMetal {

    public static enum DFCBlockType {
        SMOOTH(metal -> new Block(BlockBehaviour.Properties.m_284310_().m_284180_(metal.mapColor()).m_280658_(NoteBlockInstrument.IRON_XYLOPHONE).m_60999_().m_60913_(5.0f, 6.0f).m_60918_(SoundType.f_56743_))),
        SMOOTH_SLAB(metal -> new SlabBlock(BlockBehaviour.Properties.m_284310_().m_284180_(metal.mapColor()).m_280658_(NoteBlockInstrument.IRON_XYLOPHONE).m_60999_().m_60913_(5.0f, 6.0f).m_60918_(SoundType.f_56743_))),
        SMOOTH_STAIRS(metal -> new StairBlock(() -> ((Block)metal.getFullBlock().get()).m_49966_(), BlockBehaviour.Properties.m_284310_().m_284180_(metal.mapColor()).m_280658_(NoteBlockInstrument.IRON_XYLOPHONE).m_60999_().m_60913_(5.0f, 6.0f).m_60918_(SoundType.f_56743_))),
        CUT(metal -> new Block(BlockBehaviour.Properties.m_284310_().m_284180_(metal.mapColor()).m_280658_(NoteBlockInstrument.IRON_XYLOPHONE).m_60999_().m_60913_(5.0f, 6.0f).m_60918_(SoundType.f_56743_))),
        CUT_SLAB(metal -> new SlabBlock(BlockBehaviour.Properties.m_284310_().m_284180_(metal.mapColor()).m_280658_(NoteBlockInstrument.IRON_XYLOPHONE).m_60999_().m_60913_(5.0f, 6.0f).m_60918_(SoundType.f_56743_))),
        CUT_STAIRS(metal -> new StairBlock(() -> ((Block)metal.getFullBlock().get()).m_49966_(), BlockBehaviour.Properties.m_284310_().m_284180_(metal.mapColor()).m_280658_(NoteBlockInstrument.IRON_XYLOPHONE).m_60999_().m_60913_(5.0f, 6.0f).m_60918_(SoundType.f_56743_))),
        BRICKS(metal -> new Block(BlockBehaviour.Properties.m_284310_().m_284180_(metal.mapColor()).m_280658_(NoteBlockInstrument.IRON_XYLOPHONE).m_60999_().m_60913_(5.0f, 6.0f).m_60918_(SoundType.f_56743_))),
        BRICKS_SLAB(metal -> new SlabBlock(BlockBehaviour.Properties.m_284310_().m_284180_(metal.mapColor()).m_280658_(NoteBlockInstrument.IRON_XYLOPHONE).m_60999_().m_60913_(5.0f, 6.0f).m_60918_(SoundType.f_56743_))),
        BRICKS_STAIRS(metal -> new StairBlock(() -> ((Block)metal.getFullBlock().get()).m_49966_(), BlockBehaviour.Properties.m_284310_().m_284180_(metal.mapColor()).m_280658_(NoteBlockInstrument.IRON_XYLOPHONE).m_60999_().m_60913_(5.0f, 6.0f).m_60918_(SoundType.f_56743_))),
        PILLAR(metal -> new RotatedPillarBlock(BlockBehaviour.Properties.m_284310_().m_284180_(metal.mapColor()).m_280658_(NoteBlockInstrument.IRON_XYLOPHONE).m_60999_().m_60913_(5.0f, 6.0f).m_60918_(SoundType.f_56743_)));

        private final Function<RegistryMetal, Block> blockFactory;
        private final BiFunction<Block, Item.Properties, ? extends BlockItem> blockItemFactory;
        private final String serializedName;

        private DFCBlockType(Function<RegistryMetal, Block> blockFactory, BiFunction<Block, Item.Properties, ? extends BlockItem> blockItemFactory) {
            this.blockFactory = blockFactory;
            this.blockItemFactory = blockItemFactory;
            this.serializedName = this.name().toLowerCase(Locale.ROOT);
        }

        private DFCBlockType(Function<RegistryMetal, Block> blockFactory) {
            this(blockFactory, BlockItem::new);
        }

        public Supplier<Block> create(RegistryMetal metal) {
            return () -> this.blockFactory.apply(metal);
        }

        public Function<Block, BlockItem> createBlockItem(Item.Properties properties) {
            return block -> this.blockItemFactory.apply((Block)block, properties);
        }

        public String createName(RegistryMetal metal) {
            if (this == SMOOTH_SLAB || this == SMOOTH_STAIRS) {
                return SMOOTH.createName(metal) + (this == SMOOTH_SLAB ? "_slab" : "_stairs");
            }
            if (this == CUT_SLAB || this == CUT_STAIRS) {
                return CUT.createName(metal) + (this == CUT_SLAB ? "_slab" : "_stairs");
            }
            if (this == BRICKS_SLAB || this == BRICKS_STAIRS) {
                return BRICKS.createName(metal) + (this == BRICKS_SLAB ? "_slab" : "_stairs");
            }
            return "metal/" + this.serializedName + "/" + metal.m_7912_();
        }
    }

    public static enum DFCDefault implements RegistryMetal
    {
        ALUMINUM(-2500411, MapColor.f_283779_, Rarity.UNCOMMON, true, false, false),
        ALUMINA(-1842212, MapColor.f_283779_, Rarity.COMMON, true, false, false),
        LEAD(-8488804, MapColor.f_283889_, Rarity.COMMON, true, false, false),
        PEWTER(-4473441, MapColor.f_283832_, Rarity.COMMON, true, false, false),
        PLATINUM(-2297099, MapColor.f_283869_, Rarity.COMMON, true, false, false);

        private final String serializedName = this.name().toLowerCase(Locale.ROOT);
        private final boolean parts;
        private final boolean armor;
        private final boolean utility;
        private final MapColor mapColor;
        private final Rarity rarity;
        private final int color;
        private final ResourceLocation sheet;

        private DFCDefault(int color, MapColor mapColor, Rarity rarity, boolean parts, boolean armor, boolean utility) {
            this.rarity = rarity;
            this.color = color;
            this.mapColor = mapColor;
            this.sheet = DFCHelpers.identifier("block/metal/full/" + this.serializedName);
            this.parts = parts;
            this.armor = armor;
            this.utility = utility;
        }

        public ResourceLocation getSheet() {
            return this.sheet;
        }

        public String m_7912_() {
            return this.serializedName;
        }

        public int getColor() {
            return this.color;
        }

        public Rarity getRarity() {
            return this.rarity;
        }

        public Tier toolTier() {
            return TFCTiers.STEEL;
        }

        public ArmorMaterial armorTier() {
            return TFCArmorMaterials.RED_STEEL;
        }

        public Metal.Tier metalTier() {
            return Metal.Tier.TIER_VI;
        }

        public MapColor mapColor() {
            return this.mapColor;
        }

        public Supplier<Block> getFullBlock() {
            return (Supplier)DFCBlocks.DFC_METALS.get((Object)this).get(Metal.BlockType.BLOCK);
        }

        public static enum DFCItemType {
            INGOT((NonNullFunction<DFCDefault, Item>)((NonNullFunction)metal -> new Item(new Item.Properties()))),
            DOUBLE_INGOT((NonNullFunction<DFCDefault, Item>)((NonNullFunction)metal -> new Item(new Item.Properties()))),
            SHEET((NonNullFunction<DFCDefault, Item>)((NonNullFunction)metal -> new Item(new Item.Properties()))),
            DOUBLE_SHEET((NonNullFunction<DFCDefault, Item>)((NonNullFunction)metal -> new Item(new Item.Properties()))),
            ROD((NonNullFunction<DFCDefault, Item>)((NonNullFunction)metal -> new Item(new Item.Properties())));

            private final NonNullFunction<DFCDefault, Item> itemFactory;

            private DFCItemType(NonNullFunction<DFCDefault, Item> itemFactory) {
                this.itemFactory = itemFactory;
            }

            public Item create(DFCDefault metal) {
                return (Item)this.itemFactory.apply((Object)metal);
            }
        }
    }
}

