/*
 * Decompiled with CFR 0.152.
 */
package com.eerussianguy.decay_2012;

import com.eerussianguy.decay_2012.DecayConfig;
import com.eerussianguy.decay_2012.client.ClientForgeEvents;
import java.util.function.Consumer;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.capabilities.food.FoodCapability;
import net.dries007.tfc.common.capabilities.food.FoodHandler;
import net.dries007.tfc.common.capabilities.food.IFood;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.calendar.Calendars;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ItemStackedOnOtherEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.loading.FMLEnvironment;

@Mod(value="decay_2012")
public class Decay2012 {
    public static final String MOD_ID = "decay_2012";

    public Decay2012() {
        DecayConfig.init();
        if (FMLEnvironment.dist == Dist.CLIENT) {
            ClientForgeEvents.init();
        }
        IEventBus bus = MinecraftForge.EVENT_BUS;
        bus.addListener(Decay2012::onItemStacked);
    }

    public static ResourceLocation identifier(String path) {
        return new ResourceLocation(MOD_ID, path);
    }

    public static boolean isFood(ItemStack stack) {
        return stack.getCapability(FoodCapability.CAPABILITY).map(food -> !food.isTransientNonDecaying() || food instanceof FoodHandler.Dynamic).orElse(false);
    }

    public static void ifFood(ItemStack stack, Consumer<IFood> consumer) {
        stack.getCapability(FoodCapability.CAPABILITY).filter(food -> !food.isTransientNonDecaying() || food instanceof FoodHandler.Dynamic).ifPresent(consumer);
    }

    public static int getWeightBarWidth(ItemStack stack) {
        return Math.round(13.0f * (float)stack.m_41613_() / (float)stack.m_41741_());
    }

    public static float getPercentDecayed(IFood food, boolean isClient) {
        long creation = food.getCreationDate();
        if (creation == -1L) {
            return 0.0f;
        }
        if (food.isRotten()) {
            return 1.0f;
        }
        float actual = (float)(Calendars.get((boolean)isClient).getTicks() - creation) / (float)(food.getRottenDate() - creation);
        return Mth.m_14036_((float)(actual * actual), (float)0.0f, (float)1.0f);
    }

    public static int getDecayBarColor(IFood food) {
        return Decay2012.getPercentDecayed(food, true) < 0.1f ? 65280 : 0xFF0000;
    }

    public static int getDecayBarWidth(IFood food) {
        float pct = Decay2012.getPercentDecayed(food, true);
        if (pct < 0.1f) {
            return Math.round(13.0f * (0.1f - pct) * 10.0f);
        }
        return Math.round(13.0f * (1.0f - pct / 0.9f));
    }

    public static boolean isModifiable(IFood food) {
        return food.getCreationDate() != -1L && food.getRottenDate() != Long.MIN_VALUE && food.getRottenDate() != Long.MAX_VALUE && !food.isTransientNonDecaying();
    }

    public static void onItemStacked(ItemStackedOnOtherEvent event) {
        ItemStack other = event.getStackedOnItem();
        ItemStack stack = event.getCarriedItem();
        ClickAction action = event.getClickAction();
        Slot slot = event.getSlot();
        Player player = event.getPlayer();
        Decay2012.ifFood(stack, food -> {
            int newCount;
            if (action == ClickAction.SECONDARY && slot.m_150651_(player) && Helpers.isItem((ItemStack)other, (TagKey)TFCTags.Items.KNIVES) && ((Boolean)DecayConfig.SERVER.enableCuttingDecay.get()).booleanValue() && (newCount = Decay2012.getCountAfterCutting(stack, food, player.m_9236_().f_46443_)) != -1) {
                food.setCreationDate(FoodCapability.getRoundedCreationDate());
                Helpers.playSound((Level)player.m_9236_(), (BlockPos)player.m_20183_(), (SoundEvent)SoundEvents.f_12344_);
                other.m_41622_(1, (LivingEntity)player, p -> {});
                stack.m_41764_(newCount);
                event.setCanceled(true);
            }
        });
    }

    public static int getCountAfterCutting(ItemStack stack, IFood food, boolean isClient) {
        int newCount;
        float pct = Decay2012.getPercentDecayed(food, isClient);
        int count = stack.m_41613_();
        if (count > 1 && Decay2012.isModifiable(food) && pct > 0.1f && pct < 0.9f && (newCount = Mth.m_14167_((float)((1.0f - pct) * (float)count))) < count) {
            return newCount;
        }
        return -1;
    }
}

