/*
 * Decompiled with CFR 0.152.
 */
package com.awesomehippo.custompingdisplay;

import com.awesomehippo.custompingdisplay.PingDisplayConfig;
import java.awt.Color;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod(value="custompingdisplay")
@Mod.EventBusSubscriber(modid="custompingdisplay", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class CustomPingDisplay {
    public static final String MODID = "custompingdisplay";
    public static final KeyMapping OPEN_GUI_KEY = new KeyMapping("key.custom_ping_display.toggle", 77, "key.categories.misc");
    public static int posX = 10;
    public static int posY = 10;
    public static boolean isGuiOpen = false;

    public CustomPingDisplay() {
        IEventBus modEventBus = MinecraftForge.EVENT_BUS;
        modEventBus.register((Object)this);
        PingDisplayConfig.loadPosition();
    }

    @SubscribeEvent
    public static void onRegisterKeyMappings(RegisterKeyMappingsEvent event) {
        event.register(OPEN_GUI_KEY);
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            while (OPEN_GUI_KEY.m_90859_()) {
                Minecraft mc = Minecraft.m_91087_();
                if (mc.f_91080_ != null || isGuiOpen) continue;
                mc.m_91152_((Screen)new PingPositionGui());
                isGuiOpen = true;
            }
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onRenderGameOverlay(RenderGuiOverlayEvent.Post event) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ != null && mc.f_91074_.f_108617_ != null) {
            int ping = mc.f_91074_.f_108617_.m_104949_(mc.f_91074_.m_20148_()).m_105330_();
            long time = System.currentTimeMillis() % 3000L;
            float hue = (float)time / 3000.0f;
            Color rgbColor = Color.getHSBColor(hue, 1.0f, 1.0f);
            String pingText = "Ping: " + ping + "ms";
            int textWidth = mc.f_91062_.m_92895_(pingText);
            int textHeight = 8;
            event.getGuiGraphics().m_280509_(posX - 2, posY - 2, posX + textWidth + 2, posY + textHeight + 2, -1879048192);
            event.getGuiGraphics().m_280488_(mc.f_91062_, pingText, posX, posY, rgbColor.getRGB());
        }
    }

    public static class PingPositionGui
    extends Screen {
        protected PingPositionGui() {
            super((Component)Component.m_237115_((String)"gui.ping_position.title"));
        }

        public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
            super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
            MutableComponent titleText = Component.m_237115_((String)"gui.customize_ping_position.title");
            MutableComponent instructionText = Component.m_237115_((String)"gui.customize_ping_position.instruction");
            int screenWidth = this.f_96543_;
            int titleWidth = this.f_96547_.m_92852_((FormattedText)titleText);
            int instructionWidth = this.f_96547_.m_92852_((FormattedText)instructionText);
            int titleX = (screenWidth - titleWidth) / 2;
            int instructionX = (screenWidth - instructionWidth) / 2;
            guiGraphics.m_280430_(this.f_96547_, (Component)titleText, titleX, this.f_96544_ / 4, 0xFFFFFF);
            guiGraphics.m_280430_(this.f_96547_, (Component)instructionText, instructionX, this.f_96544_ / 2 - 10, 0xFFFFFF);
        }

        public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
            if (keyCode == 265) {
                posY -= 5;
            } else if (keyCode == 264) {
                posY += 5;
            } else if (keyCode == 263) {
                posX -= 5;
            } else if (keyCode == 262) {
                posX += 5;
            } else if (keyCode == 256) {
                Minecraft.m_91087_().m_91152_(null);
                isGuiOpen = false;
            }
            PingDisplayConfig.savePosition(posX, posY);
            return super.m_7933_(keyCode, scanCode, modifiers);
        }

        public boolean m_7043_() {
            return false;
        }
    }
}

