/*
 * Decompiled with CFR 0.152.
 */
package com.thomas7520.bubbleschat.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.thomas7520.bubbleschat.BubblesConfig;
import com.thomas7520.bubbleschat.util.Bubble;
import com.thomas7520.bubbleschat.util.Message;
import java.awt.Color;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FastColor;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.client.event.RenderLivingEvent;
import org.joml.Matrix4f;

public class ClientBubblesUtil {
    public static KeyMapping[] keyBindings = new KeyMapping[1];
    public static final HashMap<UUID, Bubble> BUBBLES_SYNC = new HashMap();
    public static boolean serverSupport = false;
    public static boolean bubbleThroughBlocks;

    public static void draw(Message message, ArrayDeque<Message> messages, RenderLivingEvent<?, ?> event, long endTime, boolean isSneaking, boolean drawBubble, boolean drawText, boolean drawLittleBubbles, int bubbleQueue) {
        long timeLeft;
        Color outlineColor = message.getColorOutline().getColor();
        Color insideColor = message.getColorInside().getColor();
        Color textColor = message.getColorText().getColor();
        boolean transparency = !event.getEntity().m_20163_() && (!serverSupport && (Boolean)BubblesConfig.CLIENT.canThroughBlocks.get() != false || serverSupport && bubbleThroughBlocks);
        LivingEntity entityIn = event.getEntity();
        int colorText = textColor.getRGB();
        int colorOutline = outlineColor.getRGB();
        int colorInside = insideColor.getRGB();
        if (entityIn.m_20163_()) {
            colorText = (int)((float)(colorText >> 24 & 0xFF) * 0.3f) << 24 | colorText & 0xFFFFFF;
            colorOutline = (int)((float)(colorOutline >> 24 & 0xFF) * 0.3f) << 24 | colorOutline & 0xFFFFFF;
            colorInside = (int)((float)(colorInside >> 24 & 0xFF) * 0.3f) << 24 | colorInside & 0xFFFFFF;
        }
        if ((timeLeft = endTime - System.currentTimeMillis()) < 0L) {
            throw new IllegalStateException("timeleft cannot be < 0, contact author if you didn't use api");
        }
        if (timeLeft < 3000L) {
            message.getColorOutline().setAlpha((int)timeLeft * (Integer)((List)BubblesConfig.CLIENT.colorOutline.get()).get(3) / 3000);
            message.getColorInside().setAlpha((int)timeLeft * (Integer)((List)BubblesConfig.CLIENT.colorInside.get()).get(3) / 3000);
            message.getColorText().setAlpha((int)timeLeft * (Integer)((List)BubblesConfig.CLIENT.colorText.get()).get(3) / 3000);
        }
        float size = -0.02f - (float)((Integer)BubblesConfig.CLIENT.sizeBubble.get()).intValue() * 0.001f;
        PoseStack stack = event.getPoseStack();
        MultiBufferSource buffers = event.getMultiBufferSource();
        float f = entityIn.m_20206_() + 0.8f + (float)((Integer)BubblesConfig.CLIENT.sizeBubble.get()).intValue() * 0.01f;
        stack.m_85836_();
        stack.m_85837_(0.0, (double)f, 0.0);
        stack.m_252781_(Minecraft.m_91087_().f_91063_.m_109153_().m_253121_());
        stack.m_85841_(size, size, size);
        Font renderer = Minecraft.m_91087_().f_91062_;
        List lines = renderer.m_92865_().m_92432_(message.getMessage(), ((Integer)BubblesConfig.CLIENT.lineWidth.get()).intValue(), Style.f_131099_).stream().map(FormattedText::getString).collect(Collectors.toList());
        int linesHeight = 10 * lines.size();
        int biggestLineWidth = 0;
        for (String line : lines) {
            int lineWidth = renderer.m_92895_(line);
            if (biggestLineWidth >= lineWidth) continue;
            biggestLineWidth = lineWidth;
        }
        float yTranslate = lines.size() - 30;
        int i2 = biggestLineWidth / 2;
        stack.m_252880_((float)i2, -yTranslate, 0.0f);
        float scale = 1.0f;
        stack.m_85841_(scale, scale, scale);
        stack.m_252880_(0.0f, (float)(-linesHeight) / 2.0f - 15.0f, 0.0f);
        if (drawBubble) {
            int distanceBetween = -10;
            int j2 = 0;
            for (Message value : messages) {
                if (j2 == bubbleQueue + 1) break;
                String message2 = value.getMessage();
                List messageLines = renderer.m_92865_().m_92432_(message2, ((Integer)BubblesConfig.CLIENT.lineWidth.get()).intValue(), Style.f_131099_).stream().map(FormattedText::getString).collect(Collectors.toList());
                distanceBetween = j2 != bubbleQueue ? (distanceBetween += messageLines.size() * 10 + 4) : (distanceBetween -= messageLines.size());
                ++j2;
            }
            stack.m_252880_(0.0f, (float)(-distanceBetween), 0.0f);
            ClientBubblesUtil.drawBubble(stack, i2, -linesHeight / 2, colorOutline, colorInside, transparency);
        }
        if (drawLittleBubbles) {
            // empty if block
        }
        if (drawText) {
            stack.m_252880_(0.0f, 0.0f, 0.1f);
            if ((colorText >> 24 & 0xFF) > 3) {
                int lineY = -linesHeight / 2 + 3;
                for (String line : lines) {
                    renderer.m_271703_(line, (float)(-renderer.m_92895_(line)) / 2.0f, (float)lineY, colorText, false, stack.m_85850_().m_252922_(), buffers, transparency ? Font.DisplayMode.SEE_THROUGH : Font.DisplayMode.NORMAL, 0, event.getPackedLight());
                    Objects.requireNonNull(renderer);
                    lineY = lineY + 9 + 1;
                }
            }
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        stack.m_85849_();
    }

    public static void fill(PoseStack poseStack, int p_fill_0_, int p_fill_1_, int p_fill_2_, int p_fill_3_, int p_fill_4_, boolean transparency) {
        if (transparency) {
            ClientBubblesUtil.fill(poseStack, RenderType.m_285811_(), p_fill_0_, p_fill_1_, p_fill_2_, p_fill_3_, 0, p_fill_4_);
        }
        ClientBubblesUtil.fill(poseStack, RenderType.m_285907_(), p_fill_0_, p_fill_1_, p_fill_2_, p_fill_3_, 0, p_fill_4_);
    }

    public static void drawBubble(PoseStack poseStack, int i, int size, int outlineColor, int insideColor, boolean transparency) {
        ClientBubblesUtil.fill(poseStack, -i - 1, size + 1, i + 1, size + 2, outlineColor, transparency);
        ClientBubblesUtil.fill(poseStack, -i - 1, -size + 4, i + 1, -size + 5, outlineColor, transparency);
        ClientBubblesUtil.fill(poseStack, -i - 1, size + 2, -i - 2, size + 3, outlineColor, transparency);
        ClientBubblesUtil.fill(poseStack, -i - 1, -size + 4, -i - 2, -size + 3, outlineColor, transparency);
        ClientBubblesUtil.fill(poseStack, -i - 3, size + 3, -i - 2, -size + 3, outlineColor, transparency);
        ClientBubblesUtil.fill(poseStack, i + 3, size + 3, i + 2, -size + 3, outlineColor, transparency);
        ClientBubblesUtil.fill(poseStack, i + 1, -size + 4, i + 2, -size + 3, outlineColor, transparency);
        ClientBubblesUtil.fill(poseStack, i + 1, size + 2, i + 2, size + 3, outlineColor, transparency);
        ClientBubblesUtil.fill(poseStack, -i - 1, size + 2, i + 1, -size + 4, insideColor, transparency);
        ClientBubblesUtil.fill(poseStack, -i - 2, size + 3, -i - 1, -size + 3, insideColor, transparency);
        ClientBubblesUtil.fill(poseStack, i + 2, size + 3, i + 1, -size + 3, insideColor, transparency);
    }

    public static void drawMediumBubble(PoseStack poseStack, int i, int size, int outlineColor, int insideColor, boolean transparency) {
        ClientBubblesUtil.fill(poseStack, -i + 1, -size + 11, -i - 6, -size + 10, outlineColor, transparency);
        ClientBubblesUtil.fill(poseStack, -i + 2, -size + 12, -i + 1, -size + 11, outlineColor, transparency);
        ClientBubblesUtil.fill(poseStack, -i + 2, -size + 18, -i + 1, -size + 17, outlineColor, transparency);
        ClientBubblesUtil.fill(poseStack, -i - 7, -size + 12, -i - 6, -size + 11, outlineColor, transparency);
        ClientBubblesUtil.fill(poseStack, -i - 7, -size + 18, -i - 6, -size + 17, outlineColor, transparency);
        ClientBubblesUtil.fill(poseStack, -i + 1, -size + 19, -i - 6, -size + 18, outlineColor, transparency);
        ClientBubblesUtil.fill(poseStack, -i + 2, -size + 12, -i + 3, -size + 17, outlineColor, transparency);
        ClientBubblesUtil.fill(poseStack, -i - 7, -size + 12, -i - 8, -size + 17, outlineColor, transparency);
        ClientBubblesUtil.fill(poseStack, -i + 1, -size + 11, -i - 6, -size + 18, insideColor, transparency);
        ClientBubblesUtil.fill(poseStack, -i - 7, -size + 12, -i - 6, -size + 17, insideColor, transparency);
        ClientBubblesUtil.fill(poseStack, -i + 1, -size + 12, -i + 2, -size + 17, insideColor, transparency);
    }

    public static void drawLittleBubble(PoseStack poseStack, int i, int size, int outlineColor, int insideColor, boolean transparency) {
        ClientBubblesUtil.fill(poseStack, -i + 1 - 11, -size + 11 + 17, -i - 6 - 9, -size + 10 + 17, outlineColor, transparency);
        ClientBubblesUtil.fill(poseStack, -i + 2 - 11, -size + 12 + 17, -i - 10, -size + 11 + 17, outlineColor, transparency);
        ClientBubblesUtil.fill(poseStack, -i + 2 - 11, -size + 18 + 16, -i - 10, -size + 17 + 16, outlineColor, transparency);
        ClientBubblesUtil.fill(poseStack, -i - 7 - 8, -size + 12 + 17, -i - 6 - 10, -size + 11 + 17, outlineColor, transparency);
        ClientBubblesUtil.fill(poseStack, -i - 7 - 9, -size + 18 + 16, -i - 5 - 10, -size + 17 + 16, outlineColor, transparency);
        ClientBubblesUtil.fill(poseStack, -i + 1 - 11, -size + 19 + 16, -i - 5 - 10, -size + 18 + 16, outlineColor, transparency);
        ClientBubblesUtil.fill(poseStack, -i + 2 - 11, -size + 12 + 17, -i + 2 - 10, -size + 17 + 16, outlineColor, transparency);
        ClientBubblesUtil.fill(poseStack, -i - 6 - 11, -size + 12 + 17, -i - 6 - 10, -size + 17 + 16, outlineColor, transparency);
        ClientBubblesUtil.fill(poseStack, -i + 1 - 11, -size + 11 + 17, -i - 6 - 9, -size + 18 + 16, insideColor, transparency);
        ClientBubblesUtil.fill(poseStack, -i - 7 - 9, -size + 12 + 17, -i - 6 - 9, -size + 17 + 16, insideColor, transparency);
        ClientBubblesUtil.fill(poseStack, -i + 1 - 11, -size + 12 + 17, -i + 2 - 11, -size + 17 + 16, insideColor, transparency);
    }

    public static void fill(PoseStack pose, RenderType p_286711_, int p_286234_, int p_286444_, int p_286244_, int p_286411_, int p_286671_, int p_286599_) {
        Matrix4f matrix4f = pose.m_85850_().m_252922_();
        if (p_286234_ < p_286244_) {
            int i = p_286234_;
            p_286234_ = p_286244_;
            p_286244_ = i;
        }
        if (p_286444_ < p_286411_) {
            int j = p_286444_;
            p_286444_ = p_286411_;
            p_286411_ = j;
        }
        float f3 = (float)FastColor.ARGB32.m_13655_((int)p_286599_) / 255.0f;
        float f = (float)FastColor.ARGB32.m_13665_((int)p_286599_) / 255.0f;
        float f1 = (float)FastColor.ARGB32.m_13667_((int)p_286599_) / 255.0f;
        float f2 = (float)FastColor.ARGB32.m_13669_((int)p_286599_) / 255.0f;
        VertexConsumer vertexconsumer = Minecraft.m_91087_().m_91269_().m_110104_().m_6299_(p_286711_);
        vertexconsumer.m_252986_(matrix4f, (float)p_286234_, (float)p_286444_, (float)p_286671_).m_85950_(f, f1, f2, f3).m_5752_();
        vertexconsumer.m_252986_(matrix4f, (float)p_286234_, (float)p_286411_, (float)p_286671_).m_85950_(f, f1, f2, f3).m_5752_();
        vertexconsumer.m_252986_(matrix4f, (float)p_286244_, (float)p_286411_, (float)p_286671_).m_85950_(f, f1, f2, f3).m_5752_();
        vertexconsumer.m_252986_(matrix4f, (float)p_286244_, (float)p_286444_, (float)p_286671_).m_85950_(f, f1, f2, f3).m_5752_();
    }
}

