/*
 * Decompiled with CFR 0.152.
 */
package com.thomas7520.bubbleschat;

import com.mojang.brigadier.CommandDispatcher;
import com.thomas7520.bubbleschat.BubblesConfig;
import com.thomas7520.bubbleschat.packet.SCSendModPresent;
import com.thomas7520.bubbleschat.packet.SCSyncBubbleMessage;
import com.thomas7520.bubbleschat.server.BubblesCustomCommand;
import com.thomas7520.bubbleschat.util.ResetUtil;
import java.util.List;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="comicsbubbleschat")
@Mod.EventBusSubscriber(modid="comicsbubbleschat", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ComicsBubblesChat {
    public static final String MODID = "comicsbubbleschat";
    private static final Logger LOGGER = LogManager.getLogger();
    public static final String PROTOCOL_VERSION = "1";
    public static SimpleChannel channel = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("comicsbubbleschat", "comicsbubbleschat"), () -> "1", s -> true, s -> true);
    CommandDispatcher<CommandSourceStack> commandDispatcher;

    public ComicsBubblesChat() {
        MinecraftForge.EVENT_BUS.addListener(this::onRegisterCommand);
        MinecraftForge.EVENT_BUS.addListener(this::onServerStarted);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)BubblesConfig.CLIENT_SPEC);
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)BubblesConfig.SERVER_SPEC);
    }

    @SubscribeEvent
    public static void setup(FMLCommonSetupEvent event) {
        int index = 0;
        channel.registerMessage(index++, SCSendModPresent.class, SCSendModPresent::encode, SCSendModPresent::decode, SCSendModPresent::handle);
        channel.registerMessage(index, SCSyncBubbleMessage.class, SCSyncBubbleMessage::encode, SCSyncBubbleMessage::decode, SCSyncBubbleMessage::handle);
    }

    @SubscribeEvent
    public static void setupClient(FMLClientSetupEvent event) {
        if (((List)BubblesConfig.CLIENT.colorOutline.get()).isEmpty() || ((List)BubblesConfig.CLIENT.colorInside.get()).isEmpty() || ((List)BubblesConfig.CLIENT.colorText.get()).isEmpty()) {
            ResetUtil.resetColors();
        }
    }

    private void onRegisterCommand(RegisterCommandsEvent event) {
        this.commandDispatcher = event.getDispatcher();
    }

    private void onServerStarted(ServerStartedEvent event) {
        LOGGER.info("---------------------");
        if (!((String)BubblesConfig.SERVER.commandName.get()).isEmpty()) {
            BubblesCustomCommand.register(this.commandDispatcher);
            LOGGER.info("Server registered /" + (String)BubblesConfig.SERVER.commandName.get() + " as command for comics bubbles chat");
            if (!((String)BubblesConfig.SERVER.messageSuccess.get()).isEmpty()) {
                LOGGER.info("Command /" + (String)BubblesConfig.SERVER.commandName.get() + " return \"" + BubblesCustomCommand.translateColorCodes((String)BubblesConfig.SERVER.messageSuccess.get()) + "\" when performed");
            }
        }
        LOGGER.info("Server " + ((Boolean)BubblesConfig.SERVER.chatListener.get() != false ? "enable" : "disable") + " chat listener for comics bubbles chat");
        LOGGER.info("Server " + ((Boolean)BubblesConfig.SERVER.canThroughBlocks.get() != false ? "enable" : "disable") + " bubbles through blocks for comics bubbles chat");
        LOGGER.info("Server set range for comics bubbles chat packet on " + BubblesConfig.SERVER.bubbleRange.get());
        LOGGER.info("Your server config file is on your directory of your world !");
        LOGGER.info("---------------------");
    }
}

