/*
 * Decompiled with CFR 0.152.
 */
package com.ebicep.chatplus.translator;

import com.ebicep.chatplus.ChatPlus;
import com.ebicep.chatplus.translator.Language;
import com.ebicep.chatplus.translator.LanguageManager;
import com.ebicep.chatplus.translator.RequestResult;
import com.ebicep.chatplus.translator.Response;
import com.ebicep.chatplus.translator.Timeout;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010$\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 (2\u00020\u0001:\u0001(B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001f\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\b\u0010\u0007\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0004\b\t\u0010\nJ%\u0010\f\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\f\u0010\rJ\u0019\u0010\u000e\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u001f\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u000f\u0010\u0015\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0017\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u0010H\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0018J5\u0010\u001d\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0019\u001a\u00020\u00042\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u001a2\u0006\u0010\u001c\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u001d\u0010\u001eJ#\u0010\u001f\u001a\u00020\u00042\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u001aH\u0002\u00a2\u0006\u0004\b\u001f\u0010 J'\u0010#\u001a\u00020\"2\u0006\u0010!\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b#\u0010$J\u0017\u0010&\u001a\u00020\u00042\u0006\u0010%\u001a\u00020\"H\u0002\u00a2\u0006\u0004\b&\u0010'\u00a8\u0006)"}, d2={"Lcom/ebicep/chatplus/translator/GoogleRequester;", "", "<init>", "()V", "", "message", "Lcom/ebicep/chatplus/translator/Language;", "to", "Lcom/ebicep/chatplus/translator/RequestResult;", "translateAuto", "(Ljava/lang/String;Lcom/ebicep/chatplus/translator/Language;)Lcom/ebicep/chatplus/translator/RequestResult;", "from", "performTranslationRequest", "(Ljava/lang/String;Lcom/ebicep/chatplus/translator/Language;Lcom/ebicep/chatplus/translator/Language;)Lcom/ebicep/chatplus/translator/RequestResult;", "encodeMessage", "(Ljava/lang/String;)Ljava/lang/String;", "Lcom/ebicep/chatplus/translator/Response;", "response", "targetLanguage", "processSuccessfulResponse", "(Lcom/ebicep/chatplus/translator/Response;Lcom/ebicep/chatplus/translator/Language;)Lcom/ebicep/chatplus/translator/RequestResult;", "handleAccessDenied", "()Lcom/ebicep/chatplus/translator/RequestResult;", "handleApiError", "(Lcom/ebicep/chatplus/translator/Response;)Lcom/ebicep/chatplus/translator/RequestResult;", "method", "", "queryParams", "contentType", "sendRequest", "(Ljava/lang/String;Ljava/util/Map;Ljava/lang/String;)Lcom/ebicep/chatplus/translator/Response;", "buildRequestUrl", "(Ljava/util/Map;)Ljava/lang/String;", "requestUrl", "Ljavax/net/ssl/HttpsURLConnection;", "createConnection", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)Ljavax/net/ssl/HttpsURLConnection;", "connection", "readResponseBody", "(Ljavax/net/ssl/HttpsURLConnection;)Ljava/lang/String;", "Companion", "chatplus-common"})
@SourceDebugExtension(value={"SMAP\nGoogleRequester.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GoogleRequester.kt\ncom/ebicep/chatplus/translator/GoogleRequester\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,138:1\n1#2:139\n*E\n"})
public final class GoogleRequester {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String BASE_URL = "https://translate.googleapis.com/translate_a/single";
    private static boolean accessDenied;

    @NotNull
    public final RequestResult translateAuto(@NotNull String message, @Nullable Language to) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Language language = LanguageManager.INSTANCE.getAutoLang();
        Language language2 = to;
        Intrinsics.checkNotNull((Object)language2);
        return this.performTranslationRequest(message, language, language2);
    }

    @NotNull
    public final RequestResult performTranslationRequest(@NotNull String message, @NotNull Language from, @NotNull Language to) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        String string = this.encodeMessage(message);
        if (string == null) {
            return new RequestResult(2, "Failed to encode message", null, null);
        }
        String encodedMessage = string;
        Object object = new Pair[]{TuplesKt.to((Object)"client", (Object)"gtx"), TuplesKt.to((Object)"sl", (Object)from.getGoogleCode()), TuplesKt.to((Object)"tl", (Object)to.getGoogleCode()), TuplesKt.to((Object)"dt", (Object)"t"), TuplesKt.to((Object)"q", (Object)encodedMessage)};
        Map queryParams = MapsKt.mutableMapOf((Pair[])object);
        try {
            Response response = this.sendRequest("GET", queryParams, "application/json");
            if (response == null) {
                return new RequestResult(1, "Connection error", null, null);
            }
            Response response2 = response;
            object = switch (response2.getResponseCode()) {
                case 200 -> this.processSuccessfulResponse(response2, to);
                case 429 -> this.handleAccessDenied();
                default -> this.handleApiError(response2);
            };
        }
        catch (Exception e) {
            e.printStackTrace();
            object = new RequestResult(1, "Connection error", null, null);
        }
        return object;
    }

    private final String encodeMessage(String message) {
        String string;
        try {
            string = URLEncoder.encode(message, StandardCharsets.UTF_8.name());
        }
        catch (Exception e) {
            string = null;
        }
        return string;
    }

    private final RequestResult processSuccessfulResponse(Response response, Language targetLanguage) {
        Gson gson = new GsonBuilder().setLenient().create();
        Intrinsics.checkNotNullExpressionValue((Object)gson, (String)"create(...)");
        Gson gson2 = gson;
        Object object = gson2.fromJson(response.getEntity(), JsonArray.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"fromJson(...)");
        JsonArray json = (JsonArray)object;
        String string = json.get(2).getAsString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAsString(...)");
        Language detectedSource = LanguageManager.INSTANCE.findLanguageFromGoogle(string);
        JsonArray jsonArray = json.get(0).getAsJsonArray();
        Intrinsics.checkNotNullExpressionValue((Object)jsonArray, (String)"getAsJsonArray(...)");
        String translatedText = CollectionsKt.joinToString$default((Iterable)((Iterable)jsonArray), (CharSequence)" ", null, null, (int)0, null, GoogleRequester::processSuccessfulResponse$lambda$0, (int)30, null);
        return new RequestResult(200, translatedText, detectedSource, targetLanguage);
    }

    private final RequestResult handleAccessDenied() {
        accessDenied = true;
        new Timeout().start();
        return new RequestResult(429, "Access to Google Translate denied", null, null);
    }

    private final RequestResult handleApiError(Response response) {
        accessDenied = true;
        ChatPlus.INSTANCE.getLOGGER().error(response.getEntity());
        return new RequestResult(411, "API call error", null, null);
    }

    private final Response sendRequest(String method, Map<String, String> queryParams, String contentType) {
        Response response;
        String requestUrl = this.buildRequestUrl(queryParams);
        try {
            HttpsURLConnection connection = this.createConnection(requestUrl, method, contentType);
            String responseBody = this.readResponseBody(connection);
            response = new Response(connection.getResponseCode(), responseBody);
        }
        catch (Exception e) {
            Response response2;
            Exception exception = e;
            if (exception instanceof MalformedURLException) {
                response2 = null;
            } else if (exception instanceof IOException) {
                response2 = new Response(1, "Failed to connect to server");
            } else {
                ChatPlus.INSTANCE.getLOGGER().error((Object)e);
                response2 = new Response(1, "Unexpected error: " + e.getMessage());
            }
            response = response2;
        }
        return response;
    }

    private final String buildRequestUrl(Map<String, String> queryParams) {
        return CollectionsKt.joinToString$default((Iterable)queryParams.entrySet(), (CharSequence)"&", (CharSequence)"https://translate.googleapis.com/translate_a/single?", null, (int)0, null, GoogleRequester::buildRequestUrl$lambda$1, (int)28, null);
    }

    private final HttpsURLConnection createConnection(String requestUrl, String method, String contentType) {
        HttpsURLConnection httpsURLConnection;
        URLConnection uRLConnection = new URL(requestUrl).openConnection();
        Intrinsics.checkNotNull((Object)uRLConnection, (String)"null cannot be cast to non-null type javax.net.ssl.HttpsURLConnection");
        HttpsURLConnection $this$createConnection_u24lambda_u242 = httpsURLConnection = (HttpsURLConnection)uRLConnection;
        boolean bl = false;
        $this$createConnection_u24lambda_u242.setRequestProperty("Content-Type", contentType);
        $this$createConnection_u24lambda_u242.setDoOutput(true);
        $this$createConnection_u24lambda_u242.setRequestMethod(method);
        $this$createConnection_u24lambda_u242.setConnectTimeout(5000);
        $this$createConnection_u24lambda_u242.connect();
        return httpsURLConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String readResponseBody(HttpsURLConnection connection) {
        InputStream inputStream = connection.getResponseCode() == 200 ? connection.getInputStream() : connection.getErrorStream();
        Intrinsics.checkNotNull((Object)inputStream);
        Closeable closeable = inputStream;
        Charset charset = StandardCharsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
        Object object = charset;
        Object object2 = new InputStreamReader((InputStream)closeable, (Charset)object);
        int n = 8192;
        closeable = object2 instanceof BufferedReader ? (BufferedReader)object2 : new BufferedReader((Reader)object2, n);
        object = null;
        try {
            BufferedReader it = (BufferedReader)closeable;
            boolean bl = false;
            object2 = TextStreamsKt.readText((Reader)it);
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)object);
        }
        return object2;
    }

    private static final CharSequence processSuccessfulResponse$lambda$0(JsonElement it) {
        String string = it.getAsJsonArray().get(0).getAsString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAsString(...)");
        return string;
    }

    private static final CharSequence buildRequestUrl$lambda$1(Map.Entry entry) {
        Intrinsics.checkNotNullParameter((Object)entry, (String)"<destruct>");
        String key = (String)entry.getKey();
        String value = (String)entry.getValue();
        return key + "=" + value;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0005\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0006R\"\u0010\b\u001a\u00020\u00078\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\b\u0010\t\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lcom/ebicep/chatplus/translator/GoogleRequester$Companion;", "", "<init>", "()V", "", "BASE_URL", "Ljava/lang/String;", "", "accessDenied", "Z", "getAccessDenied", "()Z", "setAccessDenied", "(Z)V", "chatplus-common"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean getAccessDenied() {
            return accessDenied;
        }

        public final void setAccessDenied(boolean bl) {
            accessDenied = bl;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

