/*
 * Decompiled with CFR 0.152.
 */
package com.ebicep.chatplus.hud;

import com.ebicep.chatplus.ChatPlus;
import com.ebicep.chatplus.config.Config;
import com.ebicep.chatplus.config.ConfigKt;
import com.ebicep.chatplus.events.Events;
import com.ebicep.chatplus.features.chattabs.ChatTab;
import com.ebicep.chatplus.features.chattabs.ChatTabs;
import com.ebicep.chatplus.features.chatwindows.ChatWindow;
import com.ebicep.chatplus.hud.ChatPlusScreen;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.ChatScreen;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0003J\u0015\u0010\b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u0015\u0010\u000b\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u0007\u00a2\u0006\u0004\b\u000b\u0010\fJ\r\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\r\u0010\u0010\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0010\u0010\u0003R\u001d\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00070\u00118\u0006\u00a2\u0006\f\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0014\u0010\tR\u0011\u0010\u0018\u001a\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u001c\u001a\u00020\u00198F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR(\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00190\u00068\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u001d\u0010\u0013\u001a\u0004\b\u001e\u0010\t\"\u0004\b\u001f\u0010 \u00a8\u0006!"}, d2={"Lcom/ebicep/chatplus/hud/ChatManager;", "", "<init>", "()V", "", "resetGlobalSortedTabs", "", "", "getRecentChat", "()Ljava/util/List;", "pMessage", "addSentMessage", "(Ljava/lang/String;)V", "", "isChatFocused", "()Z", "rescaleAll", "", "sentMessages", "Ljava/util/List;", "getSentMessages", "Lcom/ebicep/chatplus/features/chatwindows/ChatWindow;", "getSelectedWindow", "()Lcom/ebicep/chatplus/features/chatwindows/ChatWindow;", "selectedWindow", "Lcom/ebicep/chatplus/features/chattabs/ChatTab;", "getGlobalSelectedTab", "()Lcom/ebicep/chatplus/features/chattabs/ChatTab;", "globalSelectedTab", "globalSortedTabs", "getGlobalSortedTabs", "setGlobalSortedTabs", "(Ljava/util/List;)V", "chatplus-common"})
@SourceDebugExtension(value={"SMAP\nChatManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChatManager.kt\ncom/ebicep/chatplus/hud/ChatManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,105:1\n1368#2:106\n1454#2,5:107\n1053#2:112\n1863#2,2:113\n*S KotlinDebug\n*F\n+ 1 ChatManager.kt\ncom/ebicep/chatplus/hud/ChatManager\n*L\n44#1:106\n44#1:107,5\n45#1:112\n75#1:113,2\n*E\n"})
public final class ChatManager {
    @NotNull
    public static final ChatManager INSTANCE = new ChatManager();
    @NotNull
    private static final List<String> sentMessages = new ArrayList();
    @NotNull
    private static List<ChatTab> globalSortedTabs = new ArrayList();

    private ChatManager() {
    }

    @NotNull
    public final List<String> getSentMessages() {
        return sentMessages;
    }

    @NotNull
    public final ChatWindow getSelectedWindow() {
        return (ChatWindow)CollectionsKt.last(Config.INSTANCE.getValues().getChatWindows());
    }

    @NotNull
    public final ChatTab getGlobalSelectedTab() {
        if (this.getSelectedWindow().getTabSettings().getTabs().isEmpty()) {
            ChatTab defaultTab = ChatTabs.INSTANCE.createDefaultTab();
            defaultTab.setChatWindow(this.getSelectedWindow());
            this.getSelectedWindow().getTabSettings().getTabs().add(defaultTab);
            this.getSelectedWindow().getTabSettings().setSelectedTabIndex(0);
            ConfigKt.setQueueUpdateConfig(true);
        }
        return this.getSelectedWindow().getTabSettings().getSelectedTab();
    }

    @NotNull
    public final List<ChatTab> getGlobalSortedTabs() {
        return globalSortedTabs;
    }

    public final void setGlobalSortedTabs(@NotNull List<ChatTab> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        globalSortedTabs = list;
    }

    /*
     * WARNING - void declaration
     */
    public final void resetGlobalSortedTabs() {
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = Config.INSTANCE.getValues().getChatWindows();
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            ChatWindow it = (ChatWindow)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it.getTabSettings().getSortedTabs();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Iterable $this$sortedBy$iv = (List)destination$iv$iv;
        boolean $i$f$sortedBy = false;
        globalSortedTabs = CollectionsKt.toList((Iterable)CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                ChatTab it = (ChatTab)a;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(-it.getPriority());
                it = (ChatTab)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(-it.getPriority()));
            }
        }));
        ChatPlus.INSTANCE.getLOGGER().info("Reset global sorted tabs: " + globalSortedTabs);
    }

    @NotNull
    public final List<String> getRecentChat() {
        return sentMessages;
    }

    public final void addSentMessage(@NotNull String pMessage) {
        Intrinsics.checkNotNullParameter((Object)pMessage, (String)"pMessage");
        ChatPlusScreen.INSTANCE.setLastMessageSentTick(Events.INSTANCE.getCurrentTick());
        if (sentMessages.isEmpty() || !Intrinsics.areEqual((Object)sentMessages.get(sentMessages.size() - 1), (Object)pMessage)) {
            sentMessages.add(pMessage);
        }
    }

    public final boolean isChatFocused() {
        return Minecraft.m_91087_().f_91080_ instanceof ChatScreen;
    }

    public final void rescaleAll() {
        Iterable $this$forEach$iv = Config.INSTANCE.getValues().getChatWindows();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ChatWindow window = (ChatWindow)element$iv;
            boolean bl = false;
            Iterable $this$forEach$iv2 = window.getTabSettings().getTabs();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                ChatTab tab = (ChatTab)element$iv2;
                boolean bl2 = false;
                tab.rescaleChat();
            }
        }
    }

    static {
        INSTANCE.resetGlobalSortedTabs();
    }
}

