/*
 * Decompiled with CFR 0.152.
 */
package com.ebicep.chatplus.features.speechtotext;

import com.ebicep.chatplus.ChatPlus;
import com.ebicep.chatplus.features.speechtotext.Microphone;
import com.ebicep.chatplus.features.speechtotext.MicrophoneException;
import com.ebicep.chatplus.features.speechtotext.SpeechToText;
import java.util.ArrayList;
import java.util.List;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.TargetDataLine;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0017\n\u0002\b\n\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB%\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u000f\u0010\u000b\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\u000b\u0010\fJ\u000f\u0010\r\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\r\u0010\fJ\u000f\u0010\u000e\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\u000e\u0010\fJ\u000f\u0010\u000f\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\u000f\u0010\fJ\u000f\u0010\u0011\u001a\u00020\u0010H\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u000f\u0010\u0014\u001a\u00020\u0013H\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u000f\u0010\u0016\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u000f\u0010\u0018\u001a\u00020\u0010H\u0016\u00a2\u0006\u0004\b\u0018\u0010\u0012R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0019R\u0016\u0010\u0005\u001a\u0004\u0018\u00010\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u001aR\u0018\u0010\u0007\u001a\u0004\u0018\u00010\u00068\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\u001b\u00a8\u0006\u001d"}, d2={"Lcom/ebicep/chatplus/features/speechtotext/JavaxMicrophone;", "Lcom/ebicep/chatplus/features/speechtotext/Microphone;", "", "sampleRate", "", "device", "Ljavax/sound/sampled/TargetDataLine;", "dataLine", "<init>", "(ILjava/lang/String;Ljavax/sound/sampled/TargetDataLine;)V", "", "open", "()V", "close", "startRecording", "stopRecording", "", "isActive", "()Z", "", "read", "()[S", "dataAvailable", "()I", "isOpen", "I", "Ljava/lang/String;", "Ljavax/sound/sampled/TargetDataLine;", "Companion", "chatplus-common"})
@SourceDebugExtension(value={"SMAP\nJavaxMicrophone.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JavaxMicrophone.kt\ncom/ebicep/chatplus/features/speechtotext/JavaxMicrophone\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,126:1\n13409#2,2:127\n*S KotlinDebug\n*F\n+ 1 JavaxMicrophone.kt\ncom/ebicep/chatplus/features/speechtotext/JavaxMicrophone\n*L\n25#1:127,2\n*E\n"})
public final class JavaxMicrophone
implements Microphone {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int sampleRate;
    @Nullable
    private final String device;
    @Nullable
    private TargetDataLine dataLine;

    public JavaxMicrophone(int sampleRate, @Nullable String device, @Nullable TargetDataLine dataLine) {
        this.sampleRate = sampleRate;
        this.device = device;
        this.dataLine = dataLine;
        this.open();
    }

    public /* synthetic */ JavaxMicrophone(int n, String string, TargetDataLine targetDataLine, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            targetDataLine = null;
        }
        this(n, string, targetDataLine);
    }

    @Override
    public void open() {
        if (this.isOpen()) {
            throw new MicrophoneException("Microphone already open");
        }
        ChatPlus.INSTANCE.getLOGGER().info("Opening Javax Microphone");
        AudioFormat audioFormat = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, this.sampleRate, 16, 1, 2, this.sampleRate, false);
        Mixer.Info[] infoArray = AudioSystem.getMixerInfo();
        Intrinsics.checkNotNullExpressionValue((Object)infoArray, (String)"getMixerInfo(...)");
        Object[] $this$forEach$iv = infoArray;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DataLine.Info info;
            Mixer.Info it = (Mixer.Info)element$iv;
            boolean bl = false;
            Mixer mixer = AudioSystem.getMixer(it);
            if (!mixer.isLineSupported(info = new DataLine.Info(TargetDataLine.class, audioFormat)) || !Intrinsics.areEqual((Object)it.getName(), (Object)this.device)) continue;
            Line line = mixer.getLine(info);
            Intrinsics.checkNotNull((Object)line, (String)"null cannot be cast to non-null type javax.sound.sampled.TargetDataLine");
            this.dataLine = (TargetDataLine)line;
            ChatPlus.INSTANCE.getLOGGER().info("Found microphone: " + it.getName());
        }
        if (this.dataLine == null) {
            Line line = AudioSystem.getLine(new DataLine.Info(TargetDataLine.class, audioFormat));
            Intrinsics.checkNotNull((Object)line, (String)"null cannot be cast to non-null type javax.sound.sampled.TargetDataLine");
            this.dataLine = (TargetDataLine)line;
            ChatPlus.INSTANCE.getLOGGER().info("Using default microphone");
        }
        if (this.dataLine == null) {
            throw new MicrophoneException("No microphone found");
        }
        try {
            TargetDataLine targetDataLine = this.dataLine;
            Intrinsics.checkNotNull((Object)targetDataLine);
            targetDataLine.open(audioFormat);
            ChatPlus.INSTANCE.getLOGGER().info("Microphone opened successfully");
        }
        catch (LineUnavailableException e) {
            throw new MicrophoneException(String.valueOf(e.getMessage()));
        }
    }

    @Override
    public void close() {
        if (!this.isOpen()) {
            return;
        }
        TargetDataLine targetDataLine = this.dataLine;
        Intrinsics.checkNotNull((Object)targetDataLine);
        targetDataLine.stop();
        TargetDataLine targetDataLine2 = this.dataLine;
        Intrinsics.checkNotNull((Object)targetDataLine2);
        targetDataLine2.flush();
        TargetDataLine targetDataLine3 = this.dataLine;
        Intrinsics.checkNotNull((Object)targetDataLine3);
        targetDataLine3.close();
    }

    @Override
    public void startRecording() {
        if (!this.isOpen()) {
            return;
        }
        TargetDataLine targetDataLine = this.dataLine;
        Intrinsics.checkNotNull((Object)targetDataLine);
        targetDataLine.start();
    }

    @Override
    public void stopRecording() {
        if (!this.isOpen()) {
            return;
        }
        TargetDataLine targetDataLine = this.dataLine;
        Intrinsics.checkNotNull((Object)targetDataLine);
        targetDataLine.stop();
    }

    @Override
    public boolean isActive() {
        if (this.dataLine == null) {
            return false;
        }
        TargetDataLine targetDataLine = this.dataLine;
        Intrinsics.checkNotNull((Object)targetDataLine);
        return targetDataLine.isActive();
    }

    @Override
    @NotNull
    public short[] read() {
        if (!this.isOpen()) {
            throw new MicrophoneException("Microphone is not open");
        }
        int dataAvailable = this.dataAvailable();
        byte[] buffer = new byte[dataAvailable + 1];
        TargetDataLine targetDataLine = this.dataLine;
        Intrinsics.checkNotNull((Object)targetDataLine);
        targetDataLine.read(buffer, 0, buffer.length);
        int n = 0;
        int n2 = buffer.length / 2;
        short[] sArray = new short[n2];
        while (n < n2) {
            int n3 = n++;
            sArray[n3] = (short)(buffer[n3 * 2 + 1] << 8 | buffer[n3 * 2] & 0xFF);
        }
        return sArray;
    }

    @Override
    public int dataAvailable() {
        if (this.dataLine == null) {
            return 0;
        }
        TargetDataLine targetDataLine = this.dataLine;
        Intrinsics.checkNotNull((Object)targetDataLine);
        return targetDataLine.available();
    }

    @Override
    public boolean isOpen() {
        if (this.dataLine == null) {
            return false;
        }
        TargetDataLine targetDataLine = this.dataLine;
        Intrinsics.checkNotNull((Object)targetDataLine);
        return targetDataLine.isOpen();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0013\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/ebicep/chatplus/features/speechtotext/JavaxMicrophone$Companion;", "", "<init>", "()V", "", "", "getMicrophoneNames", "()Ljava/util/List;", "chatplus-common"})
    @SourceDebugExtension(value={"SMAP\nJavaxMicrophone.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JavaxMicrophone.kt\ncom/ebicep/chatplus/features/speechtotext/JavaxMicrophone$Companion\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,126:1\n13409#2,2:127\n*S KotlinDebug\n*F\n+ 1 JavaxMicrophone.kt\ncom/ebicep/chatplus/features/speechtotext/JavaxMicrophone$Companion\n*L\n115#1:127,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<String> getMicrophoneNames() {
            AudioFormat audioFormat = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, SpeechToText.INSTANCE.getSAMPLE_RATE(), 16, 1, 2, SpeechToText.INSTANCE.getSAMPLE_RATE(), false);
            List names = new ArrayList();
            Mixer.Info[] infoArray = AudioSystem.getMixerInfo();
            Intrinsics.checkNotNullExpressionValue((Object)infoArray, (String)"getMixerInfo(...)");
            Object[] $this$forEach$iv = infoArray;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                DataLine.Info info;
                Mixer.Info it = (Mixer.Info)element$iv;
                boolean bl = false;
                Mixer mixer = AudioSystem.getMixer(it);
                if (!mixer.isLineSupported(info = new DataLine.Info(TargetDataLine.class, audioFormat))) continue;
                String string = it.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                names.add(string);
            }
            return names;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

