/*
 * Decompiled with CFR 0.152.
 */
package nuparu.caelum.mixin;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.math.Axis;
import javax.annotation.Nullable;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.DimensionSpecialEffects;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.world.level.Level;
import nuparu.caelum.client.MoonController;
import nuparu.caelum.client.SkyUtils;
import nuparu.caelum.client.data.StarDataManager;
import nuparu.caelum.config.ClientConfig;
import nuparu.caelum.config.LatitudeEffects;
import nuparu.caelum.config.StarsType;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LevelRenderer.class})
public class MixinLevelRenderer {
    @Shadow
    @Nullable
    private ClientLevel f_109465_;
    @Shadow
    @Nullable
    private VertexBuffer f_109471_;
    @Shadow
    private double f_109421_;

    @Inject(at={@At(value="HEAD")}, method={"renderSky(Lcom/mojang/blaze3d/vertex/PoseStack;Lorg/joml/Matrix4f;FLnet/minecraft/client/Camera;ZLjava/lang/Runnable;)V"}, cancellable=true)
    private void renderSky(PoseStack p_202424_, Matrix4f p_254034_, float p_202426_, Camera p_202427_, boolean p_202428_, Runnable p_202429_, CallbackInfo ci) {
        SkyUtils.calculateStarLatitudeRotation((Level)this.f_109465_, p_202427_.m_90583_().m_7094_());
        if (StarDataManager.vanillaStarBuffer == null) {
            StarDataManager.vanillaStarBuffer = this.f_109471_;
        }
        if (ClientConfig.starsType.get() == StarsType.CUSTOM) {
            this.f_109471_ = StarDataManager.INSTANCE.getStarBuffer();
        } else if (ClientConfig.starsType.get() == StarsType.VANILLA) {
            this.f_109471_ = StarDataManager.vanillaStarBuffer;
        }
    }

    @Inject(at={@At(value="INVOKE", target="Lcom/mojang/blaze3d/systems/RenderSystem;setShaderColor(FFFF)V", ordinal=2)}, method={"renderSky(Lcom/mojang/blaze3d/vertex/PoseStack;Lorg/joml/Matrix4f;FLnet/minecraft/client/Camera;ZLjava/lang/Runnable;)V"}, cancellable=true)
    private void renderSky$customStars(PoseStack p_202424_, Matrix4f p_254034_, float p_202426_, Camera p_202427_, boolean p_202428_, Runnable p_202429_, CallbackInfo ci) {
        if (ClientConfig.starsType.get() != StarsType.CUSTOM) {
            return;
        }
        float f11 = 1.0f - this.f_109465_.m_46722_(p_202426_);
        float f10 = (float)((double)(this.f_109465_.m_104811_(p_202426_) * f11) * (Double)ClientConfig.starBrightness.get());
        if (f10 > 0.0f) {
            p_202424_.m_85836_();
            p_202424_.m_252781_(Axis.f_252529_.m_252977_(180.0f));
            p_202424_.m_252781_(Axis.f_252403_.m_252977_(90.0f));
            if (ClientConfig.latitudeEffects.get() == LatitudeEffects.STARS_ONLY) {
                p_202424_.m_252781_(Axis.f_252436_.m_252977_((float)(180.0 * SkyUtils.starLatitudeRotation((Level)this.f_109465_, p_202427_.m_90583_().m_7094_()))));
            }
            p_202424_.m_252781_(Axis.f_252403_.m_252977_(-this.f_109465_.m_46942_(p_202426_) * 360.0f));
            p_202424_.m_252781_(Axis.f_252403_.m_252977_((float)(-SkyUtils.yearRotation((Level)this.f_109465_) * 360.0)));
            RenderSystem.setShaderColor((float)f10, (float)f10, (float)f10, (float)f10);
            FogRenderer.m_109017_();
            this.f_109471_.m_85921_();
            this.f_109471_.m_253207_(p_202424_.m_85850_().m_252922_(), p_254034_, GameRenderer.m_172811_());
            VertexBuffer.m_85931_();
            p_202429_.run();
            p_202424_.m_85849_();
        }
    }

    @Redirect(at=@At(value="INVOKE", target="Lcom/mojang/blaze3d/vertex/VertexBuffer;drawWithShader(Lorg/joml/Matrix4f;Lorg/joml/Matrix4f;Lnet/minecraft/client/renderer/ShaderInstance;)V"), method={"renderSky(Lcom/mojang/blaze3d/vertex/PoseStack;Lorg/joml/Matrix4f;FLnet/minecraft/client/Camera;ZLjava/lang/Runnable;)V"})
    private void renderSky$skipVanillaStars(VertexBuffer buffer, Matrix4f p_254480_, Matrix4f p_254555_, ShaderInstance p_253993_) {
        if (!buffer.equals(this.f_109471_) || ClientConfig.starsType.get() == StarsType.VANILLA) {
            buffer.m_253207_(p_254480_, p_254555_, p_253993_);
        }
    }

    @Redirect(at=@At(value="INVOKE", target="Lnet/minecraft/client/renderer/DimensionSpecialEffects;getSunriseColor(FF)[F"), method={"renderSky(Lcom/mojang/blaze3d/vertex/PoseStack;Lorg/joml/Matrix4f;FLnet/minecraft/client/Camera;ZLjava/lang/Runnable;)V"})
    private float[] renderSky$getSunriseColor(DimensionSpecialEffects effects, float p_108872_, float p_108873_) {
        return SkyUtils.getSunriseColor((Level)this.f_109465_, this.f_109421_, p_108873_);
    }

    @Redirect(at=@At(value="INVOKE", target="Lcom/mojang/blaze3d/vertex/PoseStack;mulPose(Lorg/joml/Quaternionf;)V", ordinal=1), method={"renderSky(Lcom/mojang/blaze3d/vertex/PoseStack;Lorg/joml/Matrix4f;FLnet/minecraft/client/Camera;ZLjava/lang/Runnable;)V"})
    private void renderSky$sunriseRotationRemoveVanilla(PoseStack instance, Quaternionf p_254385_) {
    }

    @Inject(at={@At(value="INVOKE", target="Lcom/mojang/blaze3d/vertex/PoseStack;mulPose(Lorg/joml/Quaternionf;)V", ordinal=1)}, method={"renderSky(Lcom/mojang/blaze3d/vertex/PoseStack;Lorg/joml/Matrix4f;FLnet/minecraft/client/Camera;ZLjava/lang/Runnable;)V"})
    private void renderSky$sunriseRotation(PoseStack p_202424_, Matrix4f p_254034_, float p_202426_, Camera p_202427_, boolean p_202428_, Runnable p_202429_, CallbackInfo ci) {
        p_202424_.m_252781_(Axis.f_252403_.m_252977_((float)SkyUtils.getSunriseColorRotation((Level)this.f_109465_, this.f_109421_, p_202426_)));
    }

    @Inject(at={@At(value="INVOKE", target="Lnet/minecraft/client/multiplayer/ClientLevel;getMoonPhase()I")}, method={"renderSky(Lcom/mojang/blaze3d/vertex/PoseStack;Lorg/joml/Matrix4f;FLnet/minecraft/client/Camera;ZLjava/lang/Runnable;)V"}, cancellable=true)
    private void renderSky$renderMoon$Pre(PoseStack p_202424_, Matrix4f p_254034_, float p_202426_, Camera p_202427_, boolean p_202428_, Runnable p_202429_, CallbackInfo ci) {
        p_202424_.m_252781_(Axis.f_252529_.m_252961_(-MoonController.MOON.getMoonOrbitPosition(this.f_109465_.m_46468_()) * ((float)Math.PI * 2)));
        p_202424_.m_252781_(Axis.f_252436_.m_252977_(90.0f));
        int phase = this.f_109465_.m_46941_();
        if (phase == 4) {
            RenderSystem.setShaderColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        }
    }

    @Inject(at={@At(value="INVOKE", target="Lnet/minecraft/client/multiplayer/ClientLevel;getStarBrightness(F)F")}, method={"renderSky(Lcom/mojang/blaze3d/vertex/PoseStack;Lorg/joml/Matrix4f;FLnet/minecraft/client/Camera;ZLjava/lang/Runnable;)V"}, cancellable=true)
    private void renderSky$renderMoon$Post(PoseStack p_202424_, Matrix4f p_254034_, float p_202426_, Camera p_202427_, boolean p_202428_, Runnable p_202429_, CallbackInfo ci) {
        p_202424_.m_252781_(Axis.f_252529_.m_252961_(MoonController.MOON.getMoonOrbitPosition(this.f_109465_.m_46468_()) * ((float)Math.PI * 2)));
        p_202424_.m_252781_(Axis.f_252436_.m_252977_(-90.0f));
    }

    @Inject(at={@At(value="INVOKE", target="Lnet/minecraft/client/multiplayer/ClientLevel;getRainLevel(F)F")}, method={"renderSky(Lcom/mojang/blaze3d/vertex/PoseStack;Lorg/joml/Matrix4f;FLnet/minecraft/client/Camera;ZLjava/lang/Runnable;)V"}, cancellable=true)
    private void renderSky$renderCelestial$Pre(PoseStack p_202424_, Matrix4f p_254034_, float p_202426_, Camera p_202427_, boolean p_202428_, Runnable p_202429_, CallbackInfo ci) {
        if (ClientConfig.latitudeEffects.get() == LatitudeEffects.ALL) {
            p_202424_.m_252781_(Axis.f_252529_.m_252977_((float)(-180.0 * SkyUtils.starLatitudeRotation((Level)this.f_109465_, p_202427_.m_90583_().m_7094_()))));
        }
    }
}

