/*
 * Decompiled with CFR 0.152.
 */
package nuparu.caelum.client;

import java.math.BigDecimal;
import java.math.RoundingMode;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import nuparu.caelum.config.ClientConfig;
import nuparu.caelum.config.LatitudeEffects;
import nuparu.caelum.config.WorldHeightType;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class SkyUtils {
    private static final float[] sunriseCol = new float[4];
    private static Double starLatitudeRotation = null;
    private static final Vector3f EAST = new Vector3f(1.0f, 0.0f, 0.0f);
    private static final Vector3f UP = new Vector3f(0.0f, 1.0f, 0.0f);

    public static double calculateStarLatitudeRotation(Level level, double z) {
        BigDecimal minZ = BigDecimal.valueOf(ClientConfig.worldHeightType.get() == WorldHeightType.BORDER ? level.m_6857_().m_61956_() : (double)((Long)ClientConfig.minZ.get()).longValue()).subtract(BigDecimal.valueOf((Long)ClientConfig.minZMargin.get()));
        BigDecimal maxZ = BigDecimal.valueOf(ClientConfig.worldHeightType.get() == WorldHeightType.BORDER ? level.m_6857_().m_61958_() : (double)((Long)ClientConfig.maxZ.get()).longValue()).add(BigDecimal.valueOf((Long)ClientConfig.maxZMargin.get())).subtract(minZ);
        BigDecimal bigZ = BigDecimal.valueOf(z).subtract(minZ);
        starLatitudeRotation = Mth.m_14008_((double)bigZ.divide(maxZ, RoundingMode.HALF_DOWN).doubleValue(), (double)0.0, (double)1.0) - 0.5;
        return starLatitudeRotation;
    }

    public static double starLatitudeRotation(Level level, double z) {
        return starLatitudeRotation == null ? SkyUtils.calculateStarLatitudeRotation(level, z) : starLatitudeRotation;
    }

    public static double sunLatitudeRotation(Level level, double z) {
        return ClientConfig.latitudeEffects.get() == LatitudeEffects.ALL ? SkyUtils.starLatitudeRotation(level, z) : 0.0;
    }

    public static double yearRotation(Level level) {
        return (Long)ClientConfig.earthOrbitPeriod.get() == 0L ? 0.0 : (double)(level.m_8044_() % (Long)ClientConfig.earthOrbitPeriod.get()) / (double)((Long)ClientConfig.earthOrbitPeriod.get()).longValue();
    }

    public static double sunHeight(Level level, double z, float partialTicks) {
        double latitudeTilt = SkyUtils.sunLatitudeRotation(level, z) * 3.1415927410125732;
        double untitledHeight = Mth.m_14089_((float)(level.m_46942_(partialTicks) * ((float)Math.PI * 2)));
        return untitledHeight * Math.cos(latitudeTilt);
    }

    public static double smoothTimeOfDay(double timeOfDay) {
        double subtracted = timeOfDay - 0.75;
        if (subtracted < 0.0) {
            subtracted += 1.0;
        }
        return subtracted;
    }

    public static float[] getSunriseColor(Level level, double z, float partialTicks) {
        float f = 0.4f;
        float f1 = (float)SkyUtils.sunHeight(level, z, partialTicks);
        float f2 = -0.0f;
        if (f1 >= -0.4f && f1 <= 0.4f) {
            float f3 = (f1 - -0.0f) / 0.4f * 0.5f + 0.5f;
            float f4 = 1.0f - (1.0f - Mth.m_14031_((float)(f3 * (float)Math.PI))) * 0.99f;
            f4 *= f4;
            SkyUtils.sunriseCol[0] = f3 * 0.3f + 0.7f;
            SkyUtils.sunriseCol[1] = f3 * f3 * 0.7f + 0.2f;
            SkyUtils.sunriseCol[2] = f3 * f3 * 0.0f + 0.2f;
            SkyUtils.sunriseCol[3] = f4;
            return sunriseCol;
        }
        return null;
    }

    public static double getSunriseColorRotation(Level level, double z, float partialTicks) {
        return 180.0 + SkyUtils.sign(z) * (double)EAST.angleSigned((Vector3fc)SkyUtils.sunVector(level, z, partialTicks), (Vector3fc)UP) * 57.2957763671875;
    }

    private static double sign(double val) {
        return val == 0.0 ? 1.0 : Math.signum(val);
    }

    public static double apparentTimeOfDay(Level level, double z, float partialTicks) {
        double sunHeight = SkyUtils.sunHeight(level, z, partialTicks);
        return 0.75 + sunHeight / 4.0;
    }

    public static Vector3f sunVector(Level level, double zPos, float partialTicks) {
        double azimuth = SkyUtils.smoothTimeOfDay(level.m_46942_(partialTicks)) * 360.0;
        double tiltAngle = SkyUtils.sunLatitudeRotation(level, zPos) * 180.0;
        double zenithAngle = tiltAngle - 90.0;
        double azimuthRad = azimuth * 0.01745329238474369;
        double zenithAngleRad = zenithAngle * 0.01745329238474369;
        double x = Math.cos(azimuthRad) * Math.cos(zenithAngleRad);
        double z = Math.sin(azimuthRad) * Math.cos(zenithAngleRad);
        if (tiltAngle < 0.0) {
            x *= -1.0;
            z *= -1.0;
        }
        return new Vector3f((float)x, 0.0f, (float)z);
    }
}

