/*
 * Decompiled with CFR 0.152.
 */
package nuparu.caelum.client;

import nuparu.caelum.config.ClientConfig;

public record MoonController(long initialPosition, long orbitPeriod, int phases) {
    public static MoonController MOON = new MoonController(0L, (Long)ClientConfig.lunarOrbitPeriod.get(), 8);

    public float getMoonOrbitPosition(long gameTime) {
        return (float)((gameTime + this.initialPosition) % this.orbitPeriod) / (float)this.orbitPeriod;
    }

    public int getMoonPhase(long gameTime) {
        double orbitTime = this.getMoonOrbitPosition(gameTime);
        double eighth = 0.125;
        int stage = (int)Math.ceil(orbitTime * 7.0);
        if (orbitTime < eighth / 2.0 || orbitTime > 1.0 - eighth / 2.0) {
            stage = 0;
        }
        return stage == 0 ? stage : 8 - stage;
    }
}

