/*
 * Decompiled with CFR 0.152.
 */
package net.bojarsky.bojarskythings.event;

import com.mojang.logging.LogUtils;
import net.bojarsky.bojarskyauthclient.client.BojarskyAuthClientApi;
import net.bojarsky.bojarskythings.entity.ModEntities;
import net.bojarsky.bojarskythings.entity.client.BanditArcherRenderer;
import net.bojarsky.bojarskythings.entity.client.BanditRenderer;
import net.bojarsky.bojarskythings.screen.ModGrindstoneScreen;
import net.bojarsky.bojarskythings.screen.ModMenuTypes;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.inventory.MenuType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import org.slf4j.Logger;

@Mod.EventBusSubscriber(modid="bojarskythings", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class ClientSetup {
    private static final Logger LOGGER = LogUtils.getLogger();

    @SubscribeEvent
    public static void onClientSetup(FMLClientSetupEvent event) {
        LOGGER.info("BojarskyThings: Client Setup Starting...");
        event.enqueueWork(() -> {
            try {
                LOGGER.info("BojarskyThings: Performing presence check for bojarskyauthclient.");
                BojarskyAuthClientApi.ensurePresence();
                LOGGER.info("BojarskyThings: BojarskyAuthClient presence confirmed. Proceeding with client setup.");
                MenuScreens.m_96206_((MenuType)((MenuType)ModMenuTypes.MOD_GRINDSTONE_MENU.get()), ModGrindstoneScreen::new);
                EntityRenderers.m_174036_((EntityType)((EntityType)ModEntities.BANDIT.get()), BanditRenderer::new);
                EntityRenderers.m_174036_((EntityType)((EntityType)ModEntities.BANDIT_ARCHER.get()), BanditArcherRenderer::new);
                LOGGER.info("BojarskyThings: All client setup tasks (including registrations) completed successfully.");
            }
            catch (NoClassDefFoundError | NoSuchMethodError e) {
                LOGGER.error("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
                LOGGER.error("!!! CRITICAL BojarskyThings ERROR: Required companion mod 'bojarskyauthclient' is MISSING or incompatible! ");
                LOGGER.error("!!! Mod '{}' cannot function without it. Please install the correct version.    !!!", (Object)"bojarskythings");
                LOGGER.error("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!", (Throwable)e);
                throw new RuntimeException("BojarskyThings failed to initialize client features: Missing or incompatible 'bojarskyauthclient'.", e);
            }
            catch (Throwable t) {
                LOGGER.error("!!! CRITICAL BojarskyThings ERROR: Unexpected error during client setup while checking for bojarskyauthclient or during registrations. !!!", t);
                throw new RuntimeException("BojarskyThings failed to initialize client features due to an unexpected error during client setup.", t);
            }
        });
        LOGGER.info("BojarskyThings: Client Setup task enqueued.");
    }
}

