/*
 * Decompiled with CFR 0.152.
 */
package net.bojarsky.bojarskythings.entity.custom;

import java.util.List;
import net.bojarsky.bojarskythings.config.MobConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RangedBowAttackGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class BanditArcherEntity
extends Monster
implements RangedAttackMob {
    public BanditArcherEntity(EntityType<? extends BanditArcherEntity> entityType, Level level) {
        super(entityType, level);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new RangedBowAttackGoal((Monster)this, 1.0, ((Integer)MobConfig.SERVER.banditArcher.GOAL_RANGED_ATTACK_INTERVAL.get()).intValue(), ((Double)MobConfig.SERVER.banditArcher.GOAL_RANGED_ATTACK_RANGE.get()).floatValue()));
        this.f_21345_.m_25352_(2, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(3, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(4, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22281_, 3.0).m_22268_(Attributes.f_22277_, 30.0).m_22268_(Attributes.f_22284_, 2.0).m_22268_(Attributes.f_22278_, 0.0);
    }

    private void applyConfigurableAttributes() {
        if (!this.m_9236_().f_46443_) {
            this.m_21051_(Attributes.f_22276_).m_22100_(((Double)MobConfig.SERVER.banditArcher.MAX_HEALTH.get()).doubleValue());
            this.m_21051_(Attributes.f_22279_).m_22100_(((Double)MobConfig.SERVER.banditArcher.MOVEMENT_SPEED.get()).doubleValue());
            this.m_21051_(Attributes.f_22277_).m_22100_(((Double)MobConfig.SERVER.banditArcher.FOLLOW_RANGE.get()).doubleValue());
            this.m_21051_(Attributes.f_22284_).m_22100_(((Double)MobConfig.SERVER.banditArcher.ARMOR_VALUE.get()).doubleValue());
            this.m_21051_(Attributes.f_22278_).m_22100_(((Double)MobConfig.SERVER.banditArcher.KNOCKBACK_RESISTANCE.get()).doubleValue());
            this.m_21153_(this.m_21233_());
        }
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor levelAccessor, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData spawnData, @Nullable CompoundTag dataTag) {
        List feetItems;
        List legsItems;
        List chestItems;
        spawnData = super.m_6518_(levelAccessor, difficulty, reason, spawnData, dataTag);
        this.applyConfigurableAttributes();
        RandomSource random = levelAccessor.m_213780_();
        List headItems = (List)MobConfig.SERVER.banditArcher.EQUIP_HEAD_ITEMS.get();
        if (!headItems.isEmpty() && random.m_188501_() < ((Double)MobConfig.SERVER.banditArcher.EQUIP_HEAD_CHANCE.get()).floatValue()) {
            String helmetId = (String)headItems.get(random.m_188503_(headItems.size()));
            this.setDamagedEquipment(random, EquipmentSlot.HEAD, helmetId, ((Double)MobConfig.SERVER.banditArcher.EQUIP_HEAD_DAMAGE_MIN.get()).floatValue(), ((Double)MobConfig.SERVER.banditArcher.EQUIP_HEAD_DAMAGE_MAX.get()).floatValue(), ((Double)MobConfig.SERVER.banditArcher.EQUIP_HEAD_DROP_CHANCE.get()).floatValue());
        }
        if (!(chestItems = (List)MobConfig.SERVER.banditArcher.EQUIP_CHEST_ITEMS.get()).isEmpty() && random.m_188501_() < ((Double)MobConfig.SERVER.banditArcher.EQUIP_CHEST_CHANCE.get()).floatValue()) {
            String chestplateId = (String)chestItems.get(random.m_188503_(chestItems.size()));
            this.setDamagedEquipment(random, EquipmentSlot.CHEST, chestplateId, ((Double)MobConfig.SERVER.banditArcher.EQUIP_CHEST_DAMAGE_MIN.get()).floatValue(), ((Double)MobConfig.SERVER.banditArcher.EQUIP_CHEST_DAMAGE_MAX.get()).floatValue(), ((Double)MobConfig.SERVER.banditArcher.EQUIP_CHEST_DROP_CHANCE.get()).floatValue());
        }
        if (!(legsItems = (List)MobConfig.SERVER.banditArcher.EQUIP_LEGS_ITEMS.get()).isEmpty() && random.m_188501_() < ((Double)MobConfig.SERVER.banditArcher.EQUIP_LEGS_CHANCE.get()).floatValue()) {
            String leggingsId = (String)legsItems.get(random.m_188503_(legsItems.size()));
            this.setDamagedEquipment(random, EquipmentSlot.LEGS, leggingsId, ((Double)MobConfig.SERVER.banditArcher.EQUIP_LEGS_DAMAGE_MIN.get()).floatValue(), ((Double)MobConfig.SERVER.banditArcher.EQUIP_LEGS_DAMAGE_MAX.get()).floatValue(), ((Double)MobConfig.SERVER.banditArcher.EQUIP_LEGS_DROP_CHANCE.get()).floatValue());
        }
        if (!(feetItems = (List)MobConfig.SERVER.banditArcher.EQUIP_FEET_ITEMS.get()).isEmpty() && random.m_188501_() < ((Double)MobConfig.SERVER.banditArcher.EQUIP_FEET_CHANCE.get()).floatValue()) {
            String bootsId = (String)feetItems.get(random.m_188503_(feetItems.size()));
            this.setDamagedEquipment(random, EquipmentSlot.FEET, bootsId, ((Double)MobConfig.SERVER.banditArcher.EQUIP_FEET_DAMAGE_MIN.get()).floatValue(), ((Double)MobConfig.SERVER.banditArcher.EQUIP_FEET_DAMAGE_MAX.get()).floatValue(), ((Double)MobConfig.SERVER.banditArcher.EQUIP_FEET_DROP_CHANCE.get()).floatValue());
        }
        this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42411_));
        this.m_21409_(EquipmentSlot.MAINHAND, 0.05f);
        return spawnData;
    }

    private void setDamagedEquipment(RandomSource random, EquipmentSlot slot, String itemId, float minDurabilityPercent, float maxDurabilityPercent, float dropChance) {
        Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(itemId));
        if (item != null && item != Items.f_41852_) {
            ItemStack itemStack = new ItemStack((ItemLike)item);
            this.setLowDurability(random, itemStack, minDurabilityPercent, maxDurabilityPercent);
            this.m_8061_(slot, itemStack);
            this.m_21409_(slot, dropChance);
        }
    }

    private void setLowDurability(RandomSource random, ItemStack itemStack, float minDurabilityPercent, float maxDurabilityPercent) {
        if (!itemStack.m_41763_()) {
            return;
        }
        int maxDamage = itemStack.m_41776_();
        if (maxDamage > 0) {
            float actualMax;
            float actualMin = Math.min(minDurabilityPercent, maxDurabilityPercent);
            if (actualMin == (actualMax = Math.max(minDurabilityPercent, maxDurabilityPercent)) && actualMax < 1.0f) {
                actualMax = Math.min(1.0f, actualMin + 0.01f);
            } else if (actualMin == actualMax && actualMax >= 1.0f) {
                return;
            }
            float durabilityPercent = actualMin + random.m_188501_() * (actualMax - actualMin);
            int remainingDurability = Math.max(1, (int)((float)maxDamage * durabilityPercent));
            itemStack.m_41721_(maxDamage - remainingDurability);
            if (itemStack.m_41773_() >= maxDamage) {
                itemStack.m_41721_(maxDamage - 1);
            }
            if (itemStack.m_41773_() < 0) {
                itemStack.m_41721_(0);
            }
        }
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_12307_;
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return SoundEvents.f_12310_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12309_;
    }

    protected void m_7355_(BlockPos pos, BlockState blockIn) {
        this.m_5496_(SoundEvents.f_12383_, 0.15f, 1.0f);
    }

    public void m_6504_(LivingEntity target, float distanceFactor) {
        ItemStack bow = this.m_21205_();
        ItemStack ammo = this.m_6298_(bow);
        AbstractArrow arrow = ProjectileUtil.m_37300_((LivingEntity)this, (ItemStack)(ammo.m_41619_() ? new ItemStack((ItemLike)Items.f_42412_) : ammo), (float)distanceFactor);
        double d0 = target.m_20185_() - this.m_20185_();
        double d1 = target.m_20227_(0.3333333333333333) - arrow.m_20186_();
        double d2 = target.m_20189_() - this.m_20189_();
        double d3 = Math.sqrt(d0 * d0 + d2 * d2);
        arrow.m_6686_(d0, d1 + d3 * (double)0.2f, d2, 1.6f, (float)(14 - this.m_9236_().m_46791_().m_19028_() * 4));
        this.m_5496_(SoundEvents.f_12382_, 1.0f, 1.0f / (this.m_217043_().m_188501_() * 0.4f + 0.8f));
        this.m_9236_().m_7967_((Entity)arrow);
    }

    public static boolean checkBanditArcherSpawnRules(EntityType<BanditArcherEntity> entityType, ServerLevelAccessor levelAccessor, MobSpawnType spawnReason, BlockPos pos, RandomSource random) {
        if (!levelAccessor.m_6018_().m_46462_()) {
            return false;
        }
        return Mob.m_217057_(entityType, (LevelAccessor)levelAccessor, (MobSpawnType)spawnReason, (BlockPos)pos, (RandomSource)random);
    }
}

