/*
 * Decompiled with CFR 0.152.
 */
package net.bojarsky.bojarskythings.config;

import java.util.Arrays;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class MobConfig {
    public static final Server SERVER;
    public static final ForgeConfigSpec SERVER_SPEC;

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Server::new);
        SERVER_SPEC = (ForgeConfigSpec)specPair.getRight();
        SERVER = (Server)specPair.getLeft();
    }

    public static class Server {
        public final BanditSettings bandit;
        public final BanditArcherSettings banditArcher;

        Server(ForgeConfigSpec.Builder builder) {
            builder.comment("BojarskyThings: Custom Mob Configuration").push("mobs");
            this.bandit = new BanditSettings(builder, "bandit", "Bandit specific settings (melee)");
            this.banditArcher = new BanditArcherSettings(builder, "bandit_archer", "Bandit Archer specific settings (ranged)");
            builder.pop();
        }
    }

    public static class BanditArcherSettings {
        public final ForgeConfigSpec.DoubleValue MAX_HEALTH;
        public final ForgeConfigSpec.DoubleValue MOVEMENT_SPEED;
        public final ForgeConfigSpec.DoubleValue FOLLOW_RANGE;
        public final ForgeConfigSpec.DoubleValue ARMOR_VALUE;
        public final ForgeConfigSpec.DoubleValue KNOCKBACK_RESISTANCE;
        public final ForgeConfigSpec.IntValue GOAL_RANGED_ATTACK_INTERVAL;
        public final ForgeConfigSpec.DoubleValue GOAL_RANGED_ATTACK_RANGE;
        public final ForgeConfigSpec.DoubleValue EQUIP_HEAD_CHANCE;
        public final ForgeConfigSpec.DoubleValue EQUIP_HEAD_DROP_CHANCE;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> EQUIP_HEAD_ITEMS;
        public final ForgeConfigSpec.DoubleValue EQUIP_HEAD_DAMAGE_MIN;
        public final ForgeConfigSpec.DoubleValue EQUIP_HEAD_DAMAGE_MAX;
        public final ForgeConfigSpec.DoubleValue EQUIP_CHEST_CHANCE;
        public final ForgeConfigSpec.DoubleValue EQUIP_CHEST_DROP_CHANCE;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> EQUIP_CHEST_ITEMS;
        public final ForgeConfigSpec.DoubleValue EQUIP_CHEST_DAMAGE_MIN;
        public final ForgeConfigSpec.DoubleValue EQUIP_CHEST_DAMAGE_MAX;
        public final ForgeConfigSpec.DoubleValue EQUIP_LEGS_CHANCE;
        public final ForgeConfigSpec.DoubleValue EQUIP_LEGS_DROP_CHANCE;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> EQUIP_LEGS_ITEMS;
        public final ForgeConfigSpec.DoubleValue EQUIP_LEGS_DAMAGE_MIN;
        public final ForgeConfigSpec.DoubleValue EQUIP_LEGS_DAMAGE_MAX;
        public final ForgeConfigSpec.DoubleValue EQUIP_FEET_CHANCE;
        public final ForgeConfigSpec.DoubleValue EQUIP_FEET_DROP_CHANCE;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> EQUIP_FEET_ITEMS;
        public final ForgeConfigSpec.DoubleValue EQUIP_FEET_DAMAGE_MIN;
        public final ForgeConfigSpec.DoubleValue EQUIP_FEET_DAMAGE_MAX;
        public final ForgeConfigSpec.IntValue SPAWN_WEIGHT;
        public final ForgeConfigSpec.IntValue SPAWN_MIN_GROUP_SIZE;
        public final ForgeConfigSpec.IntValue SPAWN_MAX_GROUP_SIZE;

        public BanditArcherSettings(ForgeConfigSpec.Builder builder, String mobKey, String comment) {
            builder.comment(comment).push(mobKey);
            builder.comment("Archer core combat attributes.").push("attributes");
            this.MAX_HEALTH = builder.defineInRange("maxHealth", 20.0, 1.0, 1024.0);
            this.MOVEMENT_SPEED = builder.defineInRange("movementSpeed", 0.25, 0.01, 5.0);
            this.FOLLOW_RANGE = builder.defineInRange("followRange", 30.0, 1.0, 256.0);
            this.ARMOR_VALUE = builder.defineInRange("armor", 2.0, 0.0, 100.0);
            this.KNOCKBACK_RESISTANCE = builder.defineInRange("knockbackResistance", 0.0, 0.0, 1.0);
            builder.pop();
            builder.comment("Archer AI behavior parameters.").push("goals");
            this.GOAL_RANGED_ATTACK_INTERVAL = builder.comment("Interval between shots in ticks (20 ticks = 1 sec).").defineInRange("attackIntervalMin", 20, 1, 600);
            this.GOAL_RANGED_ATTACK_RANGE = builder.comment("Max attack range in blocks.").defineInRange("attackRadius", 15.0, 1.0, 128.0);
            builder.pop();
            builder.comment("Archer spawn equipment settings.").push("equipment");
            builder.push("head");
            this.EQUIP_HEAD_CHANCE = builder.defineInRange("randomChanceFloat", 0.3, 0.0, 1.0);
            this.EQUIP_HEAD_DROP_CHANCE = builder.defineInRange("dropChanceFloat", 0.1, 0.0, 1.0);
            this.EQUIP_HEAD_ITEMS = builder.defineList("randomFromList", Arrays.asList("tfc:metal/helmet/copper", "tfc:metal/helmet/bronze"), s -> s instanceof String && !((String)s).isEmpty());
            builder.push("setDamage");
            this.EQUIP_HEAD_DAMAGE_MIN = builder.defineInRange("minFloat", 0.1, 0.0, 1.0);
            this.EQUIP_HEAD_DAMAGE_MAX = builder.defineInRange("maxFloat", 0.4, 0.0, 1.0);
            builder.pop();
            builder.pop();
            builder.push("chest");
            this.EQUIP_CHEST_CHANCE = builder.defineInRange("randomChanceFloat", 0.2, 0.0, 1.0);
            this.EQUIP_CHEST_DROP_CHANCE = builder.defineInRange("dropChanceFloat", 0.1, 0.0, 1.0);
            this.EQUIP_CHEST_ITEMS = builder.defineList("randomFromList", Arrays.asList("tfc:metal/chestplate/copper", "tfc:metal/chestplate/bronze"), s -> s instanceof String && !((String)s).isEmpty());
            builder.push("setDamage");
            this.EQUIP_CHEST_DAMAGE_MIN = builder.defineInRange("minFloat", 0.1, 0.0, 1.0);
            this.EQUIP_CHEST_DAMAGE_MAX = builder.defineInRange("maxFloat", 0.4, 0.0, 1.0);
            builder.pop();
            builder.pop();
            builder.push("legs");
            this.EQUIP_LEGS_CHANCE = builder.defineInRange("randomChanceFloat", 0.2, 0.0, 1.0);
            this.EQUIP_LEGS_DROP_CHANCE = builder.defineInRange("dropChanceFloat", 0.1, 0.0, 1.0);
            this.EQUIP_LEGS_ITEMS = builder.defineList("randomFromList", Arrays.asList("tfc:metal/greaves/copper", "tfc:metal/greaves/bronze"), s -> s instanceof String && !((String)s).isEmpty());
            builder.push("setDamage");
            this.EQUIP_LEGS_DAMAGE_MIN = builder.defineInRange("minFloat", 0.1, 0.0, 1.0);
            this.EQUIP_LEGS_DAMAGE_MAX = builder.defineInRange("maxFloat", 0.4, 0.0, 1.0);
            builder.pop();
            builder.pop();
            builder.push("feet");
            this.EQUIP_FEET_CHANCE = builder.defineInRange("randomChanceFloat", 0.3, 0.0, 1.0);
            this.EQUIP_FEET_DROP_CHANCE = builder.defineInRange("dropChanceFloat", 0.1, 0.0, 1.0);
            this.EQUIP_FEET_ITEMS = builder.defineList("randomFromList", Arrays.asList("tfc:metal/boots/copper", "tfc:metal/boots/bronze"), s -> s instanceof String && !((String)s).isEmpty());
            builder.push("setDamage");
            this.EQUIP_FEET_DAMAGE_MIN = builder.defineInRange("minFloat", 0.1, 0.0, 1.0);
            this.EQUIP_FEET_DAMAGE_MAX = builder.defineInRange("maxFloat", 0.4, 0.0, 1.0);
            builder.pop();
            builder.pop();
            builder.pop();
            builder.comment("Archer natural spawn settings.").push("spawning");
            this.SPAWN_WEIGHT = builder.defineInRange("spawnWeight", 30, 0, 500);
            this.SPAWN_MIN_GROUP_SIZE = builder.defineInRange("minGroupSize", 1, 1, 5);
            this.SPAWN_MAX_GROUP_SIZE = builder.defineInRange("maxGroupSize", 3, 1, 10);
            builder.pop();
            builder.pop();
        }
    }

    public static class BanditSettings {
        public final ForgeConfigSpec.DoubleValue HITBOX_WIDTH;
        public final ForgeConfigSpec.DoubleValue HITBOX_HEIGHT;
        public final ForgeConfigSpec.DoubleValue MAX_HEALTH;
        public final ForgeConfigSpec.DoubleValue MOVEMENT_SPEED;
        public final ForgeConfigSpec.DoubleValue ATTACK_DAMAGE;
        public final ForgeConfigSpec.DoubleValue FOLLOW_RANGE;
        public final ForgeConfigSpec.DoubleValue ARMOR_VALUE;
        public final ForgeConfigSpec.DoubleValue KNOCKBACK_RESISTANCE;
        public final ForgeConfigSpec.DoubleValue GOAL_MELEE_ATTACK_SPEED_MODIFIER;
        public final ForgeConfigSpec.DoubleValue GOAL_LOOK_AT_PLAYER_DISTANCE;
        public final ForgeConfigSpec.DoubleValue GOAL_WATER_AVOIDING_STROLL_SPEED_MODIFIER;
        public final ForgeConfigSpec.DoubleValue EQUIP_HEAD_CHANCE;
        public final ForgeConfigSpec.DoubleValue EQUIP_HEAD_DROP_CHANCE;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> EQUIP_HEAD_ITEMS;
        public final ForgeConfigSpec.DoubleValue EQUIP_HEAD_DAMAGE_MIN;
        public final ForgeConfigSpec.DoubleValue EQUIP_HEAD_DAMAGE_MAX;
        public final ForgeConfigSpec.DoubleValue EQUIP_CHEST_CHANCE;
        public final ForgeConfigSpec.DoubleValue EQUIP_CHEST_DROP_CHANCE;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> EQUIP_CHEST_ITEMS;
        public final ForgeConfigSpec.DoubleValue EQUIP_CHEST_DAMAGE_MIN;
        public final ForgeConfigSpec.DoubleValue EQUIP_CHEST_DAMAGE_MAX;
        public final ForgeConfigSpec.DoubleValue EQUIP_LEGS_CHANCE;
        public final ForgeConfigSpec.DoubleValue EQUIP_LEGS_DROP_CHANCE;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> EQUIP_LEGS_ITEMS;
        public final ForgeConfigSpec.DoubleValue EQUIP_LEGS_DAMAGE_MIN;
        public final ForgeConfigSpec.DoubleValue EQUIP_LEGS_DAMAGE_MAX;
        public final ForgeConfigSpec.DoubleValue EQUIP_FEET_CHANCE;
        public final ForgeConfigSpec.DoubleValue EQUIP_FEET_DROP_CHANCE;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> EQUIP_FEET_ITEMS;
        public final ForgeConfigSpec.DoubleValue EQUIP_FEET_DAMAGE_MIN;
        public final ForgeConfigSpec.DoubleValue EQUIP_FEET_DAMAGE_MAX;
        public final ForgeConfigSpec.DoubleValue EQUIP_MAINHAND_CHANCE;
        public final ForgeConfigSpec.DoubleValue EQUIP_MAINHAND_DROP_CHANCE;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> EQUIP_MAINHAND_ITEMS;
        public final ForgeConfigSpec.DoubleValue EQUIP_MAINHAND_DAMAGE_MIN;
        public final ForgeConfigSpec.DoubleValue EQUIP_MAINHAND_DAMAGE_MAX;
        public final ForgeConfigSpec.DoubleValue EQUIP_OFFHAND_DROP_CHANCE;
        public final ForgeConfigSpec.ConfigValue<String> EQUIP_OFFHAND_ITEM;
        public final ForgeConfigSpec.BooleanValue EQUIP_OFFHAND_CONDITION_IS_NIGHT;
        public final ForgeConfigSpec.IntValue SPAWN_WEIGHT;
        public final ForgeConfigSpec.IntValue SPAWN_MIN_GROUP_SIZE;
        public final ForgeConfigSpec.IntValue SPAWN_MAX_GROUP_SIZE;

        public BanditSettings(ForgeConfigSpec.Builder builder, String mobKey, String comment) {
            builder.comment(comment).push(mobKey);
            builder.comment("Hitbox size (width, height). For reference in server config.").push("hitbox");
            this.HITBOX_WIDTH = builder.comment("Width in blocks.").defineInRange("widthFloat", 0.6, 0.1, 5.0);
            this.HITBOX_HEIGHT = builder.comment("Height in blocks.").defineInRange("heightFloat", 1.95, 0.1, 5.0);
            builder.pop();
            builder.comment("Bandit core combat attributes.").push("attributes");
            this.MAX_HEALTH = builder.comment("Max health points.").defineInRange("maxHealth", 25.0, 1.0, 1024.0);
            this.MOVEMENT_SPEED = builder.comment("Base movement speed.").defineInRange("movementSpeed", 0.3, 0.01, 5.0);
            this.ATTACK_DAMAGE = builder.comment("Base melee attack damage (w/o weapon).").defineInRange("attackDamage", 5.0, 0.0, 100.0);
            this.FOLLOW_RANGE = builder.comment("Target detection range in blocks.").defineInRange("followRange", 15.0, 1.0, 256.0);
            this.ARMOR_VALUE = builder.comment("Base armor points.").defineInRange("armor", 4.0, 0.0, 100.0);
            this.KNOCKBACK_RESISTANCE = builder.comment("Knockback resistance (0.0-1.0). 1.0 = full.").defineInRange("knockbackResistance", 1.0, 0.0, 1.0);
            builder.pop();
            builder.comment("Bandit AI behavior parameters.").push("goals");
            builder.push("goalSelector");
            this.GOAL_MELEE_ATTACK_SPEED_MODIFIER = builder.comment("Melee attack movement speed modifier.").defineInRange("meleeAttackGoal.speedModifierDouble", 1.25, 0.1, 5.0);
            this.GOAL_LOOK_AT_PLAYER_DISTANCE = builder.comment("Look at player max distance (blocks).").defineInRange("lookAtPlayerGoal.lookDistanceFloat", 8.0, 1.0, 64.0);
            this.GOAL_WATER_AVOIDING_STROLL_SPEED_MODIFIER = builder.comment("Random stroll speed modifier (avoids water).").defineInRange("waterAvoidingRandomStrollGoal.speedModifierDouble", 1.0, 0.1, 5.0);
            builder.pop();
            builder.pop();
            builder.comment("Bandit spawn equipment settings.").push("equipment");
            builder.push("head");
            this.EQUIP_HEAD_CHANCE = builder.comment("Chance (0.0-1.0) to spawn with head armor.").defineInRange("randomChanceFloat", 0.3, 0.0, 1.0);
            this.EQUIP_HEAD_DROP_CHANCE = builder.comment("Drop chance (0.0-1.0) for head armor.").defineInRange("dropChanceFloat", 0.1, 0.0, 1.0);
            this.EQUIP_HEAD_ITEMS = builder.comment("Item IDs for head armor. E.g., [\"tfc:metal/helmet/copper\"].").defineList("randomFromList", Arrays.asList("tfc:metal/helmet/copper", "tfc:metal/helmet/bronze"), s -> s instanceof String && !((String)s).isEmpty());
            builder.push("setDamage");
            this.EQUIP_HEAD_DAMAGE_MIN = builder.comment("Min item durability (0.0-1.0).").defineInRange("minFloat", 0.1, 0.0, 1.0);
            this.EQUIP_HEAD_DAMAGE_MAX = builder.comment("Max item durability (0.0-1.0).").defineInRange("maxFloat", 0.4, 0.0, 1.0);
            builder.pop();
            builder.pop();
            builder.push("chest");
            this.EQUIP_CHEST_CHANCE = builder.comment("Chance to spawn with chest armor.").defineInRange("randomChanceFloat", 0.2, 0.0, 1.0);
            this.EQUIP_CHEST_DROP_CHANCE = builder.comment("Drop chance for chest armor.").defineInRange("dropChanceFloat", 0.1, 0.0, 1.0);
            this.EQUIP_CHEST_ITEMS = builder.comment("Item IDs for chest armor.").defineList("randomFromList", Arrays.asList("tfc:metal/chestplate/copper", "tfc:metal/chestplate/bronze"), s -> s instanceof String && !((String)s).isEmpty());
            builder.push("setDamage");
            this.EQUIP_CHEST_DAMAGE_MIN = builder.comment("Min item durability.").defineInRange("minFloat", 0.1, 0.0, 1.0);
            this.EQUIP_CHEST_DAMAGE_MAX = builder.comment("Max item durability.").defineInRange("maxFloat", 0.4, 0.0, 1.0);
            builder.pop();
            builder.pop();
            builder.push("legs");
            this.EQUIP_LEGS_CHANCE = builder.comment("Chance to spawn with leg armor.").defineInRange("randomChanceFloat", 0.2, 0.0, 1.0);
            this.EQUIP_LEGS_DROP_CHANCE = builder.comment("Drop chance for leg armor.").defineInRange("dropChanceFloat", 0.1, 0.0, 1.0);
            this.EQUIP_LEGS_ITEMS = builder.comment("Item IDs for leg armor.").defineList("randomFromList", Arrays.asList("tfc:metal/greaves/copper", "tfc:metal/greaves/bronze"), s -> s instanceof String && !((String)s).isEmpty());
            builder.push("setDamage");
            this.EQUIP_LEGS_DAMAGE_MIN = builder.comment("Min item durability.").defineInRange("minFloat", 0.1, 0.0, 1.0);
            this.EQUIP_LEGS_DAMAGE_MAX = builder.comment("Max item durability.").defineInRange("maxFloat", 0.4, 0.0, 1.0);
            builder.pop();
            builder.pop();
            builder.push("feet");
            this.EQUIP_FEET_CHANCE = builder.comment("Chance to spawn with feet armor.").defineInRange("randomChanceFloat", 0.3, 0.0, 1.0);
            this.EQUIP_FEET_DROP_CHANCE = builder.comment("Drop chance for feet armor.").defineInRange("dropChanceFloat", 0.1, 0.0, 1.0);
            this.EQUIP_FEET_ITEMS = builder.comment("Item IDs for feet armor.").defineList("randomFromList", Arrays.asList("tfc:metal/boots/copper", "tfc:metal/boots/bronze"), s -> s instanceof String && !((String)s).isEmpty());
            builder.push("setDamage");
            this.EQUIP_FEET_DAMAGE_MIN = builder.comment("Min item durability.").defineInRange("minFloat", 0.1, 0.0, 1.0);
            this.EQUIP_FEET_DAMAGE_MAX = builder.comment("Max item durability.").defineInRange("maxFloat", 0.4, 0.0, 1.0);
            builder.pop();
            builder.pop();
            builder.push("mainHand");
            this.EQUIP_MAINHAND_CHANCE = builder.comment("Chance to spawn with main hand weapon.").defineInRange("randomChanceFloat", 0.8, 0.0, 1.0);
            this.EQUIP_MAINHAND_DROP_CHANCE = builder.comment("Drop chance for main hand weapon.").defineInRange("dropChanceFloat", 0.1, 0.0, 1.0);
            this.EQUIP_MAINHAND_ITEMS = builder.comment("Item IDs for main hand weapon.").defineList("randomFromList", Arrays.asList("tfc:metal/sword/copper", "tfc:metal/mace/copper", "tfc:metal/sword/bronze", "tfc:metal/mace/bronze"), s -> s instanceof String && !((String)s).isEmpty());
            builder.push("setDamage");
            this.EQUIP_MAINHAND_DAMAGE_MIN = builder.comment("Min item durability.").defineInRange("minFloat", 0.05, 0.0, 1.0);
            this.EQUIP_MAINHAND_DAMAGE_MAX = builder.comment("Max item durability.").defineInRange("maxFloat", 0.25, 0.0, 1.0);
            builder.pop();
            builder.pop();
            builder.push("offhand");
            this.EQUIP_OFFHAND_DROP_CHANCE = builder.comment("Drop chance for offhand item.").defineInRange("dropChanceFloat", 0.0, 0.0, 1.0);
            this.EQUIP_OFFHAND_ITEM = builder.comment("Item ID for offhand.").define("item", (Object)"minecraft:torch", s -> s instanceof String && !((String)s).isEmpty());
            builder.push("conditions").push("level");
            this.EQUIP_OFFHAND_CONDITION_IS_NIGHT = builder.comment("Equip offhand item only at night?").define("isNight", true);
            builder.pop(2);
            builder.pop();
            builder.pop();
            builder.comment("Bandit natural spawn settings.").push("spawning");
            this.SPAWN_WEIGHT = builder.comment("Spawn weight. Higher values mean more common. 0 to disable natural spawn. Vanilla Zombie is ~100.").defineInRange("spawnWeight", 100, 0, 500);
            this.SPAWN_MIN_GROUP_SIZE = builder.comment("Minimum number of bandits spawning in a group.").defineInRange("minGroupSize", 1, 1, 5);
            this.SPAWN_MAX_GROUP_SIZE = builder.comment("Maximum number of bandits spawning in a group.").defineInRange("maxGroupSize", 2, 1, 10);
            builder.pop();
            builder.pop();
        }
    }
}

