/*
 * Decompiled with CFR 0.152.
 */
package net.bojarsky.bojarskythings.block;

import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.bojarsky.bojarskythings.blockentity.ModGrindstoneBlockEntity;
import net.bojarsky.bojarskythings.enchantment.ModEnchantments;
import net.bojarsky.bojarskythings.items.ModItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.TridentItem;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.registries.ForgeRegistries;

public class ModGrindstoneBlock
extends BaseEntityBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final EnumProperty<AttachFace> FACE = BlockStateProperties.f_61376_;
    public static final UUID SHARPENED_ATTACK_DAMAGE_MODIFIER_UUID = UUID.fromString("b88fad19-750f-424b-b181-9c12c74fc0e1");
    private static final String SHARPENED_MODIFIER_NAME = "bojarskythings.sharpened_bonus";
    public static final String NBT_KEY_SHARPEN_LEVEL = "BojarskySharpenLevel";
    public static final String NBT_KEY_SHARPEN_COOLDOWN = "BojarskySharpenCooldownExpires";
    private static final int MAX_SHARPEN_LEVEL = 9;
    public static final double DAMAGE_BONUS_FACTOR = 0.1;
    private static final double BASE_HAND_DAMAGE = 1.0;
    private static final int HIDE_ENCHANTMENTS_FLAG = 1;
    private static final int HIDE_ATTRIBUTES_FLAG = 2;
    private static final int HIDE_ALL_EXTRA_TOOLTIP = 3;
    private static final int SHARPEN_COOLDOWN_TICKS = 60;
    private static final Map<Supplier<? extends Item>, Set<ResourceLocation>> STONE_TIER_ALLOWED_ITEMS_MAP = new HashMap<Supplier<? extends Item>, Set<ResourceLocation>>();

    public ModGrindstoneBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_(FACE, (Comparable)AttachFace.FLOOR));
    }

    private static Set<ResourceLocation> getAllowedItemsForStone(Item stoneItem) {
        for (Map.Entry<Supplier<? extends Item>, Set<ResourceLocation>> entry : STONE_TIER_ALLOWED_ITEMS_MAP.entrySet()) {
            if (entry.getKey().get() != stoneItem) continue;
            return entry.getValue();
        }
        return Collections.emptySet();
    }

    private static boolean isItemPotentiallySharpenable(ItemStack stack) {
        if (stack.m_41619_()) {
            return false;
        }
        ResourceLocation itemId = ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_());
        if (itemId == null) {
            return false;
        }
        for (Set<ResourceLocation> allowedSet : STONE_TIER_ALLOWED_ITEMS_MAP.values()) {
            if (!allowedSet.contains(itemId)) continue;
            return true;
        }
        return false;
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (world.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity blockEntity = world.m_7702_(pos);
        if (!(blockEntity instanceof ModGrindstoneBlockEntity)) {
            return InteractionResult.PASS;
        }
        ModGrindstoneBlockEntity grindstoneEntity = (ModGrindstoneBlockEntity)blockEntity;
        boolean hasStone = grindstoneEntity.hasStoneInSlot();
        ItemStack heldItem = player.m_21120_(hand);
        if (!hasStone) {
            NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)grindstoneEntity, (BlockPos)pos);
            return InteractionResult.CONSUME;
        }
        if (ModGrindstoneBlock.isItemPotentiallySharpenable(heldItem)) {
            return this.trySharpenWeapon(world, pos, player, heldItem, grindstoneEntity);
        }
        NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)grindstoneEntity, (BlockPos)pos);
        return InteractionResult.CONSUME;
    }

    private InteractionResult trySharpenWeapon(Level world, BlockPos pos, Player player, ItemStack weapon, ModGrindstoneBlockEntity grindstone) {
        float successChance;
        long cooldownExpires;
        ItemStack stoneInSlot = grindstone.getStoneInSlot();
        Item stoneItem = stoneInSlot.m_41720_();
        ResourceLocation weaponId = ForgeRegistries.ITEMS.getKey((Object)weapon.m_41720_());
        Set<ResourceLocation> allowedItemsForThisStone = ModGrindstoneBlock.getAllowedItemsForStone(stoneItem);
        if (weaponId == null || allowedItemsForThisStone.isEmpty() || !allowedItemsForThisStone.contains(weaponId)) {
            player.m_5661_((Component)Component.m_237110_((String)"message.bojarskythings.sharpening.wrong_stone", (Object[])new Object[]{stoneInSlot.m_41786_()}), false);
            return InteractionResult.FAIL;
        }
        long currentTime = world.m_46467_();
        if (weapon.m_41782_() && weapon.m_41783_().m_128441_(NBT_KEY_SHARPEN_COOLDOWN) && currentTime < (cooldownExpires = weapon.m_41783_().m_128454_(NBT_KEY_SHARPEN_COOLDOWN))) {
            long remainingTicks = cooldownExpires - currentTime;
            int remainingSeconds = (int)(remainingTicks / 20L) + 1;
            player.m_5661_((Component)Component.m_237110_((String)"message.bojarskythings.sharpening.cooldown", (Object[])new Object[]{remainingSeconds}), false);
            return InteractionResult.FAIL;
        }
        int currentLevel = weapon.m_41784_().m_128451_(NBT_KEY_SHARPEN_LEVEL);
        if (currentLevel >= 9) {
            player.m_5661_((Component)Component.m_237115_((String)"message.bojarskythings.sharpening.max_level"), false);
            return InteractionResult.FAIL;
        }
        world.m_5594_(null, pos, SoundEvents.f_11998_, SoundSource.BLOCKS, 1.0f, 1.0f);
        if (stoneItem == ModItems.SHARPENING_STONE_1.get()) {
            successChance = 0.6f;
        } else if (stoneItem == ModItems.SHARPENING_STONE_2.get()) {
            successChance = 0.55f;
        } else if (stoneItem == ModItems.SHARPENING_STONE_3.get()) {
            successChance = 0.5f;
        } else {
            System.err.println("Unknown sharpening stone used in trySharpenWeapon: " + stoneItem);
            successChance = 0.0f;
        }
        RandomSource random = player.m_217043_();
        if (random.m_188501_() < successChance) {
            int newLevel = currentLevel + 1;
            CompoundTag tag = weapon.m_41784_();
            tag.m_128405_(NBT_KEY_SHARPEN_LEVEL, newLevel);
            double weaponBaseDamage = this.getBaseWeaponDamage(weapon.m_41720_());
            double bonusCalculationBase = weaponBaseDamage + 1.0;
            double bonusDamage = bonusCalculationBase * (double)newLevel * 0.1;
            double modifierAmount = weaponBaseDamage + bonusDamage;
            modifierAmount = (double)Math.round(modifierAmount * 10.0) / 10.0;
            this.removeOurAttackDamageModifier(weapon);
            this.addOrUpdateDamageModifierPreservingSpeed(weapon, modifierAmount, AttributeModifier.Operation.ADDITION);
            if (EnchantmentHelper.m_44843_((Enchantment)((Enchantment)ModEnchantments.SHARPENED.get()), (ItemStack)weapon) <= 0) {
                weapon.m_41663_((Enchantment)ModEnchantments.SHARPENED.get(), 1);
            }
            int currentHideFlags = tag.m_128451_("HideFlags");
            tag.m_128405_("HideFlags", currentHideFlags | 3);
            long expirationTime = currentTime + 60L;
            tag.m_128356_(NBT_KEY_SHARPEN_COOLDOWN, expirationTime);
            player.m_5661_((Component)Component.m_237110_((String)"message.bojarskythings.sharpening.upgraded", (Object[])new Object[]{newLevel}), false);
            world.m_5594_(null, pos, SoundEvents.f_12275_, SoundSource.BLOCKS, 0.8f, 1.0f);
            this.spawnParticles(world, pos, random);
            grindstone.consumeStoneFromSlot();
        } else {
            this.handleSharpeningFailure(world, pos, player, weapon, random, grindstone);
        }
        return InteractionResult.SUCCESS;
    }

    private void handleSharpeningFailure(Level world, BlockPos pos, Player player, ItemStack weapon, RandomSource random, ModGrindstoneBlockEntity grindstone) {
        this.removeOurAttackDamageModifier(weapon);
        if (weapon.m_41782_()) {
            CompoundTag tag = weapon.m_41783_();
            tag.m_128473_(NBT_KEY_SHARPEN_LEVEL);
            tag.m_128473_(NBT_KEY_SHARPEN_COOLDOWN);
            Map enchantments = EnchantmentHelper.m_44831_((ItemStack)weapon);
            enchantments.remove(ModEnchantments.SHARPENED.get());
            EnchantmentHelper.m_44865_((Map)enchantments, (ItemStack)weapon);
            if (tag.m_128441_("HideFlags")) {
                int currentHideFlags = tag.m_128451_("HideFlags");
                int newHideFlags = currentHideFlags & 0xFFFFFFFC;
                if (newHideFlags != 0) {
                    tag.m_128405_("HideFlags", newHideFlags);
                } else {
                    tag.m_128473_("HideFlags");
                }
            }
            if (tag.m_128456_()) {
                weapon.m_41751_(null);
            }
        }
        weapon.m_41774_(1);
        player.m_5661_((Component)Component.m_237115_((String)"message.bojarskythings.sharpening.fail_break"), false);
        world.m_5594_(null, pos, SoundEvents.f_12018_, SoundSource.BLOCKS, 1.0f, 1.0f);
        this.spawnBreakParticles(world, pos, random);
        grindstone.consumeStoneFromSlot();
    }

    private double getBaseWeaponDamage(Item item) {
        AttributeModifier modifier;
        if (item instanceof SwordItem) {
            SwordItem sword = (SwordItem)item;
            return sword.m_43299_();
        }
        if (item instanceof AxeItem) {
            AxeItem axe = (AxeItem)item;
            return axe.m_41008_();
        }
        if (item instanceof TridentItem) {
            return 8.0;
        }
        Multimap defaultModifiers = item.m_7167_(EquipmentSlot.MAINHAND);
        Collection damageModifiers = defaultModifiers.get((Object)Attributes.f_22281_);
        if (!damageModifiers.isEmpty() && (modifier = (AttributeModifier)damageModifiers.iterator().next()).m_22217_() == AttributeModifier.Operation.ADDITION) {
            return modifier.m_22218_();
        }
        return 0.0;
    }

    private void addOrUpdateDamageModifierPreservingSpeed(ItemStack stack, double damageAmount, AttributeModifier.Operation damageOperation) {
        Item item = stack.m_41720_();
        CompoundTag tag = stack.m_41784_();
        ListTag currentModifiersList = tag.m_128425_("AttributeModifiers", 9) ? tag.m_128437_("AttributeModifiers", 10) : new ListTag();
        AttributeModifier defaultSpeedModifier = null;
        Multimap defaultItemModifiers = item.m_7167_(EquipmentSlot.MAINHAND);
        Collection speedModifiers = defaultItemModifiers.get((Object)Attributes.f_22283_);
        if (!speedModifiers.isEmpty()) {
            defaultSpeedModifier = (AttributeModifier)speedModifiers.iterator().next();
        }
        ListTag newModifiersList = new ListTag();
        CompoundTag damageModifierTag = new CompoundTag();
        damageModifierTag.m_128359_("AttributeName", ForgeRegistries.ATTRIBUTES.getKey((Object)Attributes.f_22281_).toString());
        damageModifierTag.m_128359_("Name", SHARPENED_MODIFIER_NAME);
        damageModifierTag.m_128347_("Amount", damageAmount);
        damageModifierTag.m_128405_("Operation", damageOperation.ordinal());
        damageModifierTag.m_128362_("UUID", SHARPENED_ATTACK_DAMAGE_MODIFIER_UUID);
        damageModifierTag.m_128359_("Slot", EquipmentSlot.MAINHAND.m_20751_());
        newModifiersList.add((Object)damageModifierTag);
        if (defaultSpeedModifier != null) {
            CompoundTag speedModifierTag = new CompoundTag();
            speedModifierTag.m_128359_("AttributeName", ForgeRegistries.ATTRIBUTES.getKey((Object)Attributes.f_22283_).toString());
            speedModifierTag.m_128359_("Name", defaultSpeedModifier.m_22214_());
            speedModifierTag.m_128347_("Amount", defaultSpeedModifier.m_22218_());
            speedModifierTag.m_128405_("Operation", defaultSpeedModifier.m_22217_().ordinal());
            speedModifierTag.m_128362_("UUID", defaultSpeedModifier.m_22209_());
            speedModifierTag.m_128359_("Slot", EquipmentSlot.MAINHAND.m_20751_());
            newModifiersList.add((Object)speedModifierTag);
        }
        for (Tag nbtBase : currentModifiersList) {
            boolean isDefaultSpeedMod;
            CompoundTag existingModTag;
            if (!(nbtBase instanceof CompoundTag) || !(existingModTag = (CompoundTag)nbtBase).m_128441_("UUID")) continue;
            UUID uuid = existingModTag.m_128342_("UUID");
            boolean isOurDamageMod = uuid.equals(SHARPENED_ATTACK_DAMAGE_MODIFIER_UUID);
            boolean bl = isDefaultSpeedMod = defaultSpeedModifier != null && uuid.equals(defaultSpeedModifier.m_22209_());
            if (isOurDamageMod || isDefaultSpeedMod) continue;
            newModifiersList.add((Object)existingModTag.m_6426_());
        }
        tag.m_128365_("AttributeModifiers", (Tag)newModifiersList);
    }

    private void removeOurAttackDamageModifier(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag == null || !tag.m_128425_("AttributeModifiers", 9)) {
            return;
        }
        ListTag modifiersList = tag.m_128437_("AttributeModifiers", 10);
        ListTag updatedList = new ListTag();
        boolean removed = false;
        for (int i = 0; i < modifiersList.size(); ++i) {
            CompoundTag modifierTag = modifiersList.m_128728_(i);
            if (modifierTag.m_128441_("UUID") && SHARPENED_ATTACK_DAMAGE_MODIFIER_UUID.equals(modifierTag.m_128342_("UUID"))) {
                removed = true;
                continue;
            }
            updatedList.add((Object)modifierTag);
        }
        if (removed) {
            if (updatedList.isEmpty()) {
                tag.m_128473_("AttributeModifiers");
                if (tag.m_128456_()) {
                    stack.m_41751_(null);
                }
            } else {
                tag.m_128365_("AttributeModifiers", (Tag)updatedList);
            }
        }
    }

    private void spawnParticles(Level world, BlockPos pos, RandomSource random) {
        for (int i = 0; i < 5 + random.m_188503_(5); ++i) {
            world.m_7106_((ParticleOptions)ParticleTypes.f_123809_, (double)pos.m_123341_() + 0.5 + (random.m_188500_() - 0.5) * 0.8, (double)pos.m_123342_() + 1.1, (double)pos.m_123343_() + 0.5 + (random.m_188500_() - 0.5) * 0.8, (random.m_188500_() - 0.5) * 0.1, 0.1 + random.m_188500_() * 0.1, (random.m_188500_() - 0.5) * 0.1);
        }
    }

    private void spawnBreakParticles(Level world, BlockPos pos, RandomSource random) {
        for (int i = 0; i < 8 + random.m_188503_(6); ++i) {
            world.m_7106_((ParticleOptions)ParticleTypes.f_123762_, (double)pos.m_123341_() + 0.5 + (random.m_188500_() - 0.5) * 0.6, (double)pos.m_123342_() + 0.8, (double)pos.m_123343_() + 0.5 + (random.m_188500_() - 0.5) * 0.6, (random.m_188500_() - 0.5) * 0.05, 0.05 + random.m_188500_() * 0.05, (random.m_188500_() - 0.5) * 0.05);
        }
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        for (Direction direction : context.m_6232_()) {
            BlockState blockstate = direction.m_122434_() == Direction.Axis.Y ? (BlockState)((BlockState)this.m_49966_().m_61124_(FACE, (Comparable)(direction == Direction.UP ? AttachFace.CEILING : AttachFace.FLOOR))).m_61124_((Property)FACING, (Comparable)context.m_8125_()) : (BlockState)((BlockState)this.m_49966_().m_61124_(FACE, (Comparable)AttachFace.WALL)).m_61124_((Property)FACING, (Comparable)direction.m_122424_());
            if (!blockstate.m_60710_((LevelReader)context.m_43725_(), context.m_8083_())) continue;
            return blockstate;
        }
        return null;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return Blocks.f_50623_.m_5940_(state, world, pos, context);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, FACE});
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new ModGrindstoneBlockEntity(pos, state);
    }

    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.m_60713_(newState.m_60734_())) {
            BlockEntity blockEntity = world.m_7702_(pos);
            if (blockEntity instanceof ModGrindstoneBlockEntity) {
                ModGrindstoneBlockEntity grindstoneEntity = (ModGrindstoneBlockEntity)blockEntity;
                grindstoneEntity.dropContents(world, pos);
                world.m_46717_(pos, (Block)this);
            }
            super.m_6810_(state, world, pos, newState, isMoving);
        }
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState state, Level world, BlockPos pos) {
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof ModGrindstoneBlockEntity) {
            ModGrindstoneBlockEntity grindstoneEntity = (ModGrindstoneBlockEntity)blockEntity;
            return grindstoneEntity.hasStoneInSlot() ? 15 : 0;
        }
        return 0;
    }

    static {
        HashSet<ResourceLocation> tier1Items = new HashSet<ResourceLocation>();
        tier1Items.add(new ResourceLocation("tfc", "metal/sword/copper"));
        tier1Items.add(new ResourceLocation("tfc", "metal/mace/copper"));
        tier1Items.add(new ResourceLocation("tfc", "metal/sword/bronze"));
        tier1Items.add(new ResourceLocation("tfc", "metal/mace/bronze"));
        tier1Items.add(new ResourceLocation("tfc", "metal/sword/black_bronze"));
        tier1Items.add(new ResourceLocation("tfc", "metal/mace/black_bronze"));
        tier1Items.add(new ResourceLocation("tfc", "metal/sword/bismuth_bronze"));
        tier1Items.add(new ResourceLocation("tfc", "metal/mace/bismuth_bronze"));
        STONE_TIER_ALLOWED_ITEMS_MAP.put((Supplier<? extends Item>)ModItems.SHARPENING_STONE_1, (Set<ResourceLocation>)tier1Items);
        HashSet<ResourceLocation> tier2Items = new HashSet<ResourceLocation>();
        tier2Items.add(new ResourceLocation("tfc", "metal/sword/wrought_iron"));
        tier2Items.add(new ResourceLocation("tfc", "metal/mace/wrought_iron"));
        tier2Items.add(new ResourceLocation("tfc", "metal/sword/steel"));
        tier2Items.add(new ResourceLocation("tfc", "metal/mace/steel"));
        tier2Items.add(new ResourceLocation("tfc", "metal/sword/black_steel"));
        tier2Items.add(new ResourceLocation("tfc", "metal/mace/black_steel"));
        STONE_TIER_ALLOWED_ITEMS_MAP.put((Supplier<? extends Item>)ModItems.SHARPENING_STONE_2, (Set<ResourceLocation>)tier2Items);
        HashSet<ResourceLocation> tier3Items = new HashSet<ResourceLocation>();
        tier3Items.add(new ResourceLocation("tfc", "metal/sword/red_steel"));
        tier3Items.add(new ResourceLocation("tfc", "metal/mace/red_steel"));
        tier3Items.add(new ResourceLocation("tfc", "metal/sword/blue_steel"));
        tier3Items.add(new ResourceLocation("tfc", "metal/mace/blue_steel"));
        STONE_TIER_ALLOWED_ITEMS_MAP.put((Supplier<? extends Item>)ModItems.SHARPENING_STONE_3, (Set<ResourceLocation>)tier3Items);
    }
}

