/*
 * Decompiled with CFR 0.152.
 */
package net.bojarsky.bojarskythings;

import com.mojang.logging.LogUtils;
import java.io.File;
import net.bojarsky.bojarskythings.block.ModBlocks;
import net.bojarsky.bojarskythings.blockentity.ModBlockEntities;
import net.bojarsky.bojarskythings.config.MobConfig;
import net.bojarsky.bojarskythings.effects.ModEffects;
import net.bojarsky.bojarskythings.enchantment.ModEnchantments;
import net.bojarsky.bojarskythings.entity.ModEntities;
import net.bojarsky.bojarskythings.event.ModBusEvents;
import net.bojarsky.bojarskythings.items.ModCreativeTabs;
import net.bojarsky.bojarskythings.items.ModItems;
import net.bojarsky.bojarskythings.screen.ModMenuTypes;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import org.slf4j.Logger;

@Mod(value="bojarskythings")
public class BojarskyThings {
    public static final String MOD_ID = "bojarskythings";
    private static final Logger LOGGER = LogUtils.getLogger();

    public BojarskyThings() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::commonSetup);
        ModEffects.register();
        ModEntities.register(modEventBus);
        ModCreativeTabs.register(modEventBus);
        ModItems.register(modEventBus);
        ModBlocks.register(modEventBus);
        ModBlockEntities.register(modEventBus);
        ModEnchantments.ENCHANTMENTS.register(modEventBus);
        ModMenuTypes.register(modEventBus);
        ModBusEvents.BIOME_MODIFIERS.register(modEventBus);
        MinecraftForge.EVENT_BUS.register((Object)this);
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)MobConfig.SERVER_SPEC);
        LOGGER.info("BojarskyThings Mod Initializing...");
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        BojarskyThings.getLogger().info("!!! BOJARSKYTHINGS ENABLED - Common Setup !!!");
    }

    public static File getModConfigDirectory() {
        File configPath = FMLPaths.CONFIGDIR.get().toFile();
        File modConfigDir = new File(configPath, MOD_ID);
        if (!modConfigDir.exists()) {
            if (!modConfigDir.mkdirs()) {
                LOGGER.error("Could not create {} config directory: {}", (Object)MOD_ID, (Object)modConfigDir.getAbsolutePath());
            } else {
                LOGGER.info("Created {} config directory: {}", (Object)MOD_ID, (Object)modConfigDir.getAbsolutePath());
            }
        }
        return modConfigDir;
    }

    public static Logger getLogger() {
        return LOGGER;
    }
}

