/*
 * Decompiled with CFR 0.152.
 */
package net.bojarsky.bojarskyauthclient.libs.oshi.util;

import java.util.Map;
import java.util.Properties;
import net.bojarsky.bojarskyauthclient.libs.oshi.annotation.concurrent.NotThreadSafe;
import net.bojarsky.bojarskyauthclient.libs.oshi.util.FileUtil;
import net.bojarsky.bojarskyauthclient.libs.oshi.util.ParseUtil;

@NotThreadSafe
public final class GlobalConfig {
    private static final String OSHI_PROPERTIES = "net.bojarsky.bojarskyauthclient.libs.oshi.properties";
    private static final Properties CONFIG = FileUtil.readPropertiesFromFilename("net.bojarsky.bojarskyauthclient.libs.oshi.properties");
    public static final String OSHI_UTIL_MEMOIZER_EXPIRATION = "net.bojarsky.bojarskyauthclient.libs.oshi.util.memoizer.expiration";
    public static final String OSHI_UTIL_WMI_TIMEOUT = "net.bojarsky.bojarskyauthclient.libs.oshi.util.wmi.timeout";
    public static final String OSHI_UTIL_PROC_PATH = "net.bojarsky.bojarskyauthclient.libs.oshi.util.proc.path";
    public static final String OSHI_UTIL_SYS_PATH = "net.bojarsky.bojarskyauthclient.libs.oshi.util.sys.path";
    public static final String OSHI_UTIL_DEV_PATH = "net.bojarsky.bojarskyauthclient.libs.oshi.util.dev.path";
    public static final String OSHI_PSEUDO_FILESYSTEM_TYPES = "net.bojarsky.bojarskyauthclient.libs.oshi.pseudo.filesystem.types";
    public static final String OSHI_NETWORK_FILESYSTEM_TYPES = "net.bojarsky.bojarskyauthclient.libs.oshi.network.filesystem.types";
    public static final String OSHI_OS_LINUX_ALLOWUDEV = "net.bojarsky.bojarskyauthclient.libs.oshi.os.linux.allowudev";
    public static final String OSHI_OS_LINUX_PROCFS_LOGWARNING = "net.bojarsky.bojarskyauthclient.libs.oshi.os.linux.procfs.logwarning";
    public static final String OSHI_OS_MAC_SYSCTL_LOGWARNING = "net.bojarsky.bojarskyauthclient.libs.oshi.os.mac.sysctl.logwarning";
    public static final String OSHI_OS_WINDOWS_EVENTLOG = "net.bojarsky.bojarskyauthclient.libs.oshi.os.windows.eventlog";
    public static final String OSHI_OS_WINDOWS_PROCSTATE_SUSPENDED = "net.bojarsky.bojarskyauthclient.libs.oshi.os.windows.procstate.suspended";
    public static final String OSHI_OS_WINDOWS_COMMANDLINE_BATCH = "net.bojarsky.bojarskyauthclient.libs.oshi.os.windows.commandline.batch";
    public static final String OSHI_OS_WINDOWS_HKEYPERFDATA = "net.bojarsky.bojarskyauthclient.libs.oshi.os.windows.hkeyperfdata";
    public static final String OSHI_OS_WINDOWS_LOADAVERAGE = "net.bojarsky.bojarskyauthclient.libs.oshi.os.windows.loadaverage";
    public static final String OSHI_OS_WINDOWS_CPU_UTILITY = "net.bojarsky.bojarskyauthclient.libs.oshi.os.windows.cpu.utility";
    public static final String OSHI_OS_WINDOWS_PERFDISK_DIABLED = "net.bojarsky.bojarskyauthclient.libs.oshi.os.windows.perfdisk.disabled";
    public static final String OSHI_OS_WINDOWS_PERFOS_DIABLED = "net.bojarsky.bojarskyauthclient.libs.oshi.os.windows.perfos.disabled";
    public static final String OSHI_OS_WINDOWS_PERFPROC_DIABLED = "net.bojarsky.bojarskyauthclient.libs.oshi.os.windows.perfproc.disabled";
    public static final String OSHI_OS_UNIX_WHOCOMMAND = "net.bojarsky.bojarskyauthclient.libs.oshi.os.unix.whoCommand";
    public static final String OSHI_OS_SOLARIS_ALLOWKSTAT2 = "net.bojarsky.bojarskyauthclient.libs.oshi.os.solaris.allowKstat2";

    private GlobalConfig() {
    }

    public static String get(String key) {
        return CONFIG.getProperty(key);
    }

    public static String get(String key, String def) {
        return CONFIG.getProperty(key, def);
    }

    public static int get(String key, int def) {
        String value = CONFIG.getProperty(key);
        return value == null ? def : ParseUtil.parseIntOrDefault(value, def);
    }

    public static double get(String key, double def) {
        String value = CONFIG.getProperty(key);
        return value == null ? def : ParseUtil.parseDoubleOrDefault(value, def);
    }

    public static boolean get(String key, boolean def) {
        String value = CONFIG.getProperty(key);
        return value == null ? def : Boolean.parseBoolean(value);
    }

    public static void set(String key, Object val) {
        if (val == null) {
            CONFIG.remove(key);
        } else {
            CONFIG.setProperty(key, val.toString());
        }
    }

    public static void remove(String key) {
        CONFIG.remove(key);
    }

    public static void clear() {
        CONFIG.clear();
    }

    public static void load(Properties properties) {
        CONFIG.putAll((Map<?, ?>)properties);
    }

    public static class PropertyException
    extends RuntimeException {
        private static final long serialVersionUID = -7482581936621748005L;

        public PropertyException(String property) {
            super("Invalid property: \"" + property + "\" = " + GlobalConfig.get(property, null));
        }

        public PropertyException(String property, String message) {
            super("Invalid property \"" + property + "\": " + message);
        }
    }
}

