/*
 * Decompiled with CFR 0.152.
 */
package net.bojarsky.bojarskyauthclient.libs.oshi.software.os.unix.solaris;

import net.bojarsky.bojarskyauthclient.libs.jna.Native;
import net.bojarsky.bojarskyauthclient.libs.oshi.annotation.concurrent.ThreadSafe;
import net.bojarsky.bojarskyauthclient.libs.oshi.jna.platform.unix.SolarisLibc;
import net.bojarsky.bojarskyauthclient.libs.oshi.software.common.AbstractNetworkParams;
import net.bojarsky.bojarskyauthclient.libs.oshi.util.ExecutingCommand;

@ThreadSafe
final class SolarisNetworkParams
extends AbstractNetworkParams {
    private static final SolarisLibc LIBC = SolarisLibc.INSTANCE;

    SolarisNetworkParams() {
    }

    @Override
    public String getHostName() {
        byte[] hostnameBuffer = new byte[256];
        if (0 != LIBC.gethostname(hostnameBuffer, hostnameBuffer.length)) {
            return super.getHostName();
        }
        return Native.toString(hostnameBuffer);
    }

    @Override
    public String getIpv4DefaultGateway() {
        return SolarisNetworkParams.searchGateway(ExecutingCommand.runNative("route get -inet default"));
    }

    @Override
    public String getIpv6DefaultGateway() {
        return SolarisNetworkParams.searchGateway(ExecutingCommand.runNative("route get -inet6 default"));
    }
}

