/*
 * Decompiled with CFR 0.152.
 */
package net.bojarsky.bojarskyauthclient.libs.oshi.hardware.platform.unix.aix;

import java.util.List;
import java.util.function.Supplier;
import net.bojarsky.bojarskyauthclient.libs.jna.platform.unix.aix.Perfstat;
import net.bojarsky.bojarskyauthclient.libs.oshi.annotation.concurrent.ThreadSafe;
import net.bojarsky.bojarskyauthclient.libs.oshi.driver.unix.aix.Lscfg;
import net.bojarsky.bojarskyauthclient.libs.oshi.driver.unix.aix.perfstat.PerfstatDisk;
import net.bojarsky.bojarskyauthclient.libs.oshi.hardware.CentralProcessor;
import net.bojarsky.bojarskyauthclient.libs.oshi.hardware.ComputerSystem;
import net.bojarsky.bojarskyauthclient.libs.oshi.hardware.Display;
import net.bojarsky.bojarskyauthclient.libs.oshi.hardware.GlobalMemory;
import net.bojarsky.bojarskyauthclient.libs.oshi.hardware.GraphicsCard;
import net.bojarsky.bojarskyauthclient.libs.oshi.hardware.HWDiskStore;
import net.bojarsky.bojarskyauthclient.libs.oshi.hardware.NetworkIF;
import net.bojarsky.bojarskyauthclient.libs.oshi.hardware.PowerSource;
import net.bojarsky.bojarskyauthclient.libs.oshi.hardware.Sensors;
import net.bojarsky.bojarskyauthclient.libs.oshi.hardware.SoundCard;
import net.bojarsky.bojarskyauthclient.libs.oshi.hardware.UsbDevice;
import net.bojarsky.bojarskyauthclient.libs.oshi.hardware.common.AbstractHardwareAbstractionLayer;
import net.bojarsky.bojarskyauthclient.libs.oshi.hardware.platform.unix.UnixDisplay;
import net.bojarsky.bojarskyauthclient.libs.oshi.hardware.platform.unix.aix.AixCentralProcessor;
import net.bojarsky.bojarskyauthclient.libs.oshi.hardware.platform.unix.aix.AixComputerSystem;
import net.bojarsky.bojarskyauthclient.libs.oshi.hardware.platform.unix.aix.AixGlobalMemory;
import net.bojarsky.bojarskyauthclient.libs.oshi.hardware.platform.unix.aix.AixGraphicsCard;
import net.bojarsky.bojarskyauthclient.libs.oshi.hardware.platform.unix.aix.AixHWDiskStore;
import net.bojarsky.bojarskyauthclient.libs.oshi.hardware.platform.unix.aix.AixNetworkIF;
import net.bojarsky.bojarskyauthclient.libs.oshi.hardware.platform.unix.aix.AixPowerSource;
import net.bojarsky.bojarskyauthclient.libs.oshi.hardware.platform.unix.aix.AixSensors;
import net.bojarsky.bojarskyauthclient.libs.oshi.hardware.platform.unix.aix.AixSoundCard;
import net.bojarsky.bojarskyauthclient.libs.oshi.hardware.platform.unix.aix.AixUsbDevice;
import net.bojarsky.bojarskyauthclient.libs.oshi.util.Memoizer;

@ThreadSafe
public final class AixHardwareAbstractionLayer
extends AbstractHardwareAbstractionLayer {
    private final Supplier<List<String>> lscfg = Memoizer.memoize(Lscfg::queryAllDevices, Memoizer.defaultExpiration());
    private final Supplier<Perfstat.perfstat_disk_t[]> diskStats = Memoizer.memoize(PerfstatDisk::queryDiskStats, Memoizer.defaultExpiration());

    @Override
    public ComputerSystem createComputerSystem() {
        return new AixComputerSystem(this.lscfg);
    }

    @Override
    public GlobalMemory createMemory() {
        return new AixGlobalMemory(this.lscfg);
    }

    @Override
    public CentralProcessor createProcessor() {
        return new AixCentralProcessor();
    }

    @Override
    public Sensors createSensors() {
        return new AixSensors(this.lscfg);
    }

    @Override
    public List<PowerSource> getPowerSources() {
        return AixPowerSource.getPowerSources();
    }

    @Override
    public List<HWDiskStore> getDiskStores() {
        return AixHWDiskStore.getDisks(this.diskStats);
    }

    @Override
    public List<Display> getDisplays() {
        return UnixDisplay.getDisplays();
    }

    @Override
    public List<NetworkIF> getNetworkIFs(boolean includeLocalInterfaces) {
        return AixNetworkIF.getNetworks(includeLocalInterfaces);
    }

    @Override
    public List<UsbDevice> getUsbDevices(boolean tree) {
        return AixUsbDevice.getUsbDevices(tree, this.lscfg);
    }

    @Override
    public List<SoundCard> getSoundCards() {
        return AixSoundCard.getSoundCards(this.lscfg);
    }

    @Override
    public List<GraphicsCard> getGraphicsCards() {
        return AixGraphicsCard.getGraphicsCards(this.lscfg);
    }
}

