/*
 * Decompiled with CFR 0.152.
 */
package net.bojarsky.bojarskyauthclient.libs.oshi.driver.windows.perfmon;

import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.bojarsky.bojarskyauthclient.libs.oshi.annotation.concurrent.ThreadSafe;
import net.bojarsky.bojarskyauthclient.libs.oshi.util.platform.windows.PerfCounterWildcardQuery;
import net.bojarsky.bojarskyauthclient.libs.oshi.util.tuples.Pair;

@ThreadSafe
public final class ThreadInformation {
    private ThreadInformation() {
    }

    public static Pair<List<String>, Map<ThreadPerformanceProperty, List<Long>>> queryThreadCounters() {
        return PerfCounterWildcardQuery.queryInstancesAndValues(ThreadPerformanceProperty.class, "Thread", "Win32_PerfRawData_PerfProc_Thread WHERE NOT Name LIKE \"%_Total\"");
    }

    public static Pair<List<String>, Map<ThreadPerformanceProperty, List<Long>>> queryThreadCounters(String name, int threadNum) {
        String procName = name.toLowerCase(Locale.ROOT);
        if (threadNum >= 0) {
            return PerfCounterWildcardQuery.queryInstancesAndValues(ThreadPerformanceProperty.class, "Thread", "Win32_PerfRawData_PerfProc_Thread WHERE Name LIKE \\\"" + procName + "\\\" AND IDThread=" + threadNum, procName + "/" + threadNum);
        }
        return PerfCounterWildcardQuery.queryInstancesAndValues(ThreadPerformanceProperty.class, "Thread", "Win32_PerfRawData_PerfProc_Thread WHERE Name LIKE \\\"" + procName + "\\\"", procName + "/*");
    }

    public static enum ThreadPerformanceProperty implements PerfCounterWildcardQuery.PdhCounterWildcardProperty
    {
        NAME("^*_Total"),
        PERCENTUSERTIME("% User Time"),
        PERCENTPRIVILEGEDTIME("% Privileged Time"),
        ELAPSEDTIME("Elapsed Time"),
        PRIORITYCURRENT("Priority Current"),
        STARTADDRESS("Start Address"),
        THREADSTATE("Thread State"),
        THREADWAITREASON("Thread Wait Reason"),
        IDPROCESS("ID Process"),
        IDTHREAD("ID Thread"),
        CONTEXTSWITCHESPERSEC("Context Switches/sec");

        private final String counter;

        private ThreadPerformanceProperty(String counter) {
            this.counter = counter;
        }

        @Override
        public String getCounter() {
            return this.counter;
        }
    }
}

