/*
 * Decompiled with CFR 0.152.
 */
package net.bojarsky.bojarskyauthclient.client.compat;

import java.io.File;
import java.lang.instrument.Instrumentation;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oshi.SystemInfo;
import oshi.software.os.OSProcess;
import oshi.software.os.OperatingSystem;

public class SystemMetricsCollector {
    private static final Instrumentation instrumentation = SystemMetricsCollector.getInstrumentationFromAgent();
    private static final SystemInfo SI = new SystemInfo();
    private static final OperatingSystem OS = SI.getOperatingSystem();
    private static final long CURRENT_PID = OS.getProcessId();
    private static final List<String> TRUSTED_PUBLISHERS = Arrays.asList("microsoft", "oracle", "sun microsystems", "nvidia", "advanced micro devices", "intel", "realtek", "valve", "discord", "logitech", "razer", "steelseries", "obs", "overwolf", "mojang", "azul systems");
    private static final List<String> SUSPICIOUS_PATHS = Arrays.asList("downloads", "\u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0438", "temp", "tmp", "desktop", "\u0440\u0430\u0431\u043e\u0447\u0438\u0439 \u0441\u0442\u043e\u043b");
    private static Set<String> baselineModules = new HashSet<String>();
    private static Map<String, String> initialReportData = new HashMap<String, String>();
    private static Set<String> baselineClasses = new HashSet<String>();
    private static Method getModulesMethod = null;
    private static Method getPathMethod = null;
    private static Method getPublisherMethod = null;

    private static Instrumentation getInstrumentationFromAgent() {
        try {
            Class<?> agentClass = Class.forName("net.bojarsky.agent.InstrumentationAgent");
            Method getInstMethod = agentClass.getMethod("getInstrumentation", new Class[0]);
            return (Instrumentation)getInstMethod.invoke(null, new Object[0]);
        }
        catch (Exception e) {
            System.err.println("BojarskyAuth: Could not link with InstrumentationAgent. Class scanning will be disabled. Reason: " + e.getMessage());
            return null;
        }
    }

    public static void collectInitialMetrics() {
        HashMap<String, String> report = new HashMap<String, String>();
        try {
            SystemMetricsCollector.checkEnvironmentVariables(report);
            List<?> modules = SystemMetricsCollector.getProcessModules();
            if (modules != null && !modules.isEmpty()) {
                HashSet<String> modulePaths = new HashSet<String>();
                for (Object module : modules) {
                    String path = SystemMetricsCollector.getModulePath(module);
                    String publisher = SystemMetricsCollector.getModulePublisher(module);
                    modulePaths.add(path);
                    for (String string : SUSPICIOUS_PATHS) {
                        if (!path.contains(File.separator + string + File.separator)) continue;
                        report.put("Suspicious Module Path Detected", "Path: " + path);
                        break;
                    }
                    boolean isTrusted = false;
                    if (!publisher.isEmpty()) {
                        for (String trusted : TRUSTED_PUBLISHERS) {
                            if (!publisher.contains(trusted)) continue;
                            isTrusted = true;
                            break;
                        }
                    }
                    String string = System.getenv("SystemRoot");
                    if (isTrusted || string != null && path.startsWith(string.toLowerCase())) continue;
                    report.put("Untrusted Module Publisher Detected", "Path: " + path + " | Publisher: " + (publisher.isEmpty() ? "N/A" : publisher));
                }
                baselineModules = modulePaths;
            }
            if (instrumentation != null) {
                baselineClasses = SystemMetricsCollector.getLoadedClassNames();
            } else {
                report.put("Class Scan Warning", "Instrumentation unavailable. Agent not loaded.");
            }
            initialReportData = report;
        }
        catch (Throwable t) {
            report.put("Initial Metric Collection Error", t.getClass().getName() + ": " + t.getMessage());
            initialReportData = report;
        }
    }

    public static Map<String, String> collectRuntimeAnomalies() {
        HashMap<String, String> report = new HashMap<String, String>();
        try {
            SystemMetricsCollector.checkJvmArguments(report);
            SystemMetricsCollector.checkDynamicModules(report);
            SystemMetricsCollector.checkDynamicallyLoadedClasses(report);
        }
        catch (Throwable t) {
            report.put("Runtime Scan Error", t.getClass().getName() + ": " + t.getMessage());
        }
        return report;
    }

    private static Set<String> getLoadedClassNames() {
        if (instrumentation == null) {
            return Collections.emptySet();
        }
        HashSet<String> classNames = new HashSet<String>();
        for (Class clazz : instrumentation.getAllLoadedClasses()) {
            classNames.add(clazz.getName());
        }
        return classNames;
    }

    private static void checkDynamicallyLoadedClasses(Map<String, String> report) {
        if (instrumentation == null || baselineClasses.isEmpty()) {
            return;
        }
        Set<String> currentClasses = SystemMetricsCollector.getLoadedClassNames();
        for (String className : currentClasses) {
            if (baselineClasses.contains(className)) continue;
            report.put("Dynamic Class Load Detected", className);
            baselineClasses.add(className);
        }
    }

    private static void checkJvmArguments(Map<String, String> report) {
        RuntimeMXBean runtimeMxBean = ManagementFactory.getRuntimeMXBean();
        for (String arg : runtimeMxBean.getInputArguments()) {
            if (!arg.startsWith("-javaagent:") || arg.contains("BojarskyAgent")) continue;
            report.put("Incompatible JVM Argument", arg.substring("-javaagent:".length()));
        }
    }

    private static List<?> getProcessModules() {
        try {
            OSProcess currentProcess = OS.getProcess((int)CURRENT_PID);
            if (currentProcess == null) {
                return Collections.emptyList();
            }
            if (getModulesMethod == null) {
                getModulesMethod = currentProcess.getClass().getMethod("getModules", new Class[0]);
            }
            return (List)getModulesMethod.invoke((Object)currentProcess, new Object[0]);
        }
        catch (Exception e) {
            System.err.println("BojarskyAuth: Failed to get process modules via reflection. " + e.getMessage());
            return Collections.emptyList();
        }
    }

    private static String getModulePath(Object module) {
        if (module == null) {
            return "";
        }
        try {
            if (getPathMethod == null) {
                getPathMethod = module.getClass().getMethod("getPath", new Class[0]);
            }
            return ((String)getPathMethod.invoke(module, new Object[0])).toLowerCase();
        }
        catch (Exception e) {
            return "unknown-path";
        }
    }

    private static String getModulePublisher(Object module) {
        if (module == null) {
            return "";
        }
        try {
            if (getPublisherMethod == null) {
                getPublisherMethod = module.getClass().getMethod("getPublisher", new Class[0]);
            }
            return ((String)getPublisherMethod.invoke(module, new Object[0])).toLowerCase();
        }
        catch (Exception e) {
            return "unknown-publisher";
        }
    }

    private static void checkDynamicModules(Map<String, String> report) {
        List<?> currentModules = SystemMetricsCollector.getProcessModules();
        if (currentModules == null) {
            return;
        }
        for (Object module : currentModules) {
            String path = SystemMetricsCollector.getModulePath(module);
            if (baselineModules.contains(path)) continue;
            report.put("Dynamic Module Load Detected", "Path: " + path);
            baselineModules.add(path);
        }
    }

    public static Map<String, String> getInitialReportData() {
        return initialReportData;
    }

    private static void checkEnvironmentVariables(Map<String, String> report) {
        String dyldInsert;
        String ldPreload = System.getenv("LD_PRELOAD");
        if (ldPreload != null && !ldPreload.isEmpty()) {
            report.put("EnvVar Anomaly: LD_PRELOAD", ldPreload);
        }
        if ((dyldInsert = System.getenv("DYLD_INSERT_LIBRARIES")) != null && !dyldInsert.isEmpty()) {
            report.put("EnvVar Anomaly: DYLD_INSERT_LIBRARIES", dyldInsert);
        }
    }
}

